/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.scheduler;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.Job;
import org.dcache.srm.scheduler.CountByCreator;
import org.dcache.srm.scheduler.FatalJobFailure;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.ModifiableQueue;
import org.dcache.srm.scheduler.NonFatalJobFailure;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.scheduler.policies.DefaultJobAppraiser;
import org.dcache.srm.scheduler.policies.JobPriorityPolicyInterface;
import org.dcache.srm.util.JDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Scheduler
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(Scheduler.class);
    public static final int ON_RESTART_FAIL_REQUEST = 1;
    public static final int ON_RESTART_RESTORE_REQUEST = 2;
    public static final int ON_RESTART_WAIT_FOR_UPDATE_REQUEST = 3;
    public int restorePolicy = 3;
    private int maxThreadQueueSize = 1000;
    private final ModifiableQueue threadQueue;
    private final CountByCreator threadQueuedJobsNum = new CountByCreator();
    private final ModifiableQueue priorityThreadQueue;
    private final CountByCreator priorityThreadQueuedJobsNum = new CountByCreator();
    private int maxRunningByOwner = 10;
    private final CountByCreator runningStateJobsNum = new CountByCreator();
    private int maxRunningWithoutThreadByOwner = 10;
    private final CountByCreator runningWithoutThreadStateJobsNum = new CountByCreator();
    private int threadPoolSize = 30;
    private ThreadPoolExecutor pooledExecutor;
    private final CountByCreator runningThreadsNum = new CountByCreator();
    private int maxReadyQueueSize = 1000;
    private final CountByCreator readyQueuedJobsNum = new CountByCreator();
    private int maxReadyJobs = 60;
    private final CountByCreator readyJobsNum = new CountByCreator();
    private int maxAsyncWaitJobs = 1000;
    private final CountByCreator asyncWaitJobsNum = new CountByCreator();
    private int maxRetryWaitJobs = 1000;
    private int maxNumberOfRetries = 20;
    private long retryTimeout = 60000L;
    private final CountByCreator retryWaitJobsNum = new CountByCreator();
    private final CountByCreator restoredJobsNum = new CountByCreator();
    private String id;
    private volatile boolean running;
    private Thread thread;
    private final ModifiableQueue readyQueue;
    private Timer retryTimer;
    private boolean useFairness = true;
    private long timeStamp = System.currentTimeMillis();
    private long queuesUpdateMaxWait = 60000L;
    private static final Map<String, Scheduler> schedulers = new HashMap<String, Scheduler>();
    private JobPriorityPolicyInterface jobAppraiser;
    private String priorityPolicyPlugin = "DefaultJobAppraiser";
    private boolean notified;

    public static Scheduler getScheduler(String id) {
        return schedulers.get(id);
    }

    public Scheduler(String id) {
        if (id == null || id.equals("")) {
            throw new IllegalArgumentException(" need non-null non-empty string as an id");
        }
        this.id = id;
        schedulers.put(id, this);
        this.threadQueue = new ModifiableQueue("ThreadQueue", id, this.maxThreadQueueSize);
        this.priorityThreadQueue = new ModifiableQueue("PriorityThreadQueue", id, this.maxThreadQueueSize);
        this.readyQueue = new ModifiableQueue("ReadyQueue", id, this.maxReadyQueueSize);
        String className = "org.dcache.srm.scheduler.policies." + this.priorityPolicyPlugin;
        try {
            Class<JobPriorityPolicyInterface> appraiserClass = Class.forName(className).asSubclass(JobPriorityPolicyInterface.class);
            this.jobAppraiser = appraiserClass.newInstance();
        }
        catch (Exception e) {
            logger.error("failed to load " + className);
            this.jobAppraiser = new DefaultJobAppraiser();
        }
    }

    public synchronized void start() throws IllegalStateException {
        if (this.thread != null) {
            throw new IllegalStateException(" Scheduler is running ");
        }
        this.pooledExecutor = new ThreadPoolExecutor(this.threadPoolSize, this.threadPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1));
        this.retryTimer = new Timer();
        this.thread = new Thread((Runnable)this, "Scheduler-" + this.id);
        this.running = true;
        this.thread.start();
    }

    public synchronized void stop() {
        this.running = false;
        this.notified = true;
        this.retryTimer.cancel();
        this.pooledExecutor.shutdownNow();
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void schedule(Job job) throws IllegalStateException, InterruptedException, IllegalStateTransition {
        logger.debug("schedule is called for job with id=" + job.getId() + " in state=" + (Object)((Object)job.getState()));
        if (!this.running) {
            throw new IllegalStateException("scheduler is not running");
        }
        job.wlock();
        try {
            State state;
            block18: {
                block17: {
                    state = job.getState();
                    if (state != State.RESTORED && state != State.PENDING && state != State.ASYNCWAIT && state != State.RUNNINGWITHOUTTHREAD && state != State.RETRYWAIT) {
                        throw new IllegalStateException("can not schedule job in state =" + (Object)((Object)job.getState()));
                    }
                    if (state == State.PENDING) {
                        job.setScheduler(this.id, this.timeStamp);
                    }
                    if (state == State.PENDING || state == State.RESTORED) {
                        if (this.getTotalTQueued() >= this.maxThreadQueueSize) {
                            job.setState(State.FAILED, "too many jobs in the queue");
                            return;
                        }
                        job.setState(State.TQUEUED, "put on the thread queue");
                        if (this.threadQueue(job)) {
                            return;
                        }
                        job.setState(State.FAILED, "Thread queue is full");
                        return;
                    }
                    if (state == State.ASYNCWAIT || state == State.RETRYWAIT) break block17;
                    if (state != State.RUNNINGWITHOUTTHREAD) break block18;
                }
                logger.debug("putting job in a priority thread queue, which might block, job#" + job.getId());
                job.setState(State.PRIORITYTQUEUED, "in priority thread queue");
                if (!this.priorityQueue(job)) {
                    job.setState(State.FAILED, "Priority Thread Queue is full. Failing request");
                }
                logger.debug("done putting job in a priority thread queue");
                return;
            }
            logger.error("Job #" + job.getId() + " state is " + (Object)((Object)state) + " can not schedule!!!");
            job.setState(State.FAILED, "Job state is " + (Object)((Object)state) + " can not schedule!!!");
            return;
        }
        finally {
            job.wunlock();
        }
    }

    private void increaseNumberOfRunningState(Job job) {
        this.runningStateJobsNum.increment(job.getSubmitterId());
    }

    private void decreaseNumberOfRunningState(Job job) {
        this.runningStateJobsNum.decrement(job.getSubmitterId());
    }

    public int getRunningStateByCreator(Job job) {
        return this.runningStateJobsNum.getValue(job.getSubmitterId());
    }

    public int getTotalRunningState() {
        return this.runningStateJobsNum.getTotal();
    }

    private void increaseNumberOfRunningWithoutThreadState(Job job) {
        this.runningWithoutThreadStateJobsNum.increment(job.getSubmitterId());
    }

    private void decreaseNumberOfRunningWithoutThreadState(Job job) {
        this.runningWithoutThreadStateJobsNum.decrement(job.getSubmitterId());
    }

    public int getRunningWithoutThreadStateByCreator(Job job) {
        return this.runningWithoutThreadStateJobsNum.getValue(job.getSubmitterId());
    }

    public int getTotalRunningWithoutThreadState() {
        return this.runningWithoutThreadStateJobsNum.getTotal();
    }

    private void increaseNumberOfRunningThreads(Job job) {
        this.runningThreadsNum.increment(job.getSubmitterId());
    }

    private void decreaseNumberOfRunningThreads(Job job) {
        this.runningThreadsNum.decrement(job.getSubmitterId());
    }

    public int getRunningThreadsByCreator(Job job) {
        return this.runningThreadsNum.getValue(job.getSubmitterId());
    }

    public int getTotalRunningThreads() {
        return this.runningThreadsNum.getTotal();
    }

    private void increaseNumberOfTQueued(Job job) {
        this.threadQueuedJobsNum.increment(job.getSubmitterId());
    }

    private void decreaseNumberOfTQueued(Job job) {
        this.threadQueuedJobsNum.decrement(job.getSubmitterId());
    }

    public int getTQueuedByCreator(Job job) {
        return this.threadQueuedJobsNum.getValue(job.getSubmitterId());
    }

    public int getTotalTQueued() {
        return this.threadQueuedJobsNum.getTotal();
    }

    private void increaseNumberOfPriorityTQueued(Job job) {
        this.priorityThreadQueuedJobsNum.increment(job.getSubmitterId());
    }

    private void decreaseNumberOfPriorityTQueued(Job job) {
        this.priorityThreadQueuedJobsNum.decrement(job.getSubmitterId());
    }

    public int getPriorityTQueuedByCreator(Job job) {
        return this.priorityThreadQueuedJobsNum.getValue(job.getSubmitterId());
    }

    public int getTotalPriorityTQueued() {
        return this.priorityThreadQueuedJobsNum.getTotal();
    }

    private void increaseNumberOfReadyQueued(Job job) {
        this.readyQueuedJobsNum.increment(job.getSubmitterId());
    }

    private void decreaseNumberOfReadyQueued(Job job) {
        this.readyQueuedJobsNum.decrement(job.getSubmitterId());
    }

    public int getRQueuedByCreator(Job job) {
        return this.readyQueuedJobsNum.getValue(job.getSubmitterId());
    }

    public int getTotalRQueued() {
        return this.readyQueuedJobsNum.getTotal();
    }

    private void increaseNumberOfReady(Job job) {
        this.readyJobsNum.increment(job.getSubmitterId());
    }

    private void decreaseNumberOfReady(Job job) {
        this.readyJobsNum.decrement(job.getSubmitterId());
    }

    public int getReadyByCreator(Job job) {
        return this.readyJobsNum.getValue(job.getSubmitterId());
    }

    public int getTotalReady() {
        return this.readyJobsNum.getTotal();
    }

    private void increaseNumberOfRestored(Job job) {
        this.restoredJobsNum.increment(job.getSubmitterId());
    }

    private void decreaseNumberOfRestored(Job job) {
        this.restoredJobsNum.decrement(job.getSubmitterId());
    }

    public int getRestoredByCreator(Job job) {
        return this.restoredJobsNum.getValue(job.getSubmitterId());
    }

    public int getTotalRestored() {
        return this.restoredJobsNum.getTotal();
    }

    private void increaseNumberOfAsyncWait(Job job) {
        this.asyncWaitJobsNum.increment(job.getSubmitterId());
    }

    private void decreaseNumberOfAsyncWait(Job job) {
        this.asyncWaitJobsNum.decrement(job.getSubmitterId());
    }

    public int getAsyncWaitByCreator(Job job) {
        return this.asyncWaitJobsNum.getValue(job.getSubmitterId());
    }

    public int getTotalAsyncWait() {
        return this.asyncWaitJobsNum.getTotal();
    }

    private void increaseNumberOfRetryWait(Job job) {
        this.retryWaitJobsNum.increment(job.getSubmitterId());
    }

    private void decreaseNumberOfRetryWait(Job job) {
        this.retryWaitJobsNum.decrement(job.getSubmitterId());
    }

    public int getRetryWaitByCreator(Job job) {
        return this.retryWaitJobsNum.getValue(job.getSubmitterId());
    }

    public int getTotalRetryWait() {
        return this.retryWaitJobsNum.getTotal();
    }

    private void updatePriorityThreadQueue() throws SQLException, SRMInvalidRequestException, InterruptedException {
        while (true) {
            Job job = null;
            if (this.useFairness) {
                ModifiableQueue.ValueCalculator calc = new ModifiableQueue.ValueCalculator(){

                    @Override
                    public int calculateValue(int queueLength, int queuePosition, Job job) {
                        int numOfRunningBySameCreator = Scheduler.this.getRunningStateByCreator(job) + Scheduler.this.getRunningWithoutThreadStateByCreator(job);
                        int value = Scheduler.this.jobAppraiser.evaluateJobPriority(queueLength, queuePosition, numOfRunningBySameCreator, Scheduler.this.maxRunningByOwner, job);
                        try {
                            FileRequest req = (FileRequest)job;
                            logger.debug("UPDATEPRIORITYTHREADQUEUE ca " + req.getCredential());
                        }
                        catch (ClassCastException cce) {
                            logger.error("Failed to cast job to FileRequest", (Throwable)cce);
                        }
                        return value;
                    }
                };
                job = this.priorityThreadQueue.getGreatestValueObject(calc);
            }
            if (job == null) {
                job = this.priorityThreadQueue.peek();
            }
            if (job == null || this.getTotalRunningThreads() + this.getTotalRunningWithoutThreadState() > this.getThreadPoolSize()) break;
            logger.debug("updatePriorityThreadQueue(), found job id " + job.getId());
            if (job.getState() != State.PRIORITYTQUEUED) {
                logger.error("updatePriorityThreadQueue() : found a job in priority thread queue with a state different from PRIORITYTQUEUED, job id=" + job.getId() + " state=" + (Object)((Object)job.getState()));
                this.priorityThreadQueue.remove(job);
                continue;
            }
            try {
                logger.debug("updatePriorityThreadQueue ()  executing job id=" + job.getId());
                JobWrapper wrapper = new JobWrapper(job);
                this.pooledExecutor.execute(wrapper);
                logger.debug("updatePriorityThreadQueue() waiting startup");
                wrapper.waitStartup();
                logger.debug("updatePriorityThreadQueue() job started");
            }
            catch (RejectedExecutionException ree) {
                logger.debug("updatePriorityThreadQueue() cannot execute job id=" + job.getId() + " at this time: RejectedExecutionException");
                return;
            }
            catch (RuntimeException re) {
                logger.debug("updatePriorityThreadQueue() cannot execute job id=" + job.getId() + " at this time");
                return;
            }
        }
    }

    private void updateThreadQueue() throws SQLException, SRMInvalidRequestException, InterruptedException {
        while (true) {
            Job job = null;
            if (this.useFairness) {
                ModifiableQueue.ValueCalculator calc = new ModifiableQueue.ValueCalculator(){

                    @Override
                    public int calculateValue(int queueLength, int queuePosition, Job job) {
                        int numOfRunningBySameCreator = Scheduler.this.getRunningStateByCreator(job) + Scheduler.this.getRunningWithoutThreadStateByCreator(job);
                        int value = Scheduler.this.jobAppraiser.evaluateJobPriority(queueLength, queuePosition, numOfRunningBySameCreator, Scheduler.this.maxRunningByOwner, job);
                        return value;
                    }
                };
                job = this.threadQueue.getGreatestValueObject(calc);
            }
            if (job == null) {
                job = this.threadQueue.peek();
            }
            if (job == null || this.getTotalRunningThreads() + this.getTotalRunningWithoutThreadState() > this.getThreadPoolSize()) break;
            logger.debug("updateThreadQueue(), found job id " + job.getId());
            State state = job.getState();
            if (state != State.TQUEUED) {
                logger.error("updateThreadQueue() : found a job in thread queue with a state different from TQUEUED, job id=" + job.getId() + " state=" + (Object)((Object)job.getState()));
                this.threadQueue.remove(job);
                continue;
            }
            try {
                logger.debug("updateThreadQueue() executing job id=" + job.getId());
                JobWrapper wrapper = new JobWrapper(job);
                this.pooledExecutor.execute(wrapper);
                logger.debug("updateThreadQueue() waiting startup");
                wrapper.waitStartup();
                logger.debug("updateThreadQueue() job started");
            }
            catch (RejectedExecutionException ree) {
                logger.debug("updatePriorityThreadQueue() cannot execute job id=" + job.getId() + " at this time: RejectedExecutionException");
                return;
            }
            catch (RuntimeException ie) {
                logger.error("updateThreadQueue() cannot execute job id=" + job.getId() + " at this time");
                return;
            }
        }
    }

    public void tryToReadyJob(Job job) {
        if (this.getTotalReady() >= this.maxReadyJobs) {
            return;
        }
        try {
            job.setState(State.READY, "execution succeeded");
        }
        catch (IllegalStateTransition ist) {
            logger.error("Illegal State Transition : " + ist.getMessage());
        }
    }

    private void updateReadyQueue() throws SQLException, SRMInvalidRequestException {
        while (this.getTotalReady() < this.maxReadyJobs) {
            Job job = null;
            if (this.useFairness) {
                ModifiableQueue.ValueCalculator calc = new ModifiableQueue.ValueCalculator(){

                    @Override
                    public int calculateValue(int queueLength, int queuePosition, Job job) {
                        int numOfReadyBySameCreator = Scheduler.this.getReadyByCreator(job);
                        int value = Scheduler.this.jobAppraiser.evaluateJobPriority(queueLength, queuePosition, numOfReadyBySameCreator, Scheduler.this.maxReadyJobs, job);
                        return value;
                    }
                };
                job = this.readyQueue.getGreatestValueObject(calc);
            }
            if (job == null) {
                job = this.readyQueue.peek();
            }
            if (job == null) {
                return;
            }
            logger.debug("updateReadyQueue(), found job id " + job.getId());
            this.tryToReadyJob(job);
        }
        return;
    }

    private boolean threadQueue(Job job) throws InterruptedException {
        if (this.threadQueue.offer(job, 0L)) {
            this.jobAddedToQueue();
            return true;
        }
        return false;
    }

    private boolean priorityQueue(Job job) throws InterruptedException {
        if (this.priorityThreadQueue.offer(job, 0L)) {
            this.jobAddedToQueue();
            return true;
        }
        return false;
    }

    private boolean readyQueue(Job job) throws InterruptedException {
        if (this.readyQueue.offer(job, 0L)) {
            this.jobAddedToQueue();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jobAddedToQueue() {
        Scheduler scheduler = this;
        synchronized (scheduler) {
            this.notifyAll();
            this.notified = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.running) {
                try {
                    this.updatePriorityThreadQueue();
                    this.updateThreadQueue();
                    Scheduler scheduler = this;
                    synchronized (scheduler) {
                        if (!this.notified) {
                            this.wait(this.queuesUpdateMaxWait);
                        }
                        this.notified = false;
                    }
                }
                catch (SQLException e) {
                    logger.error("Sheduler(id={}) detected a database error: {}", (Object)this.getId(), (Object)e.toString());
                }
                catch (SRMInvalidRequestException e) {
                    logger.error("Sheduler(id={}) detected an SRM error: {}", (Object)this.getId(), (Object)e.toString());
                }
                catch (RuntimeException e) {
                    logger.error("Sheduler(id=" + this.getId() + ") detected a bug", (Throwable)e);
                }
            }
        }
        catch (InterruptedException e) {
            logger.error("Sheduler(id=" + this.getId() + ") terminating update thread, since it caught an InterruptedException", (Throwable)e);
        }
    }

    private void startRetryTimer(final Job job) {
        TimerTask task = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                job.wlock();
                try {
                    State s = job.getState();
                    if (s != State.RETRYWAIT) {
                        logger.error("retryTimer expired, but job state is " + (Object)((Object)s));
                        return;
                    }
                    try {
                        job.setState(State.PRIORITYTQUEUED, "retrying job, putting on priority queue");
                        if (!Scheduler.this.priorityQueue(job)) {
                            job.setState(State.FAILED, "Priority Thread Queue is full. Failing request");
                        }
                    }
                    catch (InterruptedException ie) {
                        try {
                            job.setState(State.FAILED, "scheduler is interrupted");
                        }
                        catch (IllegalStateTransition ist) {
                            logger.error("Illegal State Transition : " + ist.getMessage());
                        }
                    }
                    catch (IllegalStateTransition ist) {
                        logger.error("can not retry: Illegal State Transition : " + ist.getMessage());
                        try {
                            job.setState(State.FAILED, "scheduler is interrupted");
                        }
                        catch (IllegalStateTransition ist1) {
                            logger.error("Illegal State Transition : " + ist1.getMessage());
                        }
                    }
                }
                finally {
                    job.wunlock();
                }
            }
        };
        job.setRetryTimer(task);
        this.retryTimer.schedule(task, this.retryTimeout);
    }

    public void stateChanged(Job job, State oldState, State newState) {
        TimerTask task;
        if (job == null) {
            logger.error("stateChanged job is null!!!");
            return;
        }
        if (newState == State.TQUEUED) {
            this.increaseNumberOfTQueued(job);
        } else if (newState == State.PRIORITYTQUEUED) {
            this.increaseNumberOfPriorityTQueued(job);
        } else if (newState == State.RUNNING) {
            this.increaseNumberOfRunningState(job);
        } else if (newState == State.RQUEUED) {
            this.increaseNumberOfReadyQueued(job);
        } else if (newState == State.READY || newState == State.TRANSFERRING) {
            this.increaseNumberOfReady(job);
        } else if (newState == State.ASYNCWAIT) {
            this.increaseNumberOfAsyncWait(job);
        } else if (newState == State.RETRYWAIT) {
            this.increaseNumberOfRetryWait(job);
        } else if (newState == State.RUNNINGWITHOUTTHREAD) {
            this.increaseNumberOfRunningWithoutThreadState(job);
        }
        if (oldState == State.RESTORED) {
            this.decreaseNumberOfRestored(job);
        } else if (oldState == State.TQUEUED) {
            this.threadQueue.remove(job);
            this.decreaseNumberOfTQueued(job);
        } else if (oldState == State.PRIORITYTQUEUED) {
            this.priorityThreadQueue.remove(job);
            this.decreaseNumberOfPriorityTQueued(job);
        } else if (oldState == State.RUNNING) {
            this.decreaseNumberOfRunningState(job);
        } else if (oldState == State.RQUEUED) {
            this.readyQueue.remove(job);
            this.decreaseNumberOfReadyQueued(job);
        } else if (oldState == State.READY || oldState == State.TRANSFERRING) {
            this.decreaseNumberOfReady(job);
        } else if (oldState == State.ASYNCWAIT) {
            this.decreaseNumberOfAsyncWait(job);
        } else if (oldState == State.RETRYWAIT) {
            this.decreaseNumberOfRetryWait(job);
        } else if (oldState == State.RUNNINGWITHOUTTHREAD) {
            this.decreaseNumberOfRunningWithoutThreadState(job);
        }
        logger.debug("state changed for job id " + job.getId() + " from " + (Object)((Object)oldState) + " to " + (Object)((Object)newState));
        if ((newState == State.DONE || newState == State.CANCELED || newState == State.FAILED) && oldState == State.RETRYWAIT && (task = job.getRetryTimer()) != null) {
            task.cancel();
            job.setRetryTimer(null);
        }
    }

    public boolean isUseFairness() {
        return this.useFairness;
    }

    public void setUseFairness(boolean useFairness) {
        this.useFairness = useFairness;
    }

    public void setJobAppraiser(JobPriorityPolicyInterface jobAppraiser) {
        this.jobAppraiser = jobAppraiser;
    }

    public String getId() {
        return this.id;
    }

    public synchronized int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public synchronized void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
        if (this.thread != null) {
            this.pooledExecutor.setMaximumPoolSize(threadPoolSize);
        }
    }

    public int getMaxReadyJobs() {
        return this.maxReadyJobs;
    }

    public void setMaxReadyJobs(int maxReadyJobs) {
        this.maxReadyJobs = maxReadyJobs;
    }

    public int getMaxRunningByOwner() {
        return this.maxRunningByOwner;
    }

    public void setMaxRunningByOwner(int maxRunningByOwner) {
        this.maxRunningByOwner = maxRunningByOwner;
    }

    public int getMaxThreadQueueSize() {
        return this.maxThreadQueueSize;
    }

    public void setMaxThreadQueueSize(int maxThreadQueueSize) {
        this.maxThreadQueueSize = maxThreadQueueSize;
        this.threadQueue.setCapacity(maxThreadQueueSize);
        this.priorityThreadQueue.setCapacity(maxThreadQueueSize);
    }

    public int getMaxAsyncWaitJobNum() {
        return this.maxAsyncWaitJobs;
    }

    public void setMaxWaitingJobNum(int maxAsyncWaitJobs) {
        this.maxAsyncWaitJobs = maxAsyncWaitJobs;
    }

    public int getMaxRetryWaitJobNum() {
        return this.maxRetryWaitJobs;
    }

    public void setMaxRetryWaitJobNum(int maxRetryWaitJobs) {
        this.maxRetryWaitJobs = maxRetryWaitJobs;
    }

    public int getMaxNumberOfRetries() {
        return this.maxNumberOfRetries;
    }

    public void setMaxNumberOfRetries(int maxNumberOfRetries) {
        this.maxNumberOfRetries = maxNumberOfRetries;
    }

    public long getRetryTimeout() {
        return this.retryTimeout;
    }

    public void setRetryTimeout(long retryTimeout) {
        this.retryTimeout = retryTimeout;
    }

    public int getMaxReadyQueueSize() {
        return this.maxReadyQueueSize;
    }

    public void setMaxReadyQueueSize(int maxReadyQueueSize) {
        this.maxReadyQueueSize = maxReadyQueueSize;
        this.readyQueue.setCapacity(maxReadyQueueSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.getInfo(sb);
        return sb.toString();
    }

    public void getInfo(StringBuilder sb) {
        sb.append("Scheduler id=").append(this.id).append('\n');
        sb.append("          useFairness=").append(this.useFairness).append('\n');
        sb.append("          asyncWaitJobsNum=").append(this.getTotalAsyncWait()).append('\n');
        sb.append("          maxAsyncWaitJobsNum=").append(this.maxAsyncWaitJobs).append('\n');
        sb.append("          retryWaitJobsNum=").append(this.getTotalRetryWait()).append('\n');
        sb.append("          maxRetryWaitJobsNum=").append(this.maxRetryWaitJobs).append('\n');
        sb.append("          readyJobsNum=").append(this.getTotalReady()).append('\n');
        sb.append("          maxReadyJobs=").append(this.maxReadyJobs).append('\n');
        sb.append("          max number of jobs Running By the same owner=").append(this.maxRunningByOwner).append('\n');
        sb.append("          total number of jobs in Running State =").append(this.getTotalRunningState()).append('\n');
        sb.append("          total number of jobs in RunningWithoutThread State =").append(this.getTotalRunningWithoutThreadState()).append('\n');
        sb.append("          threadPoolSize=").append(this.getThreadPoolSize()).append('\n');
        sb.append("          total number of threads running =").append(this.getTotalRunningThreads()).append('\n');
        sb.append("          retryTimeout=").append(this.retryTimeout).append('\n');
        sb.append("          maxThreadQueueSize=").append(this.maxThreadQueueSize).append('\n');
        sb.append("          threadQueue size=").append(this.threadQueue.size()).append('\n');
        sb.append("          !!! threadQueued=").append(this.getTotalTQueued()).append('\n');
        sb.append("          priorityThreadQueue size=").append(this.priorityThreadQueue.size()).append('\n');
        sb.append("          !!! priorityThreadQueued=").append(this.getTotalPriorityTQueued()).append('\n');
        sb.append("          maxReadyQueueSize=").append(this.maxReadyQueueSize).append('\n');
        sb.append("          readyQueue size=").append(this.readyQueue.size()).append('\n');
        sb.append("          !!! readyQueued=").append(this.getTotalRQueued()).append('\n');
        sb.append("          maxNumberOfRetries=").append(this.maxNumberOfRetries).append('\n');
        sb.append("          number of restored but not scheduled=").append(this.getTotalRestored()).append('\n');
        sb.append("          restorePolicy");
        switch (this.restorePolicy) {
            case 1: {
                sb.append(" fail saved request on restart\n");
                break;
            }
            case 2: {
                sb.append(" restore saved request on restart\n");
                break;
            }
            case 3: {
                sb.append(" wait for client update before restoring of saved requests on restart\n");
            }
        }
    }

    public void printThreadQueue(StringBuilder sb) throws SQLException {
        sb.append("ThreadQueue :\n");
        this.threadQueue.printQueue(sb);
    }

    public void printPriorityThreadQueue(StringBuilder sb) throws SQLException {
        sb.append("PriorityThreadQueue :\n");
        this.priorityThreadQueue.printQueue(sb);
    }

    public void printReadyQueue(StringBuilder sb) throws SQLException {
        sb.append("ReadyQueue :\n");
        this.readyQueue.printQueue(sb);
    }

    public long getQueuesUpdateMaxWait() {
        return this.queuesUpdateMaxWait;
    }

    public void setQueuesUpdateMaxWait(long queuesUpdateMaxWait) {
        this.queuesUpdateMaxWait = queuesUpdateMaxWait;
    }

    public void setPriorityPolicyPlugin(String txt) {
        this.priorityPolicyPlugin = txt;
        String className = "org.dcache.srm.scheduler.policies." + this.priorityPolicyPlugin;
        try {
            Class<JobPriorityPolicyInterface> appraiserClass = Class.forName(className).asSubclass(JobPriorityPolicyInterface.class);
            this.jobAppraiser = appraiserClass.newInstance();
        }
        catch (Exception e) {
            logger.error("failed to load " + className);
            this.jobAppraiser = new DefaultJobAppraiser();
        }
    }

    public String getPriorityPolicyPlugin() {
        return this.priorityPolicyPlugin;
    }

    private class JobWrapper
    implements Runnable {
        Job job;
        boolean started;

        public JobWrapper(Job job) {
            this.job = job;
        }

        public synchronized void waitStartup() throws InterruptedException {
            for (int i = 0; i < 10; ++i) {
                if (this.started) {
                    return;
                }
                this.wait(1000L);
            }
        }

        private synchronized void started() {
            this.started = true;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block74: {
                this.job.applyJdc();
                try {
                    Object state;
                    block73: {
                        Scheduler.this.increaseNumberOfRunningThreads(this.job);
                        logger.debug("Scheduler(id=" + Scheduler.this.getId() + ") JobWrapper(" + this.job.getId() + ") entering sync(job) block");
                        this.job.wlock();
                        logger.debug("Scheduler(id=" + Scheduler.this.getId() + ") JobWrapper(" + this.job.getId() + ") entered sync(job) block");
                        state = this.job.getState();
                        logger.debug("Scheduler(id=" + Scheduler.this.getId() + ") JobWrapper run() running job with id=" + this.job.getId() + " in state=" + (Object)state);
                        if (state == State.CANCELED || state == State.FAILED) {
                            logger.debug("Scheduler(id=" + Scheduler.this.getId() + ") JobWrapper(" + this.job.getId() + ") returning");
                            return;
                        }
                        if (state == State.PENDING || state == State.TQUEUED || state == State.PRIORITYTQUEUED) {
                            try {
                                logger.debug("Scheduler(id=" + Scheduler.this.getId() + ") JobWrapper(" + this.job.getId() + ") changing job state to runinng");
                                this.job.setState(State.RUNNING, " executing ", false);
                                this.started();
                                this.job.saveJob();
                                break block73;
                            }
                            catch (IllegalStateTransition ist) {
                                logger.error("Illegal State Transition : " + ist.getMessage());
                                this.job.wunlock();
                                this.started();
                                Scheduler.this.decreaseNumberOfRunningThreads(this.job);
                                Scheduler scheduler = Scheduler.this;
                                synchronized (scheduler) {
                                    Scheduler.this.notifyAll();
                                    Scheduler.this.notified = true;
                                }
                                JDC.clear();
                                return;
                            }
                        }
                        if (state == State.ASYNCWAIT || state == State.RETRYWAIT) {
                            try {
                                logger.debug("Scheduler(id=" + Scheduler.this.getId() + ") JobWrapper(" + this.job.getId() + ") changing job state to runinng");
                                this.job.setState(State.RUNNING, " executing ", false);
                                this.started();
                                this.job.saveJob();
                                break block73;
                            }
                            catch (IllegalStateTransition ist) {
                                logger.error("Illegal State Transition : " + ist.getMessage());
                                this.job.wunlock();
                                this.started();
                                Scheduler.this.decreaseNumberOfRunningThreads(this.job);
                                Scheduler scheduler = Scheduler.this;
                                synchronized (scheduler) {
                                    Scheduler.this.notifyAll();
                                    Scheduler.this.notified = true;
                                }
                                JDC.clear();
                                return;
                            }
                        }
                        logger.error("Scheduler(id=" + Scheduler.this.getId() + ") JobWrapper(" + this.job.getId() + ") job is in state " + (Object)state + "; can not execute, returning");
                        return;
                        finally {
                            this.job.wunlock();
                        }
                    }
                    logger.debug("Scheduler(id=" + Scheduler.this.getId() + ") JobWrapper(" + this.job.getId() + ") exited sync block");
                    Exception exception = null;
                    try {
                        logger.debug("Scheduler(id=" + Scheduler.this.getId() + ") JobWrapper(" + this.job.getId() + ") calling job.run()");
                        this.job.run();
                        logger.debug("Scheduler(id=" + Scheduler.this.getId() + ") JobWrapper(" + this.job.getId() + ") job.run() returned");
                    }
                    catch (RuntimeException | FatalJobFailure | NonFatalJobFailure e) {
                        exception = e;
                    }
                    this.job.wlock();
                    try {
                        if (exception == null) {
                            state = this.job.getState();
                            if (state == State.DONE) {
                                break block74;
                            }
                            if (state != State.RUNNING) break block74;
                            try {
                                this.job.setState(State.RQUEUED, "putting on a \"Ready\" Queue");
                                if (!Scheduler.this.readyQueue(this.job)) {
                                    this.job.setState(State.FAILED, "All Ready slots are taken and Ready Thread Queue is full. Failing request");
                                }
                                break block74;
                            }
                            catch (InterruptedException ie) {
                                try {
                                    this.job.setState(State.FAILED, "InterruptedException while putting on the ready queue");
                                    break block74;
                                }
                                catch (IllegalStateTransition ist) {
                                    logger.error("Illegal State Transition : " + ist.getMessage());
                                }
                            }
                            catch (IllegalStateTransition ist) {
                                logger.error("Illegal State Transition : " + ist.getMessage());
                            }
                            break block74;
                        }
                        if (exception instanceof NonFatalJobFailure) {
                            NonFatalJobFailure failure = (NonFatalJobFailure)exception;
                            if (this.job.getNumberOfRetries() < Scheduler.this.maxNumberOfRetries && this.job.getNumberOfRetries() < this.job.getMaxNumberOfRetries()) {
                                try {
                                    this.job.setState(State.RETRYWAIT, " nonfatal error [" + exception.toString() + "] retrying");
                                }
                                catch (IllegalStateTransition ist) {
                                    logger.error("Illegal State Transition : " + ist.getMessage());
                                    this.job.wunlock();
                                    this.started();
                                    Scheduler.this.decreaseNumberOfRunningThreads(this.job);
                                    Scheduler scheduler = Scheduler.this;
                                    synchronized (scheduler) {
                                        Scheduler.this.notifyAll();
                                        Scheduler.this.notified = true;
                                    }
                                    JDC.clear();
                                    return;
                                }
                                Scheduler.this.startRetryTimer(this.job);
                                break block74;
                            }
                            try {
                                this.job.setState(State.FAILED, "number of retries exceeded: " + failure.toString());
                            }
                            catch (IllegalStateTransition ist) {
                                logger.error("Illegal State Transition : " + ist.getMessage());
                            }
                            break block74;
                        }
                        if (exception instanceof FatalJobFailure) {
                            FatalJobFailure failure = (FatalJobFailure)exception;
                            try {
                                this.job.setState(State.FAILED, failure.getMessage());
                            }
                            catch (IllegalStateTransition ist) {
                                logger.error("Illegal State Transition : " + ist.getMessage());
                            }
                        } else {
                            try {
                                logger.error("Bug detected by SRM Scheduler", (Throwable)exception);
                                this.job.setState(State.FAILED, "Internal error: " + exception.toString());
                            }
                            catch (IllegalStateTransition ist) {
                                logger.error("Illegal State Transition : {}", (Object)ist.getMessage());
                            }
                        }
                    }
                    finally {
                        this.job.wunlock();
                    }
                }
                catch (Throwable t) {
                    logger.error(t.toString());
                }
                finally {
                    this.started();
                    Scheduler.this.decreaseNumberOfRunningThreads(this.job);
                    Scheduler scheduler = Scheduler.this;
                    synchronized (scheduler) {
                        Scheduler.this.notifyAll();
                        Scheduler.this.notified = true;
                    }
                    JDC.clear();
                }
            }
        }
    }
}

