/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.scheduler;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.request.Job;

public class ModifiableQueue {
    String name;
    String scheduler_name;
    private int capacity = 1024;
    private final List<Long> queue = new LinkedList<Long>();

    public ModifiableQueue(String name, String scheduler_name, int capacity) {
        this.name = name;
        this.scheduler_name = scheduler_name;
        this.capacity = capacity;
    }

    public ModifiableQueue(String name, String scheduler_name) {
        this(name, scheduler_name, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List<Long> list = this.queue;
        synchronized (list) {
            return this.queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job peek() throws SQLException, SRMInvalidRequestException {
        Long headId;
        List<Long> list = this.queue;
        synchronized (list) {
            if (this.queue.isEmpty()) {
                return null;
            }
            headId = this.queue.get(0);
        }
        return Job.getJob(headId, Job.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job take() throws InterruptedException, SQLException, SRMInvalidRequestException {
        while (true) {
            Long id = null;
            List<Long> list = this.queue;
            synchronized (list) {
                if (!this.queue.isEmpty()) {
                    id = this.queue.remove(0);
                    this.queue.notifyAll();
                }
                if (id != null) {
                    return Job.getJob(id, Job.class);
                }
                try {
                    this.queue.wait();
                }
                catch (InterruptedException ie) {
                    this.queue.notify();
                    throw ie;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job poll(long msecs) throws InterruptedException, SQLException, SRMInvalidRequestException {
        long waitTime = msecs;
        long start = msecs <= 0L ? 0L : System.currentTimeMillis();
        while (true) {
            Long id = null;
            List<Long> list = this.queue;
            synchronized (list) {
                if (!this.queue.isEmpty()) {
                    id = this.queue.remove(0);
                    this.queue.notifyAll();
                }
                if (id != null) {
                    return Job.getJob(id, Job.class);
                }
                if (waitTime <= 0L) {
                    return null;
                }
                try {
                    this.queue.wait(waitTime);
                }
                catch (InterruptedException ie) {
                    this.queue.notify();
                    throw ie;
                }
            }
            waitTime = msecs - (System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Job job) throws InterruptedException {
        if (job == null) {
            throw new IllegalArgumentException("job is null");
        }
        Long id = job.getId();
        while (true) {
            List<Long> list = this.queue;
            synchronized (list) {
                if (this.queue.size() < this.capacity) {
                    this.queue.add(id);
                    this.queue.notifyAll();
                    return;
                }
                try {
                    this.queue.wait();
                }
                catch (InterruptedException ie) {
                    this.queue.notify();
                    throw ie;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Job job, long msecs) throws InterruptedException {
        if (job == null) {
            throw new IllegalArgumentException("job is null");
        }
        long waitTime = msecs;
        long start = msecs <= 0L ? 0L : System.currentTimeMillis();
        Long id = job.getId();
        while (true) {
            List<Long> list = this.queue;
            synchronized (list) {
                if (this.queue.size() < this.capacity) {
                    this.queue.add(id);
                    this.queue.notifyAll();
                    return true;
                }
                if (waitTime <= 0L) {
                    return false;
                }
                try {
                    this.queue.wait(waitTime);
                }
                catch (InterruptedException ie) {
                    this.queue.notify();
                    throw ie;
                }
                waitTime = msecs - (System.currentTimeMillis() - start);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        List<Long> list = this.queue;
        synchronized (list) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job remove(Job job) {
        if (job == null) {
            return null;
        }
        Long id = job.getId();
        List<Long> list = this.queue;
        synchronized (list) {
            boolean found = this.queue.contains(id);
            while (this.queue.contains(id)) {
                this.queue.remove(id);
            }
            if (found) {
                this.queue.notifyAll();
                return job;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCapacity(int newCapacity) {
        List<Long> list = this.queue;
        synchronized (list) {
            this.capacity = newCapacity;
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job getGreatestValueObject(ValueCalculator calc) throws SQLException, SRMInvalidRequestException {
        ArrayList<Long> queueCopy;
        List<Long> list = this.queue;
        synchronized (list) {
            if (this.queue.isEmpty()) {
                return null;
            }
            queueCopy = new ArrayList<Long>(this.queue);
        }
        Job greatestValueJob = null;
        int greatestValue = Integer.MIN_VALUE;
        int index = 0;
        int size = queueCopy.size();
        for (Long currentJobId : queueCopy) {
            Job currentJob = Job.getJob(currentJobId, Job.class);
            int currentValue = calc.calculateValue(size, index, currentJob);
            if (currentValue > greatestValue) {
                greatestValueJob = currentJob;
                greatestValue = currentValue;
            }
            ++index;
        }
        return greatestValueJob;
    }

    public String printQueue() throws SQLException {
        StringBuilder sb = new StringBuilder();
        this.printQueue(sb);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printQueue(StringBuilder sb) throws SQLException {
        List<Long> list = this.queue;
        synchronized (list) {
            if (this.queue.isEmpty()) {
                sb.append("Queue is empty\n");
                return;
            }
            int index = 0;
            for (Long nextId : this.queue) {
                sb.append("queue element # ").append(index).append(" : ").append(nextId).append('\n');
                ++index;
            }
        }
    }

    public static interface ValueCalculator {
        public int calculateValue(int var1, int var2, Job var3);
    }
}

