/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.scheduler;

import java.util.HashMap;
import java.util.Map;

public class CountByCreator {
    private final Map<String, Integer> _counters = new HashMap<String, Integer>();
    private int _total;

    public synchronized void increment(String creatorId) {
        ++this._total;
        Integer value = this._counters.get(creatorId);
        if (value == null) {
            this._counters.put(creatorId, 1);
        } else {
            this._counters.put(creatorId, value + 1);
        }
    }

    public synchronized void decrement(String creatorId) {
        Integer value = this._counters.get(creatorId);
        if (value != null) {
            --this._total;
            if (value > 1) {
                this._counters.put(creatorId, value - 1);
            } else {
                this._counters.remove(creatorId);
            }
        }
    }

    public synchronized int getValue(String creator) {
        Integer value = this._counters.get(creator);
        return value == null ? 0 : value;
    }

    public synchronized int getTotal() {
        return this._total;
    }
}

