/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.dcache.srm.request.sql.JdbcConnectionPool;
import org.dcache.srm.request.sql.Utilities;
import org.dcache.srm.scheduler.JobIdGenerator;
import org.dcache.srm.scheduler.JobIdGeneratorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestsPropertyStorage
extends JobIdGeneratorFactory
implements JobIdGenerator {
    private String jdbcUrl;
    private String jdbcClass;
    private String user;
    private String pass;
    private String nextRequestIdTableName;
    private static Logger logger = LoggerFactory.getLogger(RequestsPropertyStorage.class);
    private int nextIntBase;
    private static int NEXT_INT_STEP = 1000;
    private int nextIntIncrement = NEXT_INT_STEP;
    private long nextLongBase;
    private static long NEXT_LONG_STEP = 10000L;
    private long nextLongIncrement = NEXT_LONG_STEP;
    private static RequestsPropertyStorage requestsPropertyStorage;
    JdbcConnectionPool pool;
    int _nextIntBase;
    private final SimpleDateFormat dateformat = new SimpleDateFormat("yyMMddHHmmssSSSSZ");
    long _nextLongBase;

    private RequestsPropertyStorage(String jdbcUrl, String jdbcClass, String user, String pass, String nextRequestIdTableName) {
        this.jdbcUrl = jdbcUrl;
        this.jdbcClass = jdbcClass;
        this.user = user;
        this.pass = pass;
        this.nextRequestIdTableName = nextRequestIdTableName;
        try {
            this.dbInit();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }

    public void say(String s) {
        logger.debug(" RequestsPropertyStorage: " + s);
    }

    public void esay(String s) {
        logger.error(" RequestsPropertyStorage: " + s);
    }

    public void esay(Throwable t) {
        logger.error("RequestsPropertyStorage", t);
    }

    private void dbInit() throws SQLException {
        Connection _con = null;
        try {
            this.pool = JdbcConnectionPool.getPool(this.jdbcUrl, this.jdbcClass, this.user, this.pass);
            _con = this.pool.getConnection();
            _con.setAutoCommit(true);
            DatabaseMetaData md = _con.getMetaData();
            String tableNameAsStored = Utilities.getIdentifierAsStored(md, this.nextRequestIdTableName);
            ResultSet tableRs = md.getTables(null, null, tableNameAsStored, null);
            if (!tableRs.next()) {
                try {
                    String createTable = "CREATE TABLE " + this.nextRequestIdTableName + "(" + "NEXTINT INTEGER ,NEXTLONG BIGINT)";
                    this.say(this.nextRequestIdTableName + " does not exits");
                    Statement s = _con.createStatement();
                    this.say("dbInit trying " + createTable);
                    int result = s.executeUpdate(createTable);
                    s.close();
                    String select = "SELECT * FROM " + this.nextRequestIdTableName;
                    s = _con.createStatement();
                    ResultSet set = s.executeQuery(select);
                    if (!set.next()) {
                        s.close();
                        String insert = "INSERT INTO " + this.nextRequestIdTableName + " VALUES (" + Integer.MIN_VALUE + ", " + Long.MIN_VALUE + ")";
                        s = _con.createStatement();
                        this.say("dbInit trying " + insert);
                        result = s.executeUpdate(insert);
                        s.close();
                    } else {
                        s.close();
                        this.say("dbInit set.next() returned nonnull");
                    }
                }
                catch (SQLException sqle) {
                    this.esay(sqle);
                    this.say("relation could already exist");
                }
            }
            _con.setAutoCommit(false);
            this.pool.returnConnection(_con);
            _con = null;
        }
        catch (SQLException sqe) {
            if (_con != null) {
                this.pool.returnFailedConnection(_con);
                _con = null;
            }
            throw sqe;
        }
        catch (Exception ex) {
            if (_con != null) {
                this.pool.returnFailedConnection(_con);
                _con = null;
            }
            throw new SQLException(ex.toString());
        }
        finally {
            if (_con != null) {
                _con.setAutoCommit(false);
                this.pool.returnConnection(_con);
            }
        }
    }

    public int getNextRequestId() {
        return this.nextInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int nextInt() {
        if (this.nextIntIncrement >= NEXT_INT_STEP) {
            this.nextIntIncrement = 0;
            Connection _con = null;
            try {
                _con = this.pool.getConnection();
                String select_for_update = "SELECT * from " + this.nextRequestIdTableName + " FOR UPDATE ";
                Statement s = _con.createStatement();
                this.say("nextInt trying " + select_for_update);
                ResultSet set = s.executeQuery(select_for_update);
                if (!set.next()) {
                    s.close();
                    throw new SQLException("table " + this.nextRequestIdTableName + " is empty!!!");
                }
                this.nextIntBase = set.getInt(1);
                s.close();
                this.say("nextIntBase is =" + this.nextIntBase);
                String increase_nextint = "UPDATE " + this.nextRequestIdTableName + " SET NEXTINT=NEXTINT+" + NEXT_INT_STEP;
                s = _con.createStatement();
                this.say("executing statement: " + increase_nextint);
                int i = s.executeUpdate(increase_nextint);
                s.close();
                _con.commit();
                this.pool.returnConnection(_con);
                _con = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    _con.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.nextIntBase = this._nextIntBase;
            }
            finally {
                if (_con != null) {
                    this.pool.returnConnection(_con);
                }
            }
            this._nextIntBase = this.nextIntBase + NEXT_INT_STEP;
        }
        int nextInt = this.nextIntBase + this.nextIntIncrement++;
        this.say(" return nextInt=" + nextInt);
        return nextInt;
    }

    public String nextUniqueToken() throws SQLException {
        long nextLong = this.nextLong();
        return this.dateformat.format(new Date()) + "-" + nextLong;
    }

    @Override
    public Long getNextId() {
        return this.nextInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long nextLong() {
        if (this.nextLongIncrement >= NEXT_LONG_STEP) {
            this.nextLongIncrement = 0L;
            Connection _con = null;
            String select_for_update = "SELECT * from " + this.nextRequestIdTableName + " FOR UPDATE ";
            try {
                _con = this.pool.getConnection();
                Statement s = _con.createStatement();
                this.say("nextLong trying " + select_for_update);
                ResultSet set = s.executeQuery(select_for_update);
                if (!set.next()) {
                    s.close();
                    throw new SQLException("table " + this.nextRequestIdTableName + " is empty!!!");
                }
                this.nextLongBase = set.getLong(2);
                s.close();
                this.say("nextLongBase is =" + this.nextLongBase);
                String increase_nextint = "UPDATE " + this.nextRequestIdTableName + " SET NEXTLONG=NEXTLONG+" + NEXT_LONG_STEP;
                s = _con.createStatement();
                this.say("executing statement: " + increase_nextint);
                int i = s.executeUpdate(increase_nextint);
                s.close();
                _con.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    _con.rollback();
                }
                catch (Exception e1) {
                    // empty catch block
                }
                this.pool.returnFailedConnection(_con);
                _con = null;
                this.nextLongBase = this._nextLongBase;
            }
            finally {
                if (_con != null) {
                    this.pool.returnConnection(_con);
                }
            }
            this._nextLongBase = this.nextLongBase + NEXT_LONG_STEP;
        }
        long nextLong = this.nextLongBase + this.nextLongIncrement++;
        this.say(" return nextLong=" + nextLong);
        return nextLong;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RequestsPropertyStorage)) {
            return false;
        }
        RequestsPropertyStorage rps = (RequestsPropertyStorage)o;
        return rps.jdbcClass.equals(this.jdbcClass) && rps.jdbcUrl.equals(this.jdbcUrl) && rps.pass.equals(this.pass) && rps.user.equals(this.user) && rps.nextRequestIdTableName.equals(this.nextRequestIdTableName);
    }

    public int hashCode() {
        return this.jdbcClass.hashCode() ^ this.jdbcUrl.hashCode() ^ this.pass.hashCode() ^ this.user.hashCode() ^ this.nextRequestIdTableName.hashCode();
    }

    @Override
    public JobIdGenerator getJobIdGenerator() {
        return this;
    }

    public static final synchronized void initPropertyStorage(String jdbcUrl, String jdbcClass, String user, String pass, String nextRequestIdTableName) {
        if (requestsPropertyStorage != null) {
            throw new IllegalStateException("RequestsPropertyStorage is already initialized");
        }
        requestsPropertyStorage = new RequestsPropertyStorage(jdbcUrl, jdbcClass, user, pass, nextRequestIdTableName);
        RequestsPropertyStorage.initJobIdGeneratorFactory(requestsPropertyStorage);
    }
}

