/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.Job;
import org.dcache.srm.request.PutFileRequest;
import org.dcache.srm.request.sql.DatabaseFileRequestStorage;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TRetentionPolicy;

public class PutFileRequestStorage
extends DatabaseFileRequestStorage {
    public static final String TABLE_NAME = "putfilerequests";
    private static final String UPDATE_PREFIX = "UPDATE putfilerequests SET NEXTJOBID=?, CREATIONTIME=?,  LIFETIME=?, STATE=?, ERRORMESSAGE=?, SCHEDULERID=?, SCHEDULERTIMESTAMP=?,NUMOFRETR=?,MAXNUMOFRETR=?,LASTSTATETRANSITIONTIME=? ";
    private static final String UPDATE_REQUEST_SQL = "UPDATE putfilerequests SET NEXTJOBID=?, CREATIONTIME=?,  LIFETIME=?, STATE=?, ERRORMESSAGE=?, SCHEDULERID=?, SCHEDULERTIMESTAMP=?,NUMOFRETR=?,MAXNUMOFRETR=?,LASTSTATETRANSITIONTIME=? , REQUESTID=?, CREDENTIALID=?, STATUSCODE=?, SURL=?, TURL=? ,FILEID=? ,PARENTFILEID=? ,SPACERESERVATIONID=? ,SIZE=? ,RETENTIONPOLICY=? ,ACCESSLATENCY=? WHERE ID=? ";
    private static final String INSERT_SQL = "INSERT INTO putfilerequests(    ID ,NEXTJOBID ,CREATIONTIME ,LIFETIME ,STATE ,ERRORMESSAGE ,SCHEDULERID ,SCHEDULERTIMESTAMP ,NUMOFRETR ,MAXNUMOFRETR ,LASTSTATETRANSITIONTIME,REQUESTID , CREDENTIALID , STATUSCODE , SURL ,TURL ,FILEID ,PARENTFILEID ,SPACERESERVATIONID ,SIZE ,RETENTIONPOLICY ,ACCESSLATENCY )VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static int ADDITIONAL_FIELDS = 8;

    public PreparedStatement getStatement(Connection connection, String query, Job job) throws SQLException {
        PutFileRequest request = (PutFileRequest)job;
        TRetentionPolicy retentionPolicy = request.getRetentionPolicy();
        TAccessLatency accessLatency = request.getAccessLatency();
        PreparedStatement stmt = this.getPreparedStatement(connection, query, request.getNextJobId(), request.getCreationTime(), request.getLifetime(), request.getState().getStateId(), request.getErrorMessage(), request.getSchedulerId(), request.getSchedulerTimeStamp(), request.getNumberOfRetries(), request.getMaxNumberOfRetries(), request.getLastStateTransitionTime(), request.getRequestId(), request.getCredentialId(), request.getStatusCodeString(), request.getSurlString(), request.getTurlString(), request.getFileId(), request.getParentFileId(), request.getSpaceReservationId(), request.getSize(), retentionPolicy != null ? retentionPolicy.getValue() : null, accessLatency != null ? accessLatency.getValue() : null, request.getId());
        return stmt;
    }

    @Override
    public PreparedStatement getUpdateStatement(Connection connection, Job job) throws SQLException {
        if (job == null || !(job instanceof PutFileRequest)) {
            throw new IllegalArgumentException("job is not PutFileRequest");
        }
        PutFileRequest request = (PutFileRequest)job;
        return this.getStatement(connection, UPDATE_REQUEST_SQL, request);
    }

    @Override
    public PreparedStatement getCreateStatement(Connection connection, Job job) throws SQLException {
        if (job == null || !(job instanceof PutFileRequest)) {
            throw new IllegalArgumentException("fr is not PutFileRequest");
        }
        PutFileRequest request = (PutFileRequest)job;
        TRetentionPolicy retentionPolicy = request.getRetentionPolicy();
        TAccessLatency accessLatency = request.getAccessLatency();
        PreparedStatement stmt = this.getPreparedStatement(connection, INSERT_SQL, request.getId(), request.getNextJobId(), request.getCreationTime(), request.getLifetime(), request.getState().getStateId(), request.getErrorMessage(), request.getSchedulerId(), request.getSchedulerTimeStamp(), request.getNumberOfRetries(), request.getMaxNumberOfRetries(), request.getLastStateTransitionTime(), request.getRequestId(), request.getCredentialId(), request.getStatusCodeString(), request.getSurlString(), request.getTurlString(), request.getFileId(), request.getParentFileId(), request.getSpaceReservationId(), request.getSize(), retentionPolicy != null ? retentionPolicy.getValue() : null, accessLatency != null ? accessLatency.getValue() : null);
        return stmt;
    }

    public PutFileRequestStorage(Configuration.DatabaseParameters configuration) throws SQLException {
        super(configuration);
    }

    @Override
    protected FileRequest getFileRequest(Connection _con, Long ID, Long NEXTJOBID, long CREATIONTIME, long LIFETIME, int STATE, String ERRORMESSAGE, String SCHEDULERID, long SCHEDULER_TIMESTAMP, int NUMOFRETR, int MAXNUMOFRETR, long LASTSTATETRANSITIONTIME, Long REQUESTID, Long CREDENTIALID, String STATUSCODE, ResultSet set, int next_index) throws SQLException {
        String SURL2 = set.getString(next_index++);
        String TURL = set.getString(next_index++);
        String FILEID = set.getString(next_index++);
        String PARENTFILEID = set.getString(next_index++);
        String SPACERESERVATIONID = set.getString(next_index++);
        long SIZE = set.getLong(next_index++);
        String RETENTIONPOLICY = set.getString(next_index++);
        String ACCESSLATENCY = set.getString(next_index++);
        TRetentionPolicy retentionPolicy = RETENTIONPOLICY == null || RETENTIONPOLICY.equalsIgnoreCase("null") ? null : TRetentionPolicy.fromString(RETENTIONPOLICY);
        TAccessLatency accessLatency = ACCESSLATENCY == null || ACCESSLATENCY.equalsIgnoreCase("null") ? null : TAccessLatency.fromString(ACCESSLATENCY);
        Job.JobHistory[] jobHistoryArray = this.getJobHistory(ID, _con);
        return new PutFileRequest(ID, NEXTJOBID, CREATIONTIME, LIFETIME, STATE, ERRORMESSAGE, SCHEDULERID, SCHEDULER_TIMESTAMP, NUMOFRETR, MAXNUMOFRETR, LASTSTATETRANSITIONTIME, jobHistoryArray, REQUESTID, CREDENTIALID, STATUSCODE, SURL2, TURL, FILEID, PARENTFILEID, SPACERESERVATIONID, SIZE, retentionPolicy, accessLatency);
    }

    @Override
    public String getFileRequestCreateTableFields() {
        return ", SURL  VARCHAR(32672) , TURL  VARCHAR(32672) , FILEID  VARCHAR(32672) , PARENTFILEID  VARCHAR(32672) , SPACERESERVATIONID  VARCHAR(32672) , SIZE  BIGINT , RETENTIONPOLICY  VARCHAR(32672) , ACCESSLATENCY  VARCHAR(32672) ";
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public String getRequestTableName() {
        return "putrequests";
    }

    @Override
    protected void __verify(int nextIndex, int columnIndex, String tableName, String columnName, int columnType) throws SQLException {
        if (columnIndex == nextIndex) {
            this.verifyStringType("SURL", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 1) {
            this.verifyStringType("TURL", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 2) {
            this.verifyStringType("FILEID", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 3) {
            this.verifyStringType("PARENTFILEID", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 4) {
            this.verifyStringType("SPACERESERVATIONID", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 5) {
            this.verifyLongType("SIZE", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 6) {
            this.verifyStringType("RETENTIONPOLICY", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 7) {
            this.verifyStringType("ACCESSLATENCY", columnIndex, tableName, columnName, columnType);
        } else {
            throw new SQLException("database table schema changed:table named " + tableName + " column #" + columnIndex + " has name \"" + columnName + "\"  has type \"" + this.getTypeName(columnType) + " this column should not be present!!!");
        }
    }

    @Override
    protected int getMoreCollumnsNum() {
        return ADDITIONAL_FIELDS;
    }
}

