/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.ContainerRequest;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.Job;
import org.dcache.srm.request.LsRequest;
import org.dcache.srm.request.sql.DatabaseContainerRequestStorage;
import org.dcache.srm.util.Configuration;

public class LsRequestStorage
extends DatabaseContainerRequestStorage {
    public static final String TABLE_NAME = "lsrequests";
    private static final String UPDATE_PREFIX = "UPDATE lsrequests SET NEXTJOBID=?, CREATIONTIME=?,  LIFETIME=?, STATE=?, ERRORMESSAGE=?, SCHEDULERID=?, SCHEDULERTIMESTAMP=?,NUMOFRETR=?,MAXNUMOFRETR=?,LASTSTATETRANSITIONTIME=? ";
    private static final String INSERT_SQL = "INSERT INTO lsrequests(    ID ,NEXTJOBID ,CREATIONTIME ,LIFETIME ,STATE ,ERRORMESSAGE ,SCHEDULERID ,SCHEDULERTIMESTAMP ,NUMOFRETR ,MAXNUMOFRETR ,LASTSTATETRANSITIONTIME,CREDENTIALID , RETRYDELTATIME , SHOULDUPDATERETRYDELTATIME ,DESCRIPTION ,CLIENTHOST ,STATUSCODE ,USERID , EXPLANATION ,LONGFORMAT ,NUMOFLEVELS ,\"count\" ,LSOFFSET ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_REQUEST_SQL = "UPDATE lsrequests SET NEXTJOBID=?, CREATIONTIME=?,  LIFETIME=?, STATE=?, ERRORMESSAGE=?, SCHEDULERID=?, SCHEDULERTIMESTAMP=?,NUMOFRETR=?,MAXNUMOFRETR=?,LASTSTATETRANSITIONTIME=? , CREDENTIALID=?, RETRYDELTATIME=?, SHOULDUPDATERETRYDELTATIME=?, DESCRIPTION=?, CLIENTHOST=?, STATUSCODE=?, USERID=?, EXPLANATION=?, LONGFORMAT=?, NUMOFLEVELS=?, \"count\"=?, LSOFFSET=?  WHERE ID=?";
    private static int ADDITIONAL_FIELDS = 5;

    @Override
    public PreparedStatement getCreateStatement(Connection connection, Job job) throws SQLException {
        LsRequest lr = (LsRequest)job;
        PreparedStatement stmt = this.getPreparedStatement(connection, INSERT_SQL, lr.getId(), lr.getNextJobId(), lr.getCreationTime(), lr.getLifetime(), lr.getState().getStateId(), lr.getErrorMessage(), lr.getSchedulerId(), lr.getSchedulerTimeStamp(), lr.getNumberOfRetries(), lr.getMaxNumberOfRetries(), lr.getLastStateTransitionTime(), lr.getCredentialId(), lr.getRetryDeltaTime(), lr.isShould_updateretryDeltaTime() ? 0 : 1, lr.getDescription(), lr.getClient_host(), lr.getStatusCodeString(), lr.getUser().getId(), lr.getExplanation(), lr.getLongFormat() ? 1 : 0, lr.getNumOfLevels(), lr.getCount(), lr.getOffset());
        return stmt;
    }

    @Override
    public PreparedStatement getUpdateStatement(Connection connection, Job job) throws SQLException {
        LsRequest lr = (LsRequest)job;
        PreparedStatement stmt = this.getPreparedStatement(connection, UPDATE_REQUEST_SQL, lr.getNextJobId(), lr.getCreationTime(), lr.getLifetime(), lr.getState().getStateId(), lr.getErrorMessage(), lr.getSchedulerId(), lr.getSchedulerTimeStamp(), lr.getNumberOfRetries(), lr.getMaxNumberOfRetries(), lr.getLastStateTransitionTime(), lr.getCredentialId(), lr.getRetryDeltaTime(), lr.isShould_updateretryDeltaTime() ? 0 : 1, lr.getDescription(), lr.getClient_host(), lr.getStatusCodeString(), lr.getUser().getId(), lr.getExplanation(), lr.getLongFormat() ? 1 : 0, lr.getNumOfLevels(), lr.getCount(), lr.getOffset(), lr.getId());
        return stmt;
    }

    public LsRequestStorage(Configuration.DatabaseParameters configuration) throws SQLException {
        super(configuration);
    }

    @Override
    public void dbInit1() throws SQLException {
    }

    @Override
    public void getCreateList(ContainerRequest r, StringBuffer sb) {
        if (r == null || !(r instanceof LsRequest)) {
            throw new IllegalArgumentException("r is not LsRequest");
        }
        LsRequest lsRequest = (LsRequest)r;
        if (lsRequest.getExplanation() != null) {
            sb.append(",'").append(lsRequest.getExplanation()).append("'");
        } else {
            sb.append(",NULL");
        }
        sb.append(",").append(lsRequest.getLongFormat() ? 1 : 0);
        sb.append(",").append(lsRequest.getNumOfLevels());
        sb.append(",").append(lsRequest.getCount());
        sb.append(",").append(lsRequest.getOffset());
    }

    @Override
    protected ContainerRequest getContainerRequest(Connection connection, Long ID, Long NEXTJOBID, long CREATIONTIME, long LIFETIME, int STATE, String ERRORMESSAGE, SRMUser user, String SCHEDULERID, long SCHEDULER_TIMESTAMP, int NUMOFRETR, int MAXNUMOFRETR, long LASTSTATETRANSITIONTIME, Long CREDENTIALID, int RETRYDELTATIME, boolean SHOULDUPDATERETRYDELTATIME, String DESCRIPTION, String CLIENTHOST, String STATUSCODE, FileRequest[] fileRequests, ResultSet set, int next_index) throws SQLException {
        Job.JobHistory[] jobHistoryArray = this.getJobHistory(ID, connection);
        String explanation = set.getString(next_index++);
        boolean longFormat = set.getInt(next_index++) == 1;
        int numOfLevels = set.getInt(next_index++);
        int count = set.getInt(next_index++);
        int offset = set.getInt(next_index++);
        return new LsRequest(ID, NEXTJOBID, CREATIONTIME, LIFETIME, STATE, ERRORMESSAGE, user, SCHEDULERID, SCHEDULER_TIMESTAMP, NUMOFRETR, MAXNUMOFRETR, LASTSTATETRANSITIONTIME, jobHistoryArray, CREDENTIALID, fileRequests, RETRYDELTATIME, SHOULDUPDATERETRYDELTATIME, DESCRIPTION, CLIENTHOST, STATUSCODE, explanation, longFormat, numOfLevels, count, offset);
    }

    @Override
    public String getRequestCreateTableFields() {
        return " ,EXPLANATION  VARCHAR(32672) ,LONGFORMAT  INT ,NUMOFLEVELS  INTEGER ,\"count\"  INTEGER ,LSOFFSET  INTEGER ";
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    public void getUpdateAssignements(ContainerRequest r, StringBuffer sb) {
        if (r == null || !(r instanceof LsRequest)) {
            throw new IllegalArgumentException("r is not LsRequest");
        }
        LsRequest lsRequest = (LsRequest)r;
        if (lsRequest.getExplanation() != null) {
            sb.append(",EXPLANATION='").append(lsRequest.getExplanation()).append("'");
        } else {
            sb.append(",EXPLANATION=NULL");
        }
        sb.append(",LONGFORMAT=").append(lsRequest.getLongFormat() ? 1 : 0);
        sb.append(",NUMOFLEVELS=").append(lsRequest.getNumOfLevels());
        sb.append(",\"count\"=").append(lsRequest.getCount());
        sb.append(",LSOFFSET=").append(lsRequest.getOffset());
    }

    @Override
    public String getFileRequestsTableName() {
        return "lsfilerequests";
    }

    @Override
    protected void __verify(int nextIndex, int columnIndex, String tableName, String columnName, int columnType) throws SQLException {
        if (columnIndex == nextIndex) {
            this.verifyStringType("EXPLANATION", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 1) {
            this.verifyBooleanType("LONGFORMAT", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 2) {
            this.verifyIntType("NUMOFLEVELS", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 3) {
            this.verifyIntType("count", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 4) {
            this.verifyIntType("LSOFFSET", columnIndex, tableName, columnName, columnType);
        } else {
            throw new SQLException("database table schema changed:table named " + tableName + " column #" + columnIndex + " has name \"" + columnName + "\"  has type \"" + this.getTypeName(columnType) + " this column should not be present!!!");
        }
    }

    @Override
    protected int getMoreCollumnsNum() {
        return ADDITIONAL_FIELDS;
    }
}

