/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcConnectionPool
implements Runnable {
    String jdbcUrl;
    String jdbcClass;
    String user;
    String pass;
    private static Collection<JdbcConnectionPool> pools = new HashSet<JdbcConnectionPool>();
    private Thread[] execution_threads;
    private final List<JdbcTask> jdbcTasks = new LinkedList<JdbcTask>();
    private static int executionThreadNum = 5;
    private static int maxJdbcTasksNum = 1000;
    private static final Logger _log = LoggerFactory.getLogger(JdbcConnectionPool.class);
    private final Set<Connection> connections = new HashSet<Connection>();
    private int max_connections = 50;
    private int max_connections_out = 50;
    private int connections_out;

    public static final synchronized JdbcConnectionPool getPool(String jdbcUrl, String jdbcClass, String user, String pass) throws SQLException {
        long starttimestamp = System.currentTimeMillis();
        Iterator<JdbcConnectionPool> i$ = pools.iterator();
        while (i$.hasNext()) {
            JdbcConnectionPool pool1;
            JdbcConnectionPool pool = pool1 = i$.next();
            if (!pool.jdbcClass.equals(jdbcClass) || !pool.jdbcUrl.equals(jdbcUrl) || !pool.pass.equals(pass) || !pool.user.equals(user)) continue;
            long elapsed = System.currentTimeMillis() - starttimestamp;
            if (_log.isDebugEnabled()) {
                _log.debug("getPool() took " + elapsed + " ms");
            }
            return pool;
        }
        JdbcConnectionPool pool = new JdbcConnectionPool(jdbcUrl, jdbcClass, user, pass);
        pools.add(pool);
        long elapsed = System.currentTimeMillis() - starttimestamp;
        if (_log.isDebugEnabled()) {
            _log.debug("getPool() took " + elapsed + " ms");
        }
        return pool;
    }

    protected JdbcConnectionPool(String jdbcUrl, String jdbcClass, String user, String pass) throws SQLException {
        if (jdbcUrl == null || jdbcClass == null || user == null || pass == null) {
            throw new NullPointerException("all arguments must be non-null!!");
        }
        try {
            Class.forName(jdbcClass);
        }
        catch (Exception e) {
            throw new SQLException("can not initialize jdbc driver : " + jdbcClass);
        }
        this.jdbcUrl = jdbcUrl;
        this.jdbcClass = jdbcClass;
        this.user = user;
        this.pass = pass;
        this.startExecutionThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        long starttimestamp = System.currentTimeMillis();
        Set<Connection> set = this.connections;
        synchronized (set) {
            while (this.connections_out >= this.max_connections_out) {
                try {
                    this.connections.wait(1000L);
                }
                catch (InterruptedException ie) {}
            }
            ++this.connections_out;
            this.connections.notify();
            if (this.connections.size() > 0) {
                Connection _con = this.connections.iterator().next();
                this.connections.remove(_con);
                try {
                    if (!_con.isClosed()) {
                        long elapsed = System.currentTimeMillis() - starttimestamp;
                        if (_log.isDebugEnabled()) {
                            _log.debug("getConnection() took " + elapsed + " ms");
                        }
                        return _con;
                    }
                }
                catch (SQLException sqle) {
                    // empty catch block
                }
            }
        }
        Connection _con = DriverManager.getConnection(this.jdbcUrl, this.user, this.pass);
        _con.setAutoCommit(false);
        long elapsed = System.currentTimeMillis() - starttimestamp;
        if (_log.isDebugEnabled()) {
            _log.debug("getConnection() took " + elapsed + " ms");
        }
        return _con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnFailedConnection(Connection _con) {
        long starttimestamp = System.currentTimeMillis();
        try {
            _con.rollback();
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        Set<Connection> sqle = this.connections;
        synchronized (sqle) {
            --this.connections_out;
            this.connections.notifyAll();
            try {
                _con.close();
                long elapsed = System.currentTimeMillis() - starttimestamp;
                if (_log.isDebugEnabled()) {
                    _log.debug("returnFailedConnection() took " + elapsed + " ms");
                }
                return;
            }
            catch (SQLException sqle2) {
                if (_log.isDebugEnabled()) {
                    _log.debug("returnFailedConnection() exception: ", (Throwable)sqle2);
                }
            }
        }
        long elapsed = System.currentTimeMillis() - starttimestamp;
        if (_log.isDebugEnabled()) {
            _log.debug("returnFailedConnection() took " + elapsed + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnection(Connection _con) {
        long starttimestamp = System.currentTimeMillis();
        try {
            _con.commit();
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        Set<Connection> sqle = this.connections;
        synchronized (sqle) {
            block12: {
                --this.connections_out;
                this.connections.notifyAll();
                try {
                    if (_con.isClosed()) {
                        long elapsed = System.currentTimeMillis() - starttimestamp;
                        if (_log.isDebugEnabled()) {
                            _log.debug("returnConnection() took " + elapsed + " ms");
                        }
                        return;
                    }
                    if (this.connections.size() >= this.max_connections) {
                        _con.close();
                        long elapsed = System.currentTimeMillis() - starttimestamp;
                        if (_log.isDebugEnabled()) {
                            _log.debug("returnConnection() took " + elapsed + " ms");
                        }
                        return;
                    }
                    this.connections.add(_con);
                }
                catch (SQLException sqle2) {
                    if (!_log.isDebugEnabled()) break block12;
                    _log.debug("returnConnection() exception: ", (Throwable)sqle2);
                }
            }
        }
        long elapsed = System.currentTimeMillis() - starttimestamp;
        if (_log.isDebugEnabled()) {
            _log.debug("returnConnection() took " + elapsed + " ms");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof JdbcConnectionPool)) {
            return false;
        }
        JdbcConnectionPool pool = (JdbcConnectionPool)o;
        return pool.jdbcClass.equals(this.jdbcClass) && pool.jdbcUrl.equals(this.jdbcUrl) && pool.pass.equals(this.pass) && pool.user.equals(this.user);
    }

    public int hashCode() {
        return this.jdbcClass.hashCode() ^ this.jdbcUrl.hashCode() ^ this.pass.hashCode() ^ this.user.hashCode();
    }

    public void startExecutionThreads() {
        if (this.execution_threads != null) {
            return;
        }
        this.execution_threads = new Thread[executionThreadNum];
        for (int i = 0; i < this.execution_threads.length; ++i) {
            this.execution_threads[i] = new Thread((Runnable)this, "db-thread-" + i);
            this.execution_threads[i].start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void execution_thread_loop() {
        while (true) {
            try {
                while (true) lbl-1000:
                // 5 sources

                {
                    var2_4 = this.jdbcTasks;
                    synchronized (var2_4) {
                        while (this.jdbcTasks.isEmpty()) {
                            this.jdbcTasks.wait(10000L);
                        }
                        nextTask = this.jdbcTasks.remove(0);
                    }
                    _con = null;
                    try {
                        _con = this.getConnection();
                        nextTask.execute(_con);
                    }
                    catch (SQLException e) {
                        JdbcConnectionPool._log.error("SQL statement failed: " + e.getMessage());
                        if (_con == null) ** GOTO lbl-1000
                        this.returnFailedConnection(_con);
                        _con = null;
                    }
                    finally {
                        if (_con == null) continue;
                        this.returnConnection(_con);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                JdbcConnectionPool._log.debug("Execution thread shutting down");
                break;
            }
            catch (Throwable e) {
                Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                continue;
            }
            ** GOTO lbl-1000
            break;
        }
    }

    @Override
    public void run() {
        this.execution_thread_loop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JdbcTask task) throws SQLException {
        long jdbcTasksSize;
        if (task == null) {
            return;
        }
        List<JdbcTask> list = this.jdbcTasks;
        synchronized (list) {
            jdbcTasksSize = this.jdbcTasks.size();
            if (this.jdbcTasks.size() <= maxJdbcTasksNum) {
                this.jdbcTasks.add(task);
                this.jdbcTasks.notifyAll();
                return;
            }
        }
        _log.error("Execution of JdbcTask failed, jdbcTaskQueue is too long: " + jdbcTasksSize + " task is: " + task);
        throw new SQLException("jdbcTaskQueue is too long: " + jdbcTasksSize);
    }

    public static int getExecutionThreadNum() {
        return executionThreadNum;
    }

    public static void setExecutionThreadNum(int aExecutionThreadNum) {
        executionThreadNum = aExecutionThreadNum;
    }

    public static int getMaxQueuedJdbcTasksNum() {
        return maxJdbcTasksNum;
    }

    public static void setMaxQueuedJdbcTasksNum(int aMaxJdbcTasksNum) {
        maxJdbcTasksNum = aMaxJdbcTasksNum;
    }

    public static final void main(String[] args) throws Exception {
        if (args == null || args.length < 5) {
            System.err.println("Usage: java org.dcache.srm.request.sql.JdbcConnectionPool  jdbcUrl jdbcClass user pass <SQL Statement1> [<SQL Statement2> ...[<SQL StatementN>]]");
            System.exit(1);
        }
        JdbcConnectionPool pool = JdbcConnectionPool.getPool(args[0], args[1], args[2], args[3]);
        for (int i = 4; i < args.length; ++i) {
            final String updateStatementString = args[i];
            JdbcTask task = new JdbcTask(){

                public void say(String s) {
                    System.out.println(s);
                }

                public void esay(String s) {
                    System.err.println(s);
                }

                public void esay(Throwable t) {
                    t.printStackTrace();
                }

                @Override
                public void execute(Connection connection) throws SQLException {
                    try {
                        this.say(" executing statement: " + updateStatementString);
                        Statement sqlStatement = connection.createStatement();
                        int result = sqlStatement.executeUpdate(updateStatementString);
                        this.say("executeUpdate result is " + result);
                        sqlStatement.close();
                        connection.commit();
                    }
                    catch (SQLException sqle) {
                        this.esay("execution of " + updateStatementString + " failed with ");
                        this.esay(sqle);
                        try {
                            connection.rollback();
                        }
                        catch (SQLException sqle1) {
                            // empty catch block
                        }
                    }
                }
            };
            try {
                pool.execute(task);
                continue;
            }
            catch (SQLException sqle) {
                // empty catch block
            }
        }
    }

    public static interface JdbcTask {
        public void execute(Connection var1) throws SQLException;
    }
}

