/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.GetFileRequest;
import org.dcache.srm.request.Job;
import org.dcache.srm.request.sql.DatabaseFileRequestStorage;
import org.dcache.srm.util.Configuration;

public class GetFileRequestStorage
extends DatabaseFileRequestStorage {
    public static final String TABLE_NAME = "getfilerequests";
    private static final String UPDATE_PREFIX = "UPDATE getfilerequests SET NEXTJOBID=?, CREATIONTIME=?,  LIFETIME=?, STATE=?, ERRORMESSAGE=?, SCHEDULERID=?, SCHEDULERTIMESTAMP=?,NUMOFRETR=?,MAXNUMOFRETR=?,LASTSTATETRANSITIONTIME=? ";
    private static final String UPDATE_REQUEST_SQL = "UPDATE getfilerequests SET NEXTJOBID=?, CREATIONTIME=?,  LIFETIME=?, STATE=?, ERRORMESSAGE=?, SCHEDULERID=?, SCHEDULERTIMESTAMP=?,NUMOFRETR=?,MAXNUMOFRETR=?,LASTSTATETRANSITIONTIME=? , REQUESTID=?, CREDENTIALID=?, STATUSCODE=?, SURL=?, TURL=? ,FILEID=? ,PINID=? WHERE ID=? ";
    private static final String INSERT_SQL = "INSERT INTO getfilerequests(    ID ,NEXTJOBID ,CREATIONTIME ,LIFETIME ,STATE ,ERRORMESSAGE ,SCHEDULERID ,SCHEDULERTIMESTAMP ,NUMOFRETR ,MAXNUMOFRETR ,LASTSTATETRANSITIONTIME,REQUESTID , CREDENTIALID , STATUSCODE , SURL ,TURL ,FILEID ,PINID ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static int ADDITIONAL_FIELDS = 4;

    public PreparedStatement getStatement(Connection connection, String query, Job job) throws SQLException {
        GetFileRequest request = (GetFileRequest)job;
        PreparedStatement stmt = this.getPreparedStatement(connection, query, request.getNextJobId(), request.getCreationTime(), request.getLifetime(), request.getState().getStateId(), request.getErrorMessage(), request.getSchedulerId(), request.getSchedulerTimeStamp(), request.getNumberOfRetries(), request.getMaxNumberOfRetries(), request.getLastStateTransitionTime(), request.getRequestId(), request.getCredentialId(), request.getStatusCodeString(), request.getSurlString(), request.getTurlString(), request.getFileId(), request.getPinId(), request.getId());
        return stmt;
    }

    @Override
    public PreparedStatement getUpdateStatement(Connection connection, Job job) throws SQLException {
        if (job == null || !(job instanceof GetFileRequest)) {
            throw new IllegalArgumentException("fr is not GetFileRequest");
        }
        GetFileRequest request = (GetFileRequest)job;
        return this.getStatement(connection, UPDATE_REQUEST_SQL, request);
    }

    @Override
    public PreparedStatement getCreateStatement(Connection connection, Job job) throws SQLException {
        if (job == null || !(job instanceof GetFileRequest)) {
            throw new IllegalArgumentException("job is not GetFileRequest");
        }
        GetFileRequest request = (GetFileRequest)job;
        PreparedStatement stmt = this.getPreparedStatement(connection, INSERT_SQL, request.getId(), request.getNextJobId(), request.getCreationTime(), request.getLifetime(), request.getState().getStateId(), request.getErrorMessage(), request.getSchedulerId(), request.getSchedulerTimeStamp(), request.getNumberOfRetries(), request.getMaxNumberOfRetries(), request.getLastStateTransitionTime(), request.getRequestId(), request.getCredentialId(), request.getStatusCodeString(), request.getSurlString(), request.getTurlString(), request.getFileId(), request.getPinId());
        return stmt;
    }

    public GetFileRequestStorage(Configuration.DatabaseParameters configuration) throws SQLException {
        super(configuration);
    }

    @Override
    protected FileRequest getFileRequest(Connection _con, Long ID, Long NEXTJOBID, long CREATIONTIME, long LIFETIME, int STATE, String ERRORMESSAGE, String SCHEDULERID, long SCHEDULER_TIMESTAMP, int NUMOFRETR, int MAXNUMOFRETR, long LASTSTATETRANSITIONTIME, Long REQUESTID, Long CREDENTIALID, String STATUSCODE, ResultSet set, int next_index) throws SQLException {
        String SURL2 = set.getString(next_index++);
        String TURL = set.getString(next_index++);
        String FILEID = set.getString(next_index++);
        String PINID = set.getString(next_index);
        Job.JobHistory[] jobHistoryArray = this.getJobHistory(ID, _con);
        return new GetFileRequest(ID, NEXTJOBID, CREATIONTIME, LIFETIME, STATE, ERRORMESSAGE, SCHEDULERID, SCHEDULER_TIMESTAMP, NUMOFRETR, MAXNUMOFRETR, LASTSTATETRANSITIONTIME, jobHistoryArray, REQUESTID, CREDENTIALID, STATUSCODE, SURL2, TURL, FILEID, PINID);
    }

    @Override
    public String getFileRequestCreateTableFields() {
        return ",SURL  VARCHAR(32672) ,TURL  VARCHAR(32672) ,FILEID  VARCHAR(32672) ,PINID  VARCHAR(32672) ";
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    public void getUpdateAssignements(FileRequest fr, StringBuffer sb) {
        if (fr == null || !(fr instanceof GetFileRequest)) {
            throw new IllegalArgumentException("fr is not GetFileRequest");
        }
        GetFileRequest gfr = (GetFileRequest)fr;
        sb.append(", SURL = '").append(gfr.getSurlString()).append("',");
        String tmp = gfr.getTurlString();
        if (tmp == null) {
            sb.append(" TURL =NULL, ");
        } else {
            sb.append("TURL = '").append(tmp).append("', ");
        }
        tmp = gfr.getFileId();
        if (tmp == null) {
            sb.append(" FILEID =NULL, ");
        } else {
            sb.append("FILEID = '").append(tmp).append("', ");
        }
        tmp = gfr.getPinId();
        if (tmp == null) {
            sb.append(" PINID =NULL ");
        } else {
            sb.append("PINID = '").append(tmp).append("' ");
        }
    }

    public void getCreateList(FileRequest fr, StringBuffer sb) {
        if (fr == null || !(fr instanceof GetFileRequest)) {
            throw new IllegalArgumentException("fr is not GetFileRequest");
        }
        GetFileRequest gfr = (GetFileRequest)fr;
        sb.append(", '").append(gfr.getSurlString()).append("', ");
        String tmp = gfr.getTurlString();
        if (tmp == null) {
            sb.append("NULL, ");
        } else {
            sb.append('\'').append(tmp).append("', ");
        }
        tmp = gfr.getFileId();
        if (tmp == null) {
            sb.append("NULL, ");
        } else {
            sb.append('\'').append(tmp).append("', ");
        }
        tmp = gfr.getPinId();
        if (tmp == null) {
            sb.append("NULL ");
        } else {
            sb.append('\'').append(tmp).append("' ");
        }
    }

    @Override
    public String getRequestTableName() {
        return "getrequests";
    }

    @Override
    protected void __verify(int nextIndex, int columnIndex, String tableName, String columnName, int columnType) throws SQLException {
        if (columnIndex == nextIndex) {
            this.verifyStringType("SURL", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 1) {
            this.verifyStringType("TURL", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 2) {
            this.verifyStringType("FILEID", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 3) {
            this.verifyStringType("PINID", columnIndex, tableName, columnName, columnType);
        } else {
            throw new SQLException("database table schema changed:table named " + tableName + " column #" + columnIndex + " has name \"" + columnName + "\"  has type \"" + this.getTypeName(columnType) + " this column should not be present!!!");
        }
    }

    @Override
    protected int getMoreCollumnsNum() {
        return ADDITIONAL_FIELDS;
    }
}

