/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request.sql;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.dcache.commons.util.SqlHelper;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.request.Job;
import org.dcache.srm.request.sql.JdbcConnectionPool;
import org.dcache.srm.request.sql.Utilities;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.JobStorage;
import org.dcache.srm.scheduler.Scheduler;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.util.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseJobStorage
implements JobStorage,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseJobStorage.class);
    protected static final String INDEX_SUFFIX = "_idx";
    public static final Predicate<Job.JobHistory> NOT_SAVED = new Predicate<Job.JobHistory>(){

        public boolean apply(Job.JobHistory element) {
            return !element.isSaved();
        }
    };
    protected final Configuration.DatabaseParameters configuration;
    private final String jdbcUrl;
    private final String jdbcClass;
    private final String user;
    private final String pass;
    protected boolean logHistory;
    protected static final String stringType = " VARCHAR(32672) ";
    protected static final String longType = " BIGINT ";
    protected static final String intType = " INTEGER ";
    protected static final String dateTimeType = " TIMESTAMP ";
    protected static final String booleanType = " INT ";
    protected static final int stringType_int = 12;
    protected static final int longType_int = -5;
    protected static final int intType_int = 4;
    protected static final int dateTimeType_int = 93;
    protected static final int booleanType_int = 4;
    private final ConcurrentMap<Long, UpdateState> states = new ConcurrentHashMap<Long, UpdateState>();
    public static final String createFileRequestTablePrefix = "ID  BIGINT  NOT NULL PRIMARY KEY,NEXTJOBID  BIGINT ,CREATIONTIME  BIGINT ,LIFETIME  BIGINT ,STATE  INTEGER ,ERRORMESSAGE  VARCHAR(32672) ,SCHEDULERID  VARCHAR(32672) ,SCHEDULERTIMESTAMP  BIGINT ,NUMOFRETR  BIGINT ,MAXNUMOFRETR  BIGINT ,LASTSTATETRANSITIONTIME BIGINT ";
    public static final String srmStateTableName = "SRMJOBSTATE";
    public static final String createStateTable = "CREATE TABLE SRMJOBSTATE ( ID  BIGINT  NOT NULL PRIMARY KEY,STATE  VARCHAR(32672)  )";
    public static final String createHistroyTablePrefix = "ID  BIGINT  NOT NULL PRIMARY KEY,JOBID  BIGINT ,STATEID  BIGINT ,TRANSITIONTIME  BIGINT ,DESCRIPTION  VARCHAR(32672) ";
    private static int COLLUMNS_NUM = 11;
    JdbcConnectionPool pool;
    protected boolean reanamed_old_table;
    private boolean getJobsRan;
    private boolean updatePendingJobsRan;

    public DatabaseJobStorage(Configuration.DatabaseParameters configuration) throws SQLException {
        this.configuration = configuration;
        this.jdbcUrl = configuration.getJdbcUrl();
        this.jdbcClass = configuration.getJdbcClass();
        this.user = configuration.getJdbcUser();
        this.pass = configuration.getJdbcPass();
        this.logHistory = configuration.isRequestHistoryDatabaseEnabled();
        this.dbInit(configuration.isCleanPendingRequestsOnRestart());
        new Thread((Runnable)this, "update" + this.getTableName()).start();
    }

    @Override
    public boolean isJdbcLogRequestHistoryInDBEnabled() {
        return this.logHistory;
    }

    public abstract String getTableName();

    public abstract String getCreateTableFields();

    protected abstract void _dbInit() throws SQLException;

    private String getHistoryTableName() {
        return this.getTableName().toLowerCase() + "history";
    }

    private void dbInit(boolean clean) throws SQLException {
        this.createTable(srmStateTableName, createStateTable);
        this.insertStates();
        String tableName = this.getTableName().toLowerCase();
        String createStatement = "CREATE TABLE " + tableName + "(" + createFileRequestTablePrefix + this.getCreateTableFields() + ", " + " CONSTRAINT fk_" + tableName + "_ST FOREIGN KEY (STATE) REFERENCES " + srmStateTableName + " (ID) " + " )";
        this.createTable(tableName, createStatement, true, clean);
        String historyTableName = this.getHistoryTableName();
        if (this.reanamed_old_table) {
            try {
                this.renameTable(historyTableName);
            }
            catch (SQLException sqle) {
                // empty catch block
            }
        }
        String createHistoryTable = "CREATE TABLE " + historyTableName + " ( " + createHistroyTablePrefix + ", " + " CONSTRAINT fk_" + tableName + "_HI FOREIGN KEY (JOBID) REFERENCES " + tableName + " (ID) " + " ON DELETE CASCADE" + " )";
        this.createTable(historyTableName, createHistoryTable);
        String[] columns = new String[]{"NEXTJOBID", "STATE", "SCHEDULERID"};
        this.createIndex(columns, this.getTableName().toLowerCase());
        this.createIndex(this.getTableName().toLowerCase() + "_expirationtime_idx", "(CREATIONTIME+LIFETIME)".toLowerCase(), this.getTableName().toLowerCase());
        String[] history_columns = new String[]{"STATEID", "TRANSITIONTIME", "JOBID"};
        this.createIndex(history_columns, this.getHistoryTableName().toLowerCase());
        this._dbInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertStates() throws SQLException {
        Statement sqlStatement;
        Connection _con;
        block13: {
            _con = null;
            sqlStatement = null;
            try {
                int count;
                _con = this.pool.getConnection();
                State[] states = State.values();
                String countStates = "SELECT count(*) from SRMJOBSTATE";
                sqlStatement = _con.createStatement();
                ResultSet rs = sqlStatement.executeQuery(countStates);
                if (!rs.next() || (count = rs.getInt(1)) == states.length) break block13;
                for (State state : states) {
                    String insertState = "INSERT INTO SRMJOBSTATE VALUES (?, ?)";
                    logger.debug("inserting into SRMJOBSTATE values: {} {}", (Object)state.getStateId(), (Object)state);
                    PreparedStatement sqlStatement1 = null;
                    try {
                        sqlStatement1 = _con.prepareStatement(insertState);
                        sqlStatement1.setInt(1, state.getStateId());
                        sqlStatement1.setString(2, state.toString());
                        int result = sqlStatement1.executeUpdate();
                        _con.commit();
                    }
                    catch (SQLException sqle) {
                        logger.error(sqle.toString());
                    }
                    finally {
                        SqlHelper.tryToClose((PreparedStatement)sqlStatement1);
                    }
                }
            }
            catch (SQLException sqle) {
                try {
                    if (_con != null) {
                        this.pool.returnFailedConnection(_con);
                        _con = null;
                    }
                    throw sqle;
                }
                catch (Throwable throwable) {
                    SqlHelper.tryToClose(sqlStatement);
                    if (_con != null) {
                        this.pool.returnConnection(_con);
                    }
                    throw throwable;
                }
            }
        }
        SqlHelper.tryToClose((Statement)sqlStatement);
        if (_con != null) {
            this.pool.returnConnection(_con);
        }
    }

    protected abstract Job getJob(Connection var1, Long var2, Long var3, long var4, long var6, int var8, String var9, String var10, long var11, int var13, int var14, long var15, ResultSet var17, int var18) throws SQLException;

    @Override
    public Job getJob(Long jobId) throws SQLException {
        if (jobId == null) {
            throw new NullPointerException("jobId is null");
        }
        Connection _con = null;
        try {
            _con = this.pool.getConnection();
            Job job = this.getJob(jobId, _con);
            this.pool.returnConnection(_con);
            _con = null;
            Job job2 = job;
            return job2;
        }
        catch (SQLException sqle) {
            if (_con != null) {
                this.pool.returnFailedConnection(_con);
                _con = null;
            }
            throw sqle;
        }
        finally {
            if (_con != null) {
                this.pool.returnConnection(_con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Job getJob(Long jobId, Connection _con) throws SQLException {
        Job job;
        ResultSet set;
        PreparedStatement statement;
        block4: {
            Job job2;
            if (jobId == null) {
                throw new NullPointerException("jobId is null");
            }
            logger.debug("executing statement: SELECT * FROM {} WHERE ID=?({})", (Object)this.getTableName(), (Object)jobId);
            statement = null;
            set = null;
            try {
                statement = this.getPreparedStatement(_con, "SELECT * FROM " + this.getTableName() + " WHERE ID=?", jobId);
                set = statement.executeQuery();
                if (set.next()) break block4;
                job2 = null;
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(set);
                SqlHelper.tryToClose(statement);
                throw throwable;
            }
            SqlHelper.tryToClose((ResultSet)set);
            SqlHelper.tryToClose((PreparedStatement)statement);
            return job2;
        }
        Long ID = set.getLong(1);
        Long NEXTJOBID = set.getLong(2);
        long CREATIONTIME = set.getLong(3);
        long LIFETIME = set.getLong(4);
        int STATE = set.getInt(5);
        String ERRORMESSAGE = set.getString(6);
        String SCHEDULERID = set.getString(7);
        long SCHEDULER_TIMESTAMP = set.getLong(8);
        int NUMOFRETR = set.getInt(9);
        int MAXNUMOFRETR = set.getInt(10);
        long LASTSTATETRANSITIONTIME = set.getLong(11);
        Job job3 = job = this.getJob(_con, ID, NEXTJOBID, CREATIONTIME, LIFETIME, STATE, ERRORMESSAGE, SCHEDULERID, SCHEDULER_TIMESTAMP, NUMOFRETR, MAXNUMOFRETR, LASTSTATETRANSITIONTIME, set, 12);
        SqlHelper.tryToClose((ResultSet)set);
        SqlHelper.tryToClose((PreparedStatement)statement);
        return job3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveJob(final Job job, boolean saveifmonitoringisdesabled) throws SQLException {
        if (!saveifmonitoringisdesabled && !this.logHistory) {
            return;
        }
        if (this.states.put(job.getId(), UpdateState.QUEUED) == null) {
            JdbcConnectionPool.JdbcTask task = new JdbcConnectionPool.JdbcTask(){

                public String toString() {
                    return "save job " + job.getId() + (DatabaseJobStorage.this.logHistory ? " and its history" : "");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private int updateJob(Connection connection) throws SQLException {
                    int n;
                    PreparedStatement updateStatement = null;
                    try {
                        job.rlock();
                        try {
                            updateStatement = DatabaseJobStorage.this.getUpdateStatement(connection, job);
                        }
                        finally {
                            job.runlock();
                        }
                        n = updateStatement.executeUpdate();
                    }
                    catch (Throwable throwable) {
                        SqlHelper.tryToClose(updateStatement);
                        throw throwable;
                    }
                    SqlHelper.tryToClose((PreparedStatement)updateStatement);
                    return n;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void createJob(Connection connection) throws SQLException {
                    PreparedStatement createStatement = null;
                    PreparedStatement batchCreateStatement = null;
                    try {
                        job.rlock();
                        try {
                            createStatement = DatabaseJobStorage.this.getCreateStatement(connection, job);
                            batchCreateStatement = DatabaseJobStorage.this.getBatchCreateStatement(connection, job);
                        }
                        finally {
                            job.runlock();
                        }
                        createStatement.executeUpdate();
                        if (batchCreateStatement != null) {
                            batchCreateStatement.executeBatch();
                        }
                    }
                    catch (Throwable throwable) {
                        SqlHelper.tryToClose(createStatement);
                        SqlHelper.tryToClose(batchCreateStatement);
                        throw throwable;
                    }
                    SqlHelper.tryToClose((PreparedStatement)createStatement);
                    SqlHelper.tryToClose((PreparedStatement)batchCreateStatement);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void saveHistory(Connection connection, List<Job.JobHistory> history) throws SQLException {
                    PreparedStatement stmt = connection.prepareStatement("INSERT INTO " + DatabaseJobStorage.this.getHistoryTableName() + " VALUES (?,?,?,?,?)");
                    try {
                        for (Job.JobHistory element : history) {
                            stmt.setLong(1, element.getId());
                            stmt.setLong(2, job.getId());
                            stmt.setInt(3, element.getState().getStateId());
                            stmt.setLong(4, element.getTransitionTime());
                            stmt.setString(5, element.getDescription());
                            stmt.addBatch();
                        }
                        stmt.executeBatch();
                    }
                    finally {
                        SqlHelper.tryToClose((PreparedStatement)stmt);
                    }
                }

                private void markHistoryAsSaved(List<Job.JobHistory> history) {
                    for (Job.JobHistory element : history) {
                        element.setSaved();
                    }
                }

                private List<Job.JobHistory> getJobHistoriesToSave() {
                    return DatabaseJobStorage.this.logHistory ? Lists.newArrayList((Iterable)Iterables.filter(job.getJobHistory(), NOT_SAVED)) : Collections.emptyList();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute(Connection connection) throws SQLException {
                    DatabaseJobStorage.this.states.put(job.getId(), UpdateState.PROCESSING);
                    try {
                        List<Job.JobHistory> history = this.getJobHistoriesToSave();
                        connection.setAutoCommit(false);
                        boolean success = false;
                        try {
                            int rowCount = this.updateJob(connection);
                            if (rowCount == 0) {
                                this.createJob(connection);
                            }
                            if (!history.isEmpty()) {
                                this.saveHistory(connection, history);
                            }
                            connection.commit();
                            success = true;
                        }
                        finally {
                            if (!success) {
                                connection.rollback();
                            }
                        }
                        this.markHistoryAsSaved(history);
                    }
                    finally {
                        if (!DatabaseJobStorage.this.states.remove(job.getId(), (Object)UpdateState.PROCESSING)) {
                            DatabaseJobStorage.this.pool.execute(this);
                        }
                    }
                }
            };
            boolean success = false;
            try {
                this.pool.execute(task);
                success = true;
            }
            catch (SQLException sqle) {
            }
            finally {
                if (!success) {
                    this.states.remove(job.getId());
                }
            }
        }
    }

    protected PreparedStatement getBatchCreateStatement(Connection connection, Job job) throws SQLException {
        return null;
    }

    public abstract PreparedStatement getCreateStatement(Connection var1, Job var2) throws SQLException;

    public abstract PreparedStatement getUpdateStatement(Connection var1, Job var2) throws SQLException;

    @Override
    public Set<Job> getJobs(String schedulerId) throws SQLException {
        if (this.getJobsRan) {
            throw new SQLException("getJobs(" + schedulerId + ") has already run");
        }
        this.getJobsRan = true;
        HashSet<Job> jobs = new HashSet<Job>();
        Connection _con = null;
        try {
            _con = this.pool.getConnection();
            String sql = "SELECT * FROM ? WHERE SCHEDULERID=?";
            PreparedStatement sqlStatement = _con.prepareStatement(sql);
            sqlStatement.setString(1, this.getTableName());
            sqlStatement.setString(2, schedulerId);
            logger.debug("Selecting everything of Scheduler {} from table {}", (Object)schedulerId, (Object)this.getTableName());
            ResultSet set = sqlStatement.executeQuery();
            while (set.next()) {
                Long ID = set.getLong(1);
                Long NEXTJOBID = set.getLong(2);
                long CREATIONTIME = set.getLong(3);
                long LIFETIME = set.getLong(4);
                int STATE = set.getInt(5);
                String ERRORMESSAGE = set.getString(6);
                String SCHEDULERID = set.getString(7);
                long SCHEDULER_TIMESTAMP = set.getLong(8);
                int NUMOFRETR = set.getInt(9);
                int MAXNUMOFRETR = set.getInt(10);
                long LASTSTATETRANSITIONTIME = set.getLong(11);
                Job job = this.getJob(_con, ID, NEXTJOBID, CREATIONTIME, LIFETIME, STATE, ERRORMESSAGE, SCHEDULERID, SCHEDULER_TIMESTAMP, NUMOFRETR, MAXNUMOFRETR, LASTSTATETRANSITIONTIME, set, 13);
                logger.debug("==========> deserialization from database of job id {}", (Object)job.getId());
                logger.debug("==========> jobs submitter id is {}", (Object)job.getSubmitterId());
                jobs.add(job);
            }
            set.close();
            sqlStatement.close();
            this.pool.returnConnection(_con);
            _con = null;
            HashSet<Job> hashSet = jobs;
            return hashSet;
        }
        catch (SQLException sqle1) {
            if (_con != null) {
                this.pool.returnFailedConnection(_con);
                _con = null;
            }
            throw sqle1;
        }
        finally {
            if (_con != null) {
                this.pool.returnConnection(_con);
            }
        }
    }

    protected Job.JobHistory[] getJobHistory(Long jobId, Connection _con) throws SQLException {
        ArrayList<Job.JobHistory> l = new ArrayList<Job.JobHistory>();
        String select = "SELECT * FROM " + this.getHistoryTableName() + " WHERE JOBID=" + jobId;
        logger.debug("executing statement: {}", (Object)select);
        Statement statement = _con.createStatement();
        ResultSet set = statement.executeQuery(select);
        if (!set.next()) {
            logger.debug("no history elements in table {} found, returning NULL", (Object)this.getHistoryTableName());
            statement.close();
            return null;
        }
        do {
            long ID = set.getLong(1);
            int STATEID = set.getInt(3);
            long TRANSITIONTIME = set.getLong(4);
            String DESCRIPTION = set.getString(5);
            Job.JobHistory jh = new Job.JobHistory(ID, State.getState(STATEID), DESCRIPTION, TRANSITIONTIME);
            jh.setSaved();
            l.add(jh);
            logger.debug("found JobHistory: {}", (Object)jh.toString());
        } while (set.next());
        statement.close();
        return l.toArray(new Job.JobHistory[l.size()]);
    }

    public void schedulePendingJobs(Scheduler scheduler) throws SQLException, InterruptedException, IllegalStateTransition {
        Connection _con = null;
        try {
            _con = this.pool.getConnection();
            Statement sqlStatement = _con.createStatement();
            String sqlStatementString = "SELECT ID FROM " + this.getTableName() + " WHERE SCHEDULERID is NULL and State=" + State.PENDING.getStateId();
            logger.debug("executing statement: {}", (Object)sqlStatementString);
            ResultSet set = sqlStatement.executeQuery(sqlStatementString);
            HashSet<Long> idsSet = new HashSet<Long>();
            while (set.next()) {
                idsSet.add(set.getLong(1));
            }
            set.close();
            sqlStatement.close();
            this.pool.returnConnection(_con);
            _con = null;
            for (Long ID : idsSet) {
                try {
                    Job job = Job.getJob(ID, Job.class, _con);
                    scheduler.schedule(job);
                }
                catch (SRMInvalidRequestException ire) {
                    logger.error(ire.toString());
                }
            }
        }
        catch (SQLException sqle1) {
            if (_con != null) {
                this.pool.returnFailedConnection(_con);
                _con = null;
            }
            throw sqle1;
        }
        finally {
            if (_con != null) {
                this.pool.returnConnection(_con);
            }
        }
    }

    public void updatePendingJobs() throws SQLException, InterruptedException, IllegalStateTransition {
        if (this.updatePendingJobsRan) {
            throw new SQLException("updatePendingJobs() has already ran");
        }
        this.updatePendingJobsRan = true;
        Connection _con = null;
        try {
            _con = this.pool.getConnection();
            Statement sqlStatement = _con.createStatement();
            String sqlStatementString = "SELECT ID FROM " + this.getTableName() + " WHERE SCHEDULERID is NULL and State=" + State.PENDING.getStateId();
            logger.debug("executing statement: {}", (Object)sqlStatementString);
            ResultSet set = sqlStatement.executeQuery(sqlStatementString);
            HashSet<Long> idsSet = new HashSet<Long>();
            while (set.next()) {
                idsSet.add(set.getLong(1));
            }
            set.close();
            sqlStatement.close();
            this.pool.returnConnection(_con);
            _con = null;
            for (Long ID : idsSet) {
                try {
                    Job.getJob(ID, Job.class, _con);
                }
                catch (SRMInvalidRequestException ire) {
                    logger.error(ire.toString());
                }
            }
        }
        catch (SQLException sqle1) {
            if (_con != null) {
                this.pool.returnFailedConnection(_con);
                _con = null;
            }
            throw sqle1;
        }
        finally {
            if (_con != null) {
                this.pool.returnConnection(_con);
            }
        }
    }

    protected Set<Long> getJobIdsByCondition(String sqlCondition) throws SQLException {
        HashSet<Long> jobIds = new HashSet<Long>();
        Connection _con = null;
        try {
            _con = this.pool.getConnection();
            Statement sqlStatement = _con.createStatement();
            String sqlStatementString = "SELECT ID FROM " + this.getTableName() + " WHERE " + sqlCondition + " ";
            logger.debug("executing statement: {}", (Object)sqlStatementString);
            ResultSet set = sqlStatement.executeQuery(sqlStatementString);
            while (set.next()) {
                Long ID = set.getLong(1);
                jobIds.add(ID);
            }
            set.close();
            sqlStatement.close();
            this.pool.returnConnection(_con);
            _con = null;
            HashSet<Long> hashSet = jobIds;
            return hashSet;
        }
        catch (SQLException sqle1) {
            if (_con != null) {
                this.pool.returnFailedConnection(_con);
                _con = null;
            }
            throw sqle1;
        }
        finally {
            if (_con != null) {
                this.pool.returnConnection(_con);
            }
        }
    }

    @Override
    public Set<Job> getJobs(String schedulerId, State state) throws SQLException {
        HashSet<Job> hashSet;
        HashSet<Job> jobs = new HashSet<Job>();
        Connection _con = null;
        PreparedStatement sqlStatement = null;
        ResultSet set = null;
        try {
            _con = this.pool.getConnection();
            String sql = "SELECT * FROM " + this.getTableName() + " WHERE SCHEDULERID";
            sql = schedulerId == null ? sql + " is NULL" : sql + "=?";
            sql = sql + " AND STATE=? ";
            sqlStatement = _con.prepareStatement(sql);
            if (schedulerId == null) {
                sqlStatement.setInt(1, state.getStateId());
            } else {
                sqlStatement.setString(1, schedulerId);
                sqlStatement.setInt(2, state.getStateId());
            }
            logger.debug("executing statement {} ,values: {} ,{} ,{}", new Object[]{sql, this.getTableName(), schedulerId, state.getStateId()});
            set = sqlStatement.executeQuery();
            while (set.next()) {
                Long ID = set.getLong(1);
                Long NEXTJOBID = set.getLong(2);
                long CREATIONTIME = set.getLong(3);
                long LIFETIME = set.getLong(4);
                int STATE = set.getInt(5);
                String ERRORMESSAGE = set.getString(6);
                String SCHEDULERID = set.getString(7);
                long SCHEDULER_TIMESTAMP = set.getLong(8);
                int NUMOFRETR = set.getInt(9);
                int MAXNUMOFRETR = set.getInt(10);
                long LASTSTATETRANSITIONTIME = set.getLong(11);
                Job job = this.getJob(_con, ID, NEXTJOBID, CREATIONTIME, LIFETIME, STATE, ERRORMESSAGE, SCHEDULERID, SCHEDULER_TIMESTAMP, NUMOFRETR, MAXNUMOFRETR, LASTSTATETRANSITIONTIME, set, 13);
                logger.debug("==========> deserialization from database of {}", (Object)job);
                logger.debug("==========> jobs creator is {}", (Object)job.getSubmitterId());
                jobs.add(job);
            }
            this.pool.returnConnection(_con);
            _con = null;
            hashSet = jobs;
        }
        catch (SQLException sqle1) {
            try {
                if (_con != null) {
                    this.pool.returnFailedConnection(_con);
                    _con = null;
                }
                throw sqle1;
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(set);
                SqlHelper.tryToClose(sqlStatement);
                if (_con != null) {
                    this.pool.returnConnection(_con);
                }
                throw throwable;
            }
        }
        SqlHelper.tryToClose((ResultSet)set);
        SqlHelper.tryToClose((PreparedStatement)sqlStatement);
        if (_con != null) {
            this.pool.returnConnection(_con);
        }
        return hashSet;
    }

    protected void createTable(String tableName, String createStatement) throws SQLException {
        this.createTable(tableName, createStatement, false, false);
    }

    protected void createTable(String tableName, String createStatement, boolean verify, boolean clean) throws SQLException {
        Connection _con = null;
        try {
            this.pool = JdbcConnectionPool.getPool(this.jdbcUrl, this.jdbcClass, this.user, this.pass);
            _con = this.pool.getConnection();
            _con.setAutoCommit(true);
            DatabaseMetaData md = _con.getMetaData();
            String tableNameAsStored = Utilities.getIdentifierAsStored(md, tableName);
            ResultSet tableRs = md.getTables(null, null, tableNameAsStored, null);
            if (!tableRs.next()) {
                logger.debug("DatabaseMetaData.getTables returned empty result set");
                try {
                    logger.debug("{} does not exits", (Object)tableName);
                    Statement s = _con.createStatement();
                    logger.debug("executing statement: {}", (Object)createStatement);
                    int result = s.executeUpdate(createStatement);
                    s.close();
                }
                catch (SQLException sqle) {
                    logger.error("relation could already exist, ignoring: {}", (Object)sqle.toString());
                }
            } else if (verify) {
                ResultSet columns = md.getColumns(null, null, tableNameAsStored, null);
                int columnIndex = 0;
                try {
                    while (columns.next()) {
                        String columnName = columns.getString("COLUMN_NAME");
                        int columnDataType = columns.getInt("DATA_TYPE");
                        this.verify(++columnIndex, tableName, columnName, columnDataType);
                    }
                    if (this.getColumnNum() != columnIndex) {
                        throw new SQLException("database table schema changed: table named " + tableName + " has wrong number of fields: " + columnIndex + ", should be :" + this.getColumnNum());
                    }
                }
                catch (SQLException sqle) {
                    logger.warn("Verification failed, trying to rename the table and create the new one", (Throwable)sqle);
                    this.renameTable(tableName, _con);
                    this.reanamed_old_table = true;
                    Statement s = _con.createStatement();
                    logger.warn("Creating table {}", (Object)tableName);
                    logger.debug("executing statement: {}", (Object)createStatement);
                    int result = s.executeUpdate(createStatement);
                    s.close();
                }
            }
            if (clean) {
                String sqlStatementString = "UPDATE " + this.getTableName() + " SET STATE=" + State.DONE.getStateId() + " WHERE STATE=" + State.READY.getStateId();
                Statement s = _con.createStatement();
                logger.debug("executing statement: {}", (Object)sqlStatementString);
                int result = s.executeUpdate(sqlStatementString);
                s.close();
                sqlStatementString = "UPDATE " + this.getTableName() + " SET STATE=" + State.FAILED.getStateId() + " WHERE STATE !=" + State.FAILED.getStateId() + " AND" + " STATE !=" + State.CANCELED.getStateId() + " AND " + " STATE !=" + State.DONE.getStateId();
                s = _con.createStatement();
                logger.debug("executing statement: {}", (Object)sqlStatementString);
                result = s.executeUpdate(sqlStatementString);
                s.close();
            }
            tableRs.close();
            _con.setAutoCommit(false);
            this.pool.returnConnection(_con);
            _con = null;
        }
        catch (SQLException sqe) {
            if (_con != null) {
                this.pool.returnFailedConnection(_con);
                _con = null;
            }
            throw sqe;
        }
        catch (Exception ex) {
            logger.error(ex.toString());
            if (_con != null) {
                this.pool.returnFailedConnection(_con);
                _con = null;
            }
            throw new SQLException(ex.toString());
        }
        finally {
            if (_con != null) {
                _con.setAutoCommit(false);
                this.pool.returnConnection(_con);
            }
        }
    }

    protected int renameTable(String oldName) throws SQLException {
        Connection _con = null;
        try {
            this.pool = JdbcConnectionPool.getPool(this.jdbcUrl, this.jdbcClass, this.user, this.pass);
            _con = this.pool.getConnection();
            _con.setAutoCommit(true);
            int n = this.renameTable(oldName, _con);
            return n;
        }
        catch (SQLException sqe) {
            if (_con != null) {
                this.pool.returnFailedConnection(_con);
                _con = null;
            }
            throw sqe;
        }
        catch (Exception ex) {
            logger.error(ex.toString());
            if (_con != null) {
                this.pool.returnFailedConnection(_con);
                _con = null;
            }
            throw new SQLException(ex.toString());
        }
        finally {
            if (_con != null) {
                _con.setAutoCommit(false);
                this.pool.returnConnection(_con);
            }
        }
    }

    protected int renameTable(String oldName, Connection _con) throws SQLException {
        String dropStatement = "DROP TABLE IF EXISTS " + oldName + " CASCADE";
        Statement s = _con.createStatement();
        logger.warn("Moving SRM table {} away as its schema is out-of-date", (Object)oldName);
        logger.debug("executing statement: {}", (Object)dropStatement);
        int result = s.executeUpdate(dropStatement);
        s.close();
        return result;
    }

    protected abstract int getAdditionalColumnsNum();

    private int getColumnNum() {
        return COLLUMNS_NUM + this.getAdditionalColumnsNum();
    }

    protected void createIndex(String[] columnNames, String tableName) throws SQLException {
        Connection _con = null;
        try {
            this.pool = JdbcConnectionPool.getPool(this.jdbcUrl, this.jdbcClass, this.user, this.pass);
            _con = this.pool.getConnection();
            _con.setAutoCommit(true);
            DatabaseMetaData dbMetaData = _con.getMetaData();
            ResultSet index_rset = dbMetaData.getIndexInfo(null, null, Utilities.getIdentifierAsStored(dbMetaData, tableName), false, false);
            HashSet<String> listOfColumnsToBeIndexed = new HashSet<String>();
            for (String columnName1 : columnNames) {
                listOfColumnsToBeIndexed.add(columnName1.toLowerCase());
            }
            while (index_rset.next()) {
                String s = index_rset.getString("column_name").toLowerCase();
                if (!listOfColumnsToBeIndexed.contains(s)) continue;
                listOfColumnsToBeIndexed.remove(s);
            }
            if (listOfColumnsToBeIndexed.size() == 0) {
                logger.debug("all indexes were already made for table {}", (Object)tableName);
                _con.setAutoCommit(false);
                this.pool.returnConnection(_con);
                _con = null;
                return;
            }
            for (String columnName : listOfColumnsToBeIndexed) {
                String indexName = tableName.toLowerCase() + "_" + columnName + INDEX_SUFFIX;
                this.createIndex(_con, indexName, tableName, columnName);
            }
            _con.setAutoCommit(false);
            this.pool.returnConnection(_con);
            _con = null;
        }
        catch (SQLException sqe) {
            if (_con != null) {
                this.pool.returnFailedConnection(_con);
                _con = null;
            }
            throw sqe;
        }
        catch (Exception ex) {
            logger.error(ex.toString());
            if (_con != null) {
                this.pool.returnFailedConnection(_con);
                _con = null;
            }
            throw new SQLException(ex.toString());
        }
        finally {
            if (_con != null) {
                _con.setAutoCommit(false);
                this.pool.returnConnection(_con);
            }
        }
    }

    protected void createIndex(String indexname, String expression, String tableName) throws SQLException {
        indexname = indexname.toLowerCase();
        Connection _con = null;
        try {
            this.pool = JdbcConnectionPool.getPool(this.jdbcUrl, this.jdbcClass, this.user, this.pass);
            _con = this.pool.getConnection();
            _con.setAutoCommit(true);
            DatabaseMetaData dbMetaData = _con.getMetaData();
            ResultSet index_rset = dbMetaData.getIndexInfo(null, null, Utilities.getIdentifierAsStored(dbMetaData, tableName), false, false);
            while (index_rset.next()) {
                String s = index_rset.getString("index_name").toLowerCase();
                if (!indexname.equals(s)) continue;
                logger.debug("index {} already exists", (Object)indexname);
                _con.setAutoCommit(false);
                this.pool.returnConnection(_con);
                _con = null;
                return;
            }
            this.createIndex(_con, indexname, tableName, expression);
            _con.setAutoCommit(false);
            this.pool.returnConnection(_con);
            _con = null;
        }
        catch (SQLException sqe) {
            if (_con != null) {
                this.pool.returnFailedConnection(_con);
                _con = null;
            }
            throw sqe;
        }
        catch (Exception ex) {
            logger.error(ex.toString());
            if (_con != null) {
                this.pool.returnFailedConnection(_con);
                _con = null;
            }
            throw new SQLException(ex.toString());
        }
        finally {
            if (_con != null) {
                _con.setAutoCommit(false);
                this.pool.returnConnection(_con);
            }
        }
    }

    protected void createIndex(Connection _con, String indexName, String tableName, String column_or_expression) throws SQLException {
        String createIndexStatementText = "CREATE INDEX " + indexName + " ON " + tableName + " (" + column_or_expression + ")";
        logger.debug("Executing {}", (Object)createIndexStatementText);
        try (Statement createIndexStatement = _con.createStatement();){
            createIndexStatement.executeUpdate(createIndexStatementText);
        }
        catch (SQLException e) {
            logger.error("failed to execute '{}': {}", (Object)createIndexStatementText, (Object)e.toString());
        }
    }

    protected abstract void _verify(int var1, int var2, String var3, String var4, int var5) throws SQLException;

    protected String getTypeName(int type) {
        Field[] fields;
        for (Field field : fields = Types.class.getFields()) {
            try {
                Object val = field.get(null);
                int value = (Integer)val;
                if (value != type) continue;
                return field.getName();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return "UNKNOWN SQL TYPE:" + type;
    }

    protected void verifyLongType(String expectedName, int columnIndex, String tableName, String columnName, int columnType) throws SQLException {
        if (!columnName.equalsIgnoreCase(expectedName)) {
            throw new SQLException("database table schema changed:table named " + tableName + " column #" + columnIndex + " has name \"" + columnName + "\" should be \"" + expectedName + "\"");
        }
        if (columnType != -5) {
            throw new SQLException("database table schema changed:table named " + tableName + " column #" + columnIndex + " has type \"" + this.getTypeName(columnType) + "\" should be \"" + longType + "\"");
        }
    }

    protected void verifyIntType(String expectedName, int columnIndex, String tableName, String columnName, int columnType) throws SQLException {
        if (!columnName.equalsIgnoreCase(expectedName)) {
            throw new SQLException("database table schema changed:table named " + tableName + " column #" + columnIndex + " has name \"" + columnName + "\" should be \"" + expectedName + "\"");
        }
        if (columnType != 4) {
            throw new SQLException("database table schema changed:table named " + tableName + " column #" + columnIndex + " has type \"" + this.getTypeName(columnType) + "\" should be \"" + intType + "\"");
        }
    }

    protected void verifyBooleanType(String expectedName, int columnIndex, String tableName, String columnName, int columnType) throws SQLException {
        if (!columnName.equalsIgnoreCase(expectedName)) {
            throw new SQLException("database table schema changed:table named " + tableName + " column #" + columnIndex + " has name \"" + columnName + "\" should be \"" + expectedName + "\"");
        }
        if (columnType != 4) {
            throw new SQLException("database table schema changed:table named " + tableName + " column #" + columnIndex + " has type \"" + this.getTypeName(columnType) + "\" should be \"" + booleanType + "\"");
        }
    }

    protected void verifyStringType(String expectedName, int columnIndex, String tableName, String columnName, int columnType) throws SQLException {
        if (!columnName.equalsIgnoreCase(expectedName)) {
            throw new SQLException("database table schema changed:table named " + tableName + " column #" + columnIndex + " has name \"" + columnName + "\" should be \"" + expectedName + "\"");
        }
        if (columnType != 12) {
            throw new SQLException("database table schema changed:table named " + tableName + " column #" + columnIndex + " named \"" + columnName + "\" has type \"" + this.getTypeName(columnType) + "\" should be \"" + stringType + "\"");
        }
    }

    public void verify(int columnIndex, String tableName, String columnName, int columnType) throws SQLException {
        switch (columnIndex) {
            case 1: {
                this.verifyLongType("ID", columnIndex, tableName, columnName, columnType);
                break;
            }
            case 2: {
                this.verifyLongType("NEXTJOBID", columnIndex, tableName, columnName, columnType);
                break;
            }
            case 3: {
                this.verifyLongType("CREATIONTIME", columnIndex, tableName, columnName, columnType);
                break;
            }
            case 4: {
                this.verifyLongType("LIFETIME", columnIndex, tableName, columnName, columnType);
                break;
            }
            case 5: {
                this.verifyIntType("STATE", columnIndex, tableName, columnName, columnType);
                break;
            }
            case 6: {
                this.verifyStringType("ERRORMESSAGE", columnIndex, tableName, columnName, columnType);
                break;
            }
            case 7: {
                this.verifyStringType("SCHEDULERID", columnIndex, tableName, columnName, columnType);
                break;
            }
            case 8: {
                this.verifyLongType("SCHEDULERTIMESTAMP", columnIndex, tableName, columnName, columnType);
                break;
            }
            case 9: {
                this.verifyLongType("NUMOFRETR", columnIndex, tableName, columnName, columnType);
                break;
            }
            case 10: {
                this.verifyLongType("MAXNUMOFRETR", columnIndex, tableName, columnName, columnType);
                break;
            }
            case 11: {
                this.verifyLongType("LASTSTATETRANSITIONTIME", columnIndex, tableName, columnName, columnType);
                break;
            }
            default: {
                this._verify(12, columnIndex, tableName, columnName, columnType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        long update_period = TimeUnit.SECONDS.toMillis(this.configuration.getExpiredRequestRemovalPeriod());
        long history_lifetime = TimeUnit.DAYS.toMillis(this.configuration.getKeepRequestHistoryPeriod());
        while (true) {
            try {
                Thread.sleep(update_period);
            }
            catch (InterruptedException ie) {
                logger.info("database update thread interrupted");
                return;
            }
            long currenttime = System.currentTimeMillis();
            long cutout_expiration_time = currenttime - history_lifetime;
            Connection _con = null;
            try {
                this.pool = JdbcConnectionPool.getPool(this.jdbcUrl, this.jdbcClass, this.user, this.pass);
                _con = this.pool.getConnection();
                String sqlStatementString = "DELETE from " + this.getTableName() + " WHERE CREATIONTIME+LIFETIME < " + cutout_expiration_time;
                Statement s = _con.createStatement();
                int result = s.executeUpdate(sqlStatementString);
                s.close();
                _con.commit();
                if (_con == null) continue;
                this.pool.returnConnection(_con);
                continue;
            }
            catch (SQLException sqe) {
                if (_con == null) continue;
                this.pool.returnFailedConnection(_con);
                _con = null;
                continue;
            }
            catch (Exception ex) {
                logger.error(ex.toString());
                if (_con != null) {
                    this.pool.returnFailedConnection(_con);
                    _con = null;
                }
                if (_con == null) continue;
                this.pool.returnConnection(_con);
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (_con == null) continue;
                this.pool.returnConnection(_con);
                continue;
            }
            break;
        }
    }

    public PreparedStatement getPreparedStatement(Connection connection, String query, Object ... args) throws SQLException {
        PreparedStatement stmt = connection.prepareStatement(query);
        for (int i = 0; i < args.length; ++i) {
            stmt.setObject(i + 1, args[i]);
        }
        return stmt;
    }

    static enum UpdateState {
        QUEUED,
        PROCESSING;

    }
}

