/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dcache.srm.request.BringOnlineFileRequest;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.Job;
import org.dcache.srm.request.sql.DatabaseFileRequestStorage;
import org.dcache.srm.util.Configuration;

public class BringOnlineFileRequestStorage
extends DatabaseFileRequestStorage {
    public static final String TABLE_NAME = "bringonlinefilerequests";
    private static final String UPDATE_PREFIX = "UPDATE bringonlinefilerequests SET NEXTJOBID=?, CREATIONTIME=?,  LIFETIME=?, STATE=?, ERRORMESSAGE=?, SCHEDULERID=?, SCHEDULERTIMESTAMP=?,NUMOFRETR=?,MAXNUMOFRETR=?,LASTSTATETRANSITIONTIME=? ";
    private static int ADDITIONAL_FIELDS = 3;
    private static final String UPDATE_REQUEST_SQL = "UPDATE bringonlinefilerequests SET NEXTJOBID=?, CREATIONTIME=?,  LIFETIME=?, STATE=?, ERRORMESSAGE=?, SCHEDULERID=?, SCHEDULERTIMESTAMP=?,NUMOFRETR=?,MAXNUMOFRETR=?,LASTSTATETRANSITIONTIME=? , REQUESTID=?, CREDENTIALID=?, STATUSCODE=?, SURL=?, FILEID=?, PINID=? WHERE ID=?";
    private static final String INSERT_SQL = "INSERT INTO bringonlinefilerequests(    ID ,NEXTJOBID ,CREATIONTIME ,LIFETIME ,STATE ,ERRORMESSAGE ,SCHEDULERID ,SCHEDULERTIMESTAMP ,NUMOFRETR ,MAXNUMOFRETR ,LASTSTATETRANSITIONTIME,REQUESTID , CREDENTIALID , STATUSCODE ,SURL ,FILEID ,PINID  ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    public BringOnlineFileRequestStorage(Configuration.DatabaseParameters configuration) throws SQLException {
        super(configuration);
    }

    @Override
    protected FileRequest getFileRequest(Connection _con, Long ID, Long NEXTJOBID, long CREATIONTIME, long LIFETIME, int STATE, String ERRORMESSAGE, String SCHEDULERID, long SCHEDULER_TIMESTAMP, int NUMOFRETR, int MAXNUMOFRETR, long LASTSTATETRANSITIONTIME, Long REQUESTID, Long CREDENTIALID, String STATUSCODE, ResultSet set, int next_index) throws SQLException {
        String SURL2 = set.getString(next_index++);
        String FILEID = set.getString(next_index++);
        String PINID = set.getString(next_index);
        Job.JobHistory[] jobHistoryArray = this.getJobHistory(ID, _con);
        return new BringOnlineFileRequest(ID, NEXTJOBID, CREATIONTIME, LIFETIME, STATE, ERRORMESSAGE, SCHEDULERID, SCHEDULER_TIMESTAMP, NUMOFRETR, MAXNUMOFRETR, LASTSTATETRANSITIONTIME, jobHistoryArray, REQUESTID, CREDENTIALID, STATUSCODE, SURL2, FILEID, PINID);
    }

    @Override
    public String getFileRequestCreateTableFields() {
        return ",SURL  VARCHAR(32672) ,FILEID  VARCHAR(32672) ,PINID  VARCHAR(32672) ";
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    public PreparedStatement getStatement(Connection connection, String query, Job fr) throws SQLException {
        BringOnlineFileRequest gfr = (BringOnlineFileRequest)fr;
        PreparedStatement stmt = this.getPreparedStatement(connection, query, gfr.getNextJobId(), gfr.getCreationTime(), gfr.getLifetime(), gfr.getState().getStateId(), gfr.getErrorMessage(), gfr.getSchedulerId(), gfr.getSchedulerTimeStamp(), gfr.getNumberOfRetries(), gfr.getMaxNumberOfRetries(), gfr.getLastStateTransitionTime(), gfr.getRequestId(), gfr.getCredentialId(), gfr.getStatusCodeString(), gfr.getSurlString(), gfr.getFileId(), gfr.getPinId(), gfr.getId());
        return stmt;
    }

    @Override
    public PreparedStatement getUpdateStatement(Connection connection, Job fr) throws SQLException {
        return this.getStatement(connection, UPDATE_REQUEST_SQL, fr);
    }

    @Override
    public PreparedStatement getCreateStatement(Connection connection, Job fr) throws SQLException {
        BringOnlineFileRequest gfr = (BringOnlineFileRequest)fr;
        PreparedStatement stmt = this.getPreparedStatement(connection, INSERT_SQL, gfr.getId(), gfr.getNextJobId(), gfr.getCreationTime(), gfr.getLifetime(), gfr.getState().getStateId(), gfr.getErrorMessage(), gfr.getSchedulerId(), gfr.getSchedulerTimeStamp(), gfr.getNumberOfRetries(), gfr.getMaxNumberOfRetries(), gfr.getLastStateTransitionTime(), gfr.getRequestId(), gfr.getCredentialId(), gfr.getStatusCodeString(), gfr.getSurlString(), gfr.getFileId(), gfr.getPinId());
        return stmt;
    }

    @Override
    public String getRequestTableName() {
        return "getrequests";
    }

    @Override
    protected void __verify(int nextIndex, int columnIndex, String tableName, String columnName, int columnType) throws SQLException {
        if (columnIndex == nextIndex) {
            this.verifyStringType("SURL", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 1) {
            this.verifyStringType("FILEID", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 2) {
            this.verifyStringType("PINID", columnIndex, tableName, columnName, columnType);
        } else {
            throw new SQLException("database table schema changed:table named " + tableName + " column #" + columnIndex + " has name \"" + columnName + "\"  has type \"" + this.getTypeName(columnType) + " this column should not be present!!!");
        }
    }

    @Override
    protected int getMoreCollumnsNum() {
        return ADDITIONAL_FIELDS;
    }
}

