/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.dcache.srm.request.RequestCredentialStorage;
import org.dcache.srm.scheduler.JobIdGeneratorFactory;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class RequestCredential {
    private static final Map<Long, WeakReference<RequestCredential>> weakRequestCredentialStorage = Collections.synchronizedMap(new WeakHashMap());
    private Long id;
    private long creationtime;
    private String credentialName;
    private String role;
    private boolean saved;
    private GSSCredential delegatedCredential;
    private long delegatedCredentialExpiration;
    private RequestCredentialStorage storage;
    private int credential_users;
    private static final Set<RequestCredentialStorage> requestCredentailStorages = new HashSet<RequestCredentialStorage>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerRequestCredentialStorage(RequestCredentialStorage requestCredentialStorage) {
        Set<RequestCredentialStorage> set = requestCredentailStorages;
        synchronized (set) {
            requestCredentailStorages.add(requestCredentialStorage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestCredential getRequestCredential(Long requestCredentialId) {
        RequestCredentialStorage[] requestCreatorStoragesArray;
        Object o;
        Map<Long, WeakReference<RequestCredential>> map = weakRequestCredentialStorage;
        synchronized (map) {
            WeakReference<RequestCredential> ref;
            RequestCredential o1;
            o = weakRequestCredentialStorage.get(requestCredentialId);
            if (o != null && (o1 = (RequestCredential)(ref = o).get()) != null) {
                return o1;
            }
        }
        o = requestCredentailStorages;
        synchronized (o) {
            requestCreatorStoragesArray = requestCredentailStorages.toArray(new RequestCredentialStorage[requestCredentailStorages.size()]);
        }
        for (RequestCredentialStorage aRequestCreatorStoragesArray : requestCreatorStoragesArray) {
            RequestCredential requestCredential = aRequestCreatorStoragesArray.getRequestCredential(requestCredentialId);
            if (requestCredential == null) continue;
            Map<Long, WeakReference<RequestCredential>> map2 = weakRequestCredentialStorage;
            synchronized (map2) {
                weakRequestCredentialStorage.put(requestCredential.id, new WeakReference<RequestCredential>(requestCredential));
            }
            return requestCredential;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestCredential getRequestCredential(String credentialName, String role) {
        RequestCredentialStorage[] requestCreatorStoragesArray;
        Map<Long, WeakReference<RequestCredential>> map = weakRequestCredentialStorage;
        synchronized (map) {
            for (WeakReference<RequestCredential> ref : weakRequestCredentialStorage.values()) {
                RequestCredential cred = (RequestCredential)ref.get();
                if (cred == null) continue;
                String credName = cred.getCredentialName();
                String credRole = cred.getRole();
                if (!credName.equals(credentialName) || (role != null || credRole != null) && (role == null || !role.equals(credRole))) continue;
                return cred;
            }
        }
        Set<RequestCredentialStorage> i$ = requestCredentailStorages;
        synchronized (i$) {
            requestCreatorStoragesArray = requestCredentailStorages.toArray(new RequestCredentialStorage[requestCredentailStorages.size()]);
        }
        for (RequestCredentialStorage requestCredentialStorage : requestCreatorStoragesArray) {
            RequestCredential requestCredential = requestCredentialStorage.getRequestCredential(credentialName, role);
            if (requestCredential == null) continue;
            Map<Long, WeakReference<RequestCredential>> map2 = weakRequestCredentialStorage;
            synchronized (map2) {
                weakRequestCredentialStorage.put(requestCredential.id, new WeakReference<RequestCredential>(requestCredential));
            }
            return requestCredential;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestCredential(String credentialName, String role, GSSCredential delegatedCredential, RequestCredentialStorage storage) throws SQLException, GSSException {
        this.id = JobIdGeneratorFactory.getJobIdGeneratorFactory().getJobIdGenerator().getNextId();
        this.creationtime = System.currentTimeMillis();
        this.credentialName = credentialName;
        this.role = role;
        if (delegatedCredential != null) {
            this.delegatedCredential = delegatedCredential;
            this.delegatedCredentialExpiration = this.creationtime + (long)delegatedCredential.getRemainingLifetime() * 1000L;
        }
        this.storage = storage;
        Map<Long, WeakReference<RequestCredential>> map = weakRequestCredentialStorage;
        synchronized (map) {
            weakRequestCredentialStorage.put(this.id, new WeakReference<RequestCredential>(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestCredential(Long id, long creationtime, String credentialName, String role, GSSCredential delegatedCredential, long delegatedCredentialExpiration, RequestCredentialStorage storage) throws SQLException {
        this.id = id;
        this.creationtime = creationtime;
        this.credentialName = credentialName;
        this.role = role;
        if (delegatedCredential != null) {
            this.delegatedCredential = delegatedCredential;
            this.delegatedCredentialExpiration = delegatedCredentialExpiration;
        }
        this.storage = storage;
        Map<Long, WeakReference<RequestCredential>> map = weakRequestCredentialStorage;
        synchronized (map) {
            weakRequestCredentialStorage.put(this.id, new WeakReference<RequestCredential>(this));
        }
    }

    public GSSCredential getDelegatedCredential() {
        return this.delegatedCredential;
    }

    public void keepBestDelegatedCredential(GSSCredential delegatedCredential) throws GSSException {
        if (delegatedCredential == null) {
            return;
        }
        long newCredentialExpiration = System.currentTimeMillis() + (long)delegatedCredential.getRemainingLifetime() * 1000L;
        if (this.delegatedCredential == null || newCredentialExpiration > this.delegatedCredentialExpiration) {
            this.delegatedCredential = delegatedCredential;
            this.delegatedCredentialExpiration = newCredentialExpiration;
            this.saved = false;
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getCredentialName() {
        return this.credentialName;
    }

    public String toString() {
        return "RequestCredential[" + this.credentialName + "," + (this.delegatedCredential == null ? "nondelegated" : "delegated, remaining lifetime : " + this.getDelegatedCredentialRemainingLifetime() + " millis") + "  ]";
    }

    public void decreaseCredential_users() {
        --this.credential_users;
        if (this.credential_users == 0) {
            this.delegatedCredential = null;
        }
        this.storage.saveRequestCredential(this);
    }

    public int getCredential_users() {
        return this.credential_users;
    }

    public void setCredential_users(int credential_users) {
        this.credential_users = credential_users;
    }

    public void saveCredential() {
        if (this.saved) {
            return;
        }
        this.storage.saveRequestCredential(this);
        this.saved = true;
    }

    public String getRole() {
        return this.role;
    }

    public long getDelegatedCredentialExpiration() {
        return this.delegatedCredentialExpiration;
    }

    public long getCreationtime() {
        return this.creationtime;
    }

    public long getDelegatedCredentialRemainingLifetime() {
        long lifetime = this.delegatedCredentialExpiration - System.currentTimeMillis();
        return lifetime < 0L ? 0L : lifetime;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }
}

