/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import com.google.common.collect.Lists;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMReleasedException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.ContainerRequest;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.Job;
import org.dcache.srm.request.PutFileRequest;
import org.dcache.srm.scheduler.FatalJobFailure;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.NonFatalJobFailure;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.v2_2.ArrayOfTPutRequestFileStatus;
import org.dcache.srm.v2_2.SrmPrepareToPutResponse;
import org.dcache.srm.v2_2.SrmStatusOfPutRequestResponse;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TOverwriteMode;
import org.dcache.srm.v2_2.TPutRequestFileStatus;
import org.dcache.srm.v2_2.TRequestType;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TSURLReturnStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PutRequest
extends ContainerRequest {
    private static final Logger logger = LoggerFactory.getLogger(PutRequest.class);
    private final String[] protocols;
    private TOverwriteMode overwriteMode;

    public PutRequest(SRMUser user, Long requestCredentialId, String[] srcFileNames, String[] destUrls, long[] sizes, boolean[] wantPermanent, String[] protocols, long lifetime, long max_update_period, int max_number_of_retries, String client_host, String spaceToken, TRetentionPolicy retentionPolicy, TAccessLatency accessLatency, String description) throws Exception {
        super(user, requestCredentialId, max_number_of_retries, max_update_period, lifetime, description, client_host);
        int len = protocols.length;
        this.protocols = new String[len];
        System.arraycopy(protocols, 0, this.protocols, 0, len);
        len = srcFileNames.length;
        if (len != destUrls.length || len != sizes.length || len != wantPermanent.length) {
            throw new IllegalArgumentException("srcFileNames, destUrls, sizes, wantPermanent arrays dimensions mismatch");
        }
        ArrayList requests = Lists.newArrayListWithCapacity((int)len);
        for (int i = 0; i < len; ++i) {
            PutFileRequest request = new PutFileRequest(this.getId(), requestCredentialId, destUrls[i], sizes[i], lifetime, max_number_of_retries, spaceToken, retentionPolicy, accessLatency);
            requests.add(request);
        }
        this.setFileRequests(requests);
        this.updateMemoryCache();
    }

    public PutRequest(Long id, Long nextJobId, long creationTime, long lifetime, int stateId, String errorMessage, SRMUser user, String scheduelerId, long schedulerTimeStamp, int numberOfRetries, int maxNumberOfRetries, long lastStateTransitionTime, Job.JobHistory[] jobHistoryArray, Long credentialId, FileRequest[] fileRequests, int retryDeltaTime, boolean should_updateretryDeltaTime, String description, String client_host, String statusCodeString, String[] protocols) throws SQLException {
        super(id, nextJobId, creationTime, lifetime, stateId, errorMessage, user, scheduelerId, schedulerTimeStamp, numberOfRetries, maxNumberOfRetries, lastStateTransitionTime, jobHistoryArray, credentialId, fileRequests, retryDeltaTime, should_updateretryDeltaTime, description, client_host, statusCodeString);
        this.protocols = protocols;
    }

    @Override
    public FileRequest getFileRequestBySurl(URI surl) throws SQLException, SRMException {
        if (surl == null) {
            throw new SRMException("surl is null");
        }
        for (FileRequest request : this.getFileRequests()) {
            if (!((PutFileRequest)request).getSurl().equals(surl)) continue;
            return request;
        }
        throw new SRMException("file request for surl =" + surl + " is not found");
    }

    @Override
    public void schedule() throws InterruptedException, IllegalStateTransition {
        this.saveJob(true);
        for (FileRequest request : this.getFileRequests()) {
            request.schedule();
        }
    }

    public void proccessRequest() {
        String[] supported_protocols;
        logger.debug("proccessing put request");
        try {
            supported_protocols = this.getStorage().supportedGetProtocols();
        }
        catch (SRMException srme) {
            logger.error(" protocols are not supported");
            logger.error(srme.toString());
            return;
        }
        HashSet<String> supported_protocols_set = new HashSet<String>(Arrays.asList(supported_protocols));
        supported_protocols_set.retainAll(Arrays.asList(this.protocols));
        if (supported_protocols_set.isEmpty()) {
            logger.error("processPutRequest() : error selecting protocol");
            return;
        }
        supported_protocols_set = null;
    }

    @Override
    public String getMethod() {
        return "Put";
    }

    public boolean shouldStopHandlerIfReady() {
        return false;
    }

    @Override
    public void run() throws NonFatalJobFailure, FatalJobFailure {
    }

    @Override
    protected void stateChanged(State oldState) {
        State state = this.getState();
        if (State.isFinalState(state)) {
            logger.debug("copy request state changed to " + (Object)((Object)state));
            for (FileRequest request : this.getFileRequests()) {
                try {
                    State fr_state = request.getState();
                    if (State.isFinalState(fr_state)) continue;
                    logger.debug("changing fr#" + request.getId() + " to " + (Object)((Object)state));
                    request.setState(state, "changing file state because request state has changed");
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
            }
        }
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public final SrmPrepareToPutResponse getSrmPrepareToPutResponse(long timeout) throws SRMException, SQLException, InterruptedException {
        Date deadline = this.getDateRelativeToNow(timeout);
        int counter = this._stateChangeCounter.get();
        SrmPrepareToPutResponse response = this.getSrmPrepareToPutResponse();
        while (response.getReturnStatus().getStatusCode().isProcessing() && this._stateChangeCounter.awaitChangeUntil(counter, deadline)) {
            counter = this._stateChangeCounter.get();
            response = this.getSrmPrepareToPutResponse();
        }
        return response;
    }

    public final SrmPrepareToPutResponse getSrmPrepareToPutResponse() throws SRMException, SQLException {
        SrmPrepareToPutResponse response = new SrmPrepareToPutResponse();
        response.setReturnStatus(this.getTReturnStatus());
        response.setRequestToken(this.getTRequestToken());
        ArrayOfTPutRequestFileStatus arrayOfTPutRequestFileStatus = new ArrayOfTPutRequestFileStatus();
        arrayOfTPutRequestFileStatus.setStatusArray(this.getArrayOfTPutRequestFileStatus(null));
        response.setArrayOfFileStatuses(arrayOfTPutRequestFileStatus);
        return response;
    }

    public final SrmStatusOfPutRequestResponse getSrmStatusOfPutRequestResponse() throws SRMException, SQLException {
        return this.getSrmStatusOfPutRequestResponse(null);
    }

    public final SrmStatusOfPutRequestResponse getSrmStatusOfPutRequestResponse(URI[] surls) throws SRMException, SQLException {
        SrmStatusOfPutRequestResponse response = new SrmStatusOfPutRequestResponse();
        response.setReturnStatus(this.getTReturnStatus());
        ArrayOfTPutRequestFileStatus arrayOfTPutRequestFileStatus = new ArrayOfTPutRequestFileStatus();
        arrayOfTPutRequestFileStatus.setStatusArray(this.getArrayOfTPutRequestFileStatus(surls));
        response.setArrayOfFileStatuses(arrayOfTPutRequestFileStatus);
        StringBuilder s = new StringBuilder("getSrmStatusOfPutRequestResponse:");
        s.append(" StatusCode = ").append(response.getReturnStatus().getStatusCode());
        for (TPutRequestFileStatus fs : arrayOfTPutRequestFileStatus.getStatusArray()) {
            s.append(" FileStatusCode = ").append(fs.getStatus().getStatusCode());
        }
        logger.debug(s.toString());
        return response;
    }

    private String getTRequestToken() {
        return this.getId().toString();
    }

    private TPutRequestFileStatus[] getArrayOfTPutRequestFileStatus(URI[] surls) throws SRMException, SQLException {
        int len = surls == null ? this.getNumOfFileRequest() : surls.length;
        TPutRequestFileStatus[] putFileStatuses = new TPutRequestFileStatus[len];
        if (surls == null) {
            for (int i = 0; i < len; ++i) {
                PutFileRequest fr = (PutFileRequest)this.getFileRequests().get(i);
                putFileStatuses[i] = fr.getTPutRequestFileStatus();
            }
        } else {
            for (int i = 0; i < len; ++i) {
                PutFileRequest fr = (PutFileRequest)this.getFileRequestBySurl(surls[i]);
                putFileStatuses[i] = fr.getTPutRequestFileStatus();
            }
        }
        return putFileStatuses;
    }

    @Override
    public TSURLReturnStatus[] getArrayOfTSURLReturnStatus(URI[] surls) throws SRMException, SQLException {
        TSURLReturnStatus[] surlLReturnStatuses;
        int len;
        if (surls == null) {
            len = this.getNumOfFileRequest();
            surlLReturnStatuses = new TSURLReturnStatus[len];
        } else {
            len = surls.length;
            surlLReturnStatuses = new TSURLReturnStatus[surls.length];
        }
        boolean failed_req = false;
        boolean pending_req = false;
        boolean running_req = false;
        boolean ready_req = false;
        boolean done_req = false;
        String fr_error = "";
        if (surls == null) {
            for (int i = 0; i < len; ++i) {
                PutFileRequest fr = (PutFileRequest)this.getFileRequests().get(i);
                surlLReturnStatuses[i] = fr.getTSURLReturnStatus();
            }
        } else {
            for (int i = 0; i < len; ++i) {
                PutFileRequest fr = (PutFileRequest)this.getFileRequestBySurl(surls[i]);
                surlLReturnStatuses[i] = fr.getTSURLReturnStatus();
            }
        }
        return surlLReturnStatuses;
    }

    @Override
    public TRequestType getRequestType() {
        return TRequestType.PREPARE_TO_PUT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TOverwriteMode getOverwriteMode() {
        this.rlock();
        try {
            TOverwriteMode tOverwriteMode = this.overwriteMode;
            return tOverwriteMode;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOverwriteMode(TOverwriteMode overwriteMode) {
        this.wlock();
        try {
            this.overwriteMode = overwriteMode;
        }
        finally {
            this.wunlock();
        }
    }

    public final boolean isOverwrite() {
        if (this.getConfiguration().isOverwrite()) {
            TOverwriteMode mode = this.getOverwriteMode();
            if (mode == null) {
                return this.getConfiguration().isOverwrite_by_default();
            }
            return mode.equals(TOverwriteMode.ALWAYS);
        }
        return false;
    }

    @Override
    public long extendLifetimeMillis(long newLifetimeInMillis) throws SRMException {
        try {
            return super.extendLifetimeMillis(newLifetimeInMillis);
        }
        catch (SRMReleasedException releasedException) {
            throw new SRMInvalidRequestException(releasedException.getMessage());
        }
    }
}

