/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.axis.types.URI;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMTooManyResultsException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.ContainerRequest;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.Job;
import org.dcache.srm.request.LsFileRequest;
import org.dcache.srm.scheduler.FatalJobFailure;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.NonFatalJobFailure;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.util.RequestStatusTool;
import org.dcache.srm.v2_2.ArrayOfTMetaDataPathDetail;
import org.dcache.srm.v2_2.SrmLsRequest;
import org.dcache.srm.v2_2.SrmLsResponse;
import org.dcache.srm.v2_2.SrmStatusOfLsRequestResponse;
import org.dcache.srm.v2_2.TMetaDataPathDetail;
import org.dcache.srm.v2_2.TRequestType;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TSURLReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LsRequest
extends ContainerRequest {
    private static final Logger logger = LoggerFactory.getLogger(LsRequest.class);
    private final long offset;
    private final long count;
    private int maxNumOfResults = 100;
    private int numberOfResults;
    private long counter;
    private final int numOfLevels;
    private final boolean longFormat;
    private String explanation;

    public LsRequest(SRMUser user, Long requestCredentialId, SrmLsRequest request, long lifetime, long max_update_period, int max_number_of_retries, String client_host, long count, long offset, int numOfLevels, boolean longFormat, int maxNumOfResults) throws Exception {
        super(user, requestCredentialId, max_number_of_retries, max_update_period, lifetime, "Ls request", client_host);
        this.count = count;
        this.offset = offset;
        this.numOfLevels = numOfLevels;
        this.longFormat = longFormat;
        this.maxNumOfResults = maxNumOfResults;
        URI[] urls = request.getArrayOfSURLs().getUrlArray();
        ArrayList requests = Lists.newArrayListWithCapacity((int)urls.length);
        for (URI url : urls) {
            LsFileRequest fileRequest = new LsFileRequest(this.getId(), requestCredentialId, url, lifetime, max_number_of_retries);
            requests.add(fileRequest);
        }
        this.setFileRequests(requests);
        this.updateMemoryCache();
    }

    public LsRequest(Long id, Long nextJobId, long creationTime, long lifetime, int stateId, String errorMessage, SRMUser user, String scheduelerId, long schedulerTimeStamp, int numberOfRetries, int maxNumberOfRetries, long lastStateTransitionTime, Job.JobHistory[] jobHistoryArray, Long credentialId, FileRequest[] fileRequests, int retryDeltaTime, boolean should_updateretryDeltaTime, String description, String client_host, String statusCodeString, String explanation, boolean longFormat, int numOfLevels, long count, long offset) throws SQLException {
        super(id, nextJobId, creationTime, lifetime, stateId, errorMessage, user, scheduelerId, schedulerTimeStamp, numberOfRetries, maxNumberOfRetries, lastStateTransitionTime, jobHistoryArray, credentialId, fileRequests, retryDeltaTime, should_updateretryDeltaTime, description, client_host, statusCodeString);
        this.explanation = explanation;
        this.longFormat = longFormat;
        this.numOfLevels = numOfLevels;
        this.count = count;
        this.offset = offset;
    }

    @Override
    public FileRequest getFileRequestBySurl(java.net.URI surl) throws SQLException, SRMException {
        if (surl == null) {
            throw new SRMException("surl is null");
        }
        for (FileRequest request : this.getFileRequests()) {
            if (!((LsFileRequest)request).getSurl().equals(surl)) continue;
            return request;
        }
        throw new SRMException("ls file request for surl =" + surl + " is not found");
    }

    @Override
    public void schedule() throws InterruptedException, IllegalStateTransition {
        this.saveJob(true);
        for (FileRequest request : this.getFileRequests()) {
            request.schedule();
        }
    }

    @Override
    public String getMethod() {
        return "Ls";
    }

    public boolean shouldStopHandlerIfReady() {
        return true;
    }

    public String kill() {
        return "request was ready, set all ready file statuses to done";
    }

    @Override
    public void run() throws NonFatalJobFailure, FatalJobFailure {
    }

    @Override
    protected void stateChanged(State oldState) {
        State state = this.getState();
        if (State.isFinalState(state)) {
            for (FileRequest fr : this.getFileRequests()) {
                try {
                    State fr_state = fr.getState();
                    if (State.isFinalState(fr_state)) continue;
                    fr.setState(state, "changing file state because request state has changed");
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
            }
        }
    }

    public final SrmLsResponse getSrmLsResponse(long timeout) throws SRMException, SQLException, InterruptedException {
        Date deadline = this.getDateRelativeToNow(timeout);
        int counter = this._stateChangeCounter.get();
        SrmLsResponse response = this.getSrmLsResponse();
        while (response.getReturnStatus().getStatusCode().isProcessing() && this._stateChangeCounter.awaitChangeUntil(counter, deadline)) {
            counter = this._stateChangeCounter.get();
            response = this.getSrmLsResponse();
        }
        return response;
    }

    public final SrmLsResponse getSrmLsResponse() throws SRMException, SQLException {
        SrmLsResponse response = new SrmLsResponse();
        response.setReturnStatus(this.getTReturnStatus());
        if (!response.getReturnStatus().getStatusCode().isProcessing()) {
            ArrayOfTMetaDataPathDetail details = new ArrayOfTMetaDataPathDetail();
            details.setPathDetailArray(this.getPathDetailArray());
            response.setDetails(details);
        } else {
            response.setDetails(null);
            response.setRequestToken(this.getTRequestToken());
        }
        return response;
    }

    public final SrmStatusOfLsRequestResponse getSrmStatusOfLsRequestResponse() throws SRMException, SQLException {
        SrmStatusOfLsRequestResponse response = new SrmStatusOfLsRequestResponse();
        response.setReturnStatus(this.getTReturnStatus());
        ArrayOfTMetaDataPathDetail details = new ArrayOfTMetaDataPathDetail();
        details.setPathDetailArray(this.getPathDetailArray());
        response.setDetails(details);
        return response;
    }

    private String getTRequestToken() {
        return this.getId().toString();
    }

    public TMetaDataPathDetail[] getPathDetailArray() throws SRMException, SQLException {
        int len = this.getFileRequests().size();
        TMetaDataPathDetail[] detail = new TMetaDataPathDetail[len];
        for (int i = 0; i < len; ++i) {
            LsFileRequest fr = (LsFileRequest)this.getFileRequests().get(i);
            detail[i] = fr.getMetaDataPathDetail();
        }
        return detail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean increaseResultsNumAndContinue() throws SRMTooManyResultsException {
        this.wlock();
        try {
            this.setNumberOfResults(this.getNumberOfResults() + 1);
            if (this.getNumberOfResults() > this.getMaxNumOfResults()) {
                StringBuilder sb = new StringBuilder();
                sb.append("max results number of ").append(this.getMaxNumOfResults());
                sb.append(" exceeded. Try to narrow down with count and use offset to get complete listing");
                this.setExplanation(sb.toString());
                this.setStatusCode(TStatusCode.SRM_TOO_MANY_RESULTS);
                throw new SRMTooManyResultsException(sb.toString());
            }
            if ((long)this.getNumberOfResults() > this.getCount() && this.getCount() != 0L) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.wunlock();
        }
    }

    @Override
    public TRequestType getRequestType() {
        return TRequestType.LS;
    }

    public long getCount() {
        return this.count;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getNumOfLevels() {
        return this.numOfLevels;
    }

    public boolean getLongFormat() {
        return this.isLongFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxNumOfResults() {
        this.rlock();
        try {
            int n = this.maxNumOfResults;
            return n;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorMessage(String txt) {
        this.wlock();
        try {
            this.errorMessage.append(txt);
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getErrorMessage() {
        this.rlock();
        try {
            String string = this.errorMessage.toString();
            return string;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExplanation() {
        this.rlock();
        try {
            String string = this.explanation;
            return string;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExplanation(String txt) {
        this.wlock();
        try {
            this.explanation = txt;
        }
        finally {
            this.wunlock();
        }
    }

    @Override
    public final synchronized TReturnStatus getTReturnStatus() {
        this.getRequestStatus();
        TReturnStatus status = new TReturnStatus();
        if (this.getStatusCode() != null) {
            return new TReturnStatus(this.getStatusCode(), this.getExplanation());
        }
        int len = this.getNumOfFileRequest();
        if (len == 0) {
            status.setStatusCode(TStatusCode.SRM_INTERNAL_ERROR);
            status.setExplanation("Could not find (deserialize) files in the request, NumOfFileRequest is 0");
            logger.debug("assigned status.statusCode : " + status.getStatusCode());
            logger.debug("assigned status.explanation : " + status.getExplanation());
            return status;
        }
        int failed_req = 0;
        int canceled_req = 0;
        int pending_req = 0;
        int running_req = 0;
        int done_req = 0;
        int got_exception = 0;
        int auth_failure = 0;
        for (FileRequest fr : this.getFileRequests()) {
            TReturnStatus fileReqRS = fr.getReturnStatus();
            TStatusCode fileReqSC = fileReqRS.getStatusCode();
            try {
                if (fileReqSC == TStatusCode.SRM_REQUEST_QUEUED) {
                    ++pending_req;
                    continue;
                }
                if (fileReqSC == TStatusCode.SRM_REQUEST_INPROGRESS) {
                    ++running_req;
                    continue;
                }
                if (fileReqSC == TStatusCode.SRM_ABORTED) {
                    ++canceled_req;
                    continue;
                }
                if (fileReqSC == TStatusCode.SRM_AUTHORIZATION_FAILURE) {
                    ++auth_failure;
                    continue;
                }
                if (RequestStatusTool.isFailedFileRequestStatus(fileReqRS)) {
                    ++failed_req;
                    continue;
                }
                ++done_req;
            }
            catch (Exception e) {
                logger.error(e.toString());
                ++got_exception;
            }
        }
        if (done_req == len) {
            status.setStatusCode(TStatusCode.SRM_SUCCESS);
            status.setExplanation("All ls file requests completed");
            if (!State.isFinalState(this.getState())) {
                try {
                    this.setState(State.DONE, State.DONE.toString());
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
            }
            return status;
        }
        if (canceled_req == len) {
            status.setStatusCode(TStatusCode.SRM_ABORTED);
            status.setExplanation("All ls file requests were cancelled");
            return status;
        }
        if (pending_req == len || pending_req + running_req == len || running_req == len) {
            status.setStatusCode(TStatusCode.SRM_REQUEST_QUEUED);
            status.setExplanation("All ls file requests are pending");
            return status;
        }
        if (auth_failure == len) {
            status.setStatusCode(TStatusCode.SRM_AUTHORIZATION_FAILURE);
            status.setExplanation("Client is not authorized to request information");
            return status;
        }
        if (got_exception == len) {
            status.setStatusCode(TStatusCode.SRM_INTERNAL_ERROR);
            status.setExplanation("SRM has an internal transient error, and client may try again");
            return status;
        }
        if (running_req > 0 || pending_req > 0) {
            status.setStatusCode(TStatusCode.SRM_REQUEST_INPROGRESS);
            status.setExplanation("Some files are completed, and some files are still on the queue. Details are on the files status");
            return status;
        }
        if (done_req > 0) {
            status.setStatusCode(TStatusCode.SRM_PARTIAL_SUCCESS);
            status.setExplanation("Some SURL requests successfully completed, and some SURL requests failed. Details are on the files status");
            try {
                this.setState(State.DONE, State.DONE.toString());
            }
            catch (IllegalStateTransition ist) {
                logger.error("Illegal State Transition : " + ist.getMessage());
            }
            return status;
        }
        status.setStatusCode(TStatusCode.SRM_FAILURE);
        status.setExplanation("All ls requests failed in some way or another");
        try {
            this.setState(State.FAILED, State.FAILED.toString());
        }
        catch (IllegalStateTransition ist) {
            logger.error("Illegal State Transition : " + ist.getMessage());
        }
        return status;
    }

    @Override
    public TSURLReturnStatus[] getArrayOfTSURLReturnStatus(java.net.URI[] surls) throws SRMException, SQLException {
        return null;
    }

    @Override
    public void toString(StringBuilder sb, boolean longformat) {
        sb.append(this.getMethod()).append("Request #").append(this.getId()).append(" created by ").append(this.getUser());
        sb.append(" with credentials : ").append(this.getCredential()).append(" state = ").append((Object)this.getState());
        sb.append("\n SURL(s) : ");
        for (FileRequest fr : this.getFileRequests()) {
            LsFileRequest lsfr = (LsFileRequest)fr;
            sb.append(lsfr.getSurlString()).append(" ");
        }
        sb.append("\n count      : ").append(this.getCount());
        sb.append("\n offset     : ").append(this.getOffset());
        sb.append("\n longFormat : ").append(this.getLongFormat());
        sb.append("\n numOfLevels: ").append(this.getNumOfLevels());
        if (longformat) {
            sb.append("\n status code=").append(this.getStatusCode());
            sb.append("\n error message=").append(this.getErrorMessage());
            sb.append("\n History of State Transitions: \n");
            sb.append(this.getHistory());
            for (FileRequest fr : this.getFileRequests()) {
                fr.toString(sb, longformat);
            }
        } else {
            sb.append(" number of surls in request:").append(this.getFileRequests().size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumberOfResults() {
        this.rlock();
        try {
            int n = this.numberOfResults;
            return n;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNumberOfResults(int numberOfResults) {
        this.wlock();
        try {
            this.numberOfResults = numberOfResults;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCounter() {
        this.rlock();
        try {
            long l = this.counter;
            return l;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCounter(long c) {
        this.wlock();
        try {
            this.counter = c;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementGlobalEntryCounter() {
        this.wlock();
        try {
            this.setCounter(this.getCounter() + 1L);
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldSkipThisRecord() {
        this.rlock();
        try {
            boolean bl = this.getCounter() < this.getOffset();
            return bl;
        }
        finally {
            this.runlock();
        }
    }

    private boolean isLongFormat() {
        return this.longFormat;
    }
}

