/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import com.google.common.collect.ImmutableMap;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.dcache.srm.SRMAbortedException;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMReleasedException;
import org.dcache.srm.scheduler.FatalJobFailure;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.JobIdGenerator;
import org.dcache.srm.scheduler.JobIdGeneratorFactory;
import org.dcache.srm.scheduler.JobStorage;
import org.dcache.srm.scheduler.JobStorageFactory;
import org.dcache.srm.scheduler.NonFatalJobFailure;
import org.dcache.srm.scheduler.Scheduler;
import org.dcache.srm.scheduler.SchedulerFactory;
import org.dcache.srm.scheduler.SharedMemoryCache;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.util.JDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Job {
    private static final Logger logger = LoggerFactory.getLogger(Job.class);
    private static final Map<Long, WeakReference<Job>> weakJobStorage = new WeakHashMap<Long, WeakReference<Job>>();
    protected Long nextJobId;
    protected final Long id;
    private volatile State state = State.PENDING;
    protected StringBuilder errorMessage = new StringBuilder();
    protected int priority;
    protected String schedulerId;
    protected long schedulerTimeStamp;
    protected final long creationTime;
    protected long lifetime;
    protected int numberOfRetries;
    protected int maxNumberOfRetries;
    private long lastStateTransitionTime = System.currentTimeMillis();
    private static volatile ImmutableMap<Class<? extends Job>, JobStorage> jobStorages = ImmutableMap.of();
    private final List<JobHistory> jobHistory = new ArrayList<JobHistory>();
    private transient JobIdGenerator generator;
    private transient TimerTask retryTimer;
    private static final SharedMemoryCache sharedMemoryCache = new SharedMemoryCache();
    private static final SharedMemoryCache localMemoryCache = new SharedMemoryCache();
    private transient boolean savedInFinalState;
    protected transient JDC jdc;
    private final ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();

    public static final void registerJobStorages(ImmutableMap<Class<? extends Job>, JobStorage> jobStorages) {
        Job.jobStorages = jobStorages;
    }

    public static void shutdown() {
        LifetimeExpiration.shutdown();
    }

    protected Job(Long id, Long nextJobId, long creationTime, long lifetime, int stateId, String errorMessage, String schedulerId, long schedulerTimestamp, int numberOfRetries, int maxNumberOfRetries, long lastStateTransitionTime, JobHistory[] jobHistoryArray) {
        if (id == null) {
            throw new NullPointerException(" job id is null");
        }
        this.id = id;
        this.nextJobId = nextJobId;
        this.creationTime = creationTime;
        this.lifetime = lifetime;
        if (this.state == null) {
            throw new NullPointerException(" job state is null");
        }
        this.state = State.getState(stateId);
        this.errorMessage.append(errorMessage);
        this.schedulerId = schedulerId;
        this.schedulerTimeStamp = schedulerTimestamp;
        this.numberOfRetries = numberOfRetries;
        this.maxNumberOfRetries = maxNumberOfRetries;
        this.lastStateTransitionTime = lastStateTransitionTime;
        this.jdc = new JDC();
        if (jobHistoryArray != null) {
            Arrays.sort(jobHistoryArray, new Comparator<JobHistory>(){

                @Override
                public int compare(JobHistory jobHistory1, JobHistory jobHistory2) {
                    long transitionTime2;
                    long transitionTime1 = jobHistory1.getTransitionTime();
                    if (transitionTime1 < (transitionTime2 = jobHistory2.getTransitionTime())) {
                        return -1;
                    }
                    if (transitionTime1 == transitionTime2) {
                        return 0;
                    }
                    return 1;
                }
            });
            Collections.addAll(this.jobHistory, jobHistoryArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireRestoredJobOrCreateExperationTimer() {
        this.wlock();
        try {
            if (!this.state.isFinalState()) {
                long newLifetime = this.creationTime + this.lifetime - System.currentTimeMillis();
                LifetimeExpiration.schedule(this.id, Math.max(0L, newLifetime));
            }
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job(long lifetime, int maxNumberOfRetries) {
        this.id = this.nextId();
        this.creationTime = System.currentTimeMillis();
        this.lifetime = lifetime;
        this.maxNumberOfRetries = maxNumberOfRetries;
        this.jdc = new JDC();
        LifetimeExpiration.schedule(this.id, lifetime);
        Map<Long, WeakReference<Job>> map = weakJobStorage;
        synchronized (map) {
            weakJobStorage.put(this.id, new WeakReference<Job>(this));
        }
        this.jobHistory.add(new JobHistory(this.nextLong(), this.state, "created", this.lastStateTransitionTime));
    }

    protected final void updateMemoryCache() {
        sharedMemoryCache.updateSharedMemoryChache(this);
        localMemoryCache.updateSharedMemoryChache(this);
    }

    protected JobStorage getJobStorage() {
        return JobStorageFactory.getJobStorageFactory().getJobStorage(this);
    }

    public void saveJob() {
        this.saveJob(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveJob(boolean force) {
        this.wlock();
        try {
            if (this.savedInFinalState) {
                return;
            }
            boolean isFinalState = State.isFinalState(this.getState());
            this.getJobStorage().saveJob(this, isFinalState || force);
            this.savedInFinalState = isFinalState;
        }
        catch (SQLException e) {
            logger.error("Failed to save SQL request to database: {}", (Object)e.toString());
        }
        catch (RuntimeException e) {
            logger.error("Failed to save SQL request to database. Please report to support@dcache.org.", (Throwable)e);
        }
        finally {
            this.wunlock();
        }
    }

    public static final <T extends Job> T getJob(Long id, Class<T> type) throws SRMInvalidRequestException {
        return Job.getJob(id, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Job> T getJob(Long jobId, Class<T> type, Connection _con) throws SRMInvalidRequestException {
        Map<Long, WeakReference<Job>> map = weakJobStorage;
        synchronized (map) {
            Job o1;
            WeakReference<Job> ref = weakJobStorage.get(jobId);
            if (ref != null && (o1 = (Job)ref.get()) != null) {
                return Job.toType(type, o1);
            }
        }
        Job job = sharedMemoryCache.getJob(jobId);
        boolean restoredFromDb = false;
        if (job == null) {
            for (Map.Entry entry : jobStorages.entrySet()) {
                if (!type.isAssignableFrom((Class)entry.getKey())) continue;
                try {
                    job = _con == null ? ((JobStorage)entry.getValue()).getJob(jobId) : ((JobStorage)entry.getValue()).getJob(jobId, _con);
                }
                catch (SQLException e) {
                    logger.error("Failed to read job", (Throwable)e);
                }
                if (job == null) continue;
                restoredFromDb = true;
                break;
            }
        }
        Map<Long, WeakReference<Job>> map2 = weakJobStorage;
        synchronized (map2) {
            Job o1;
            WeakReference<Job> ref = weakJobStorage.get(jobId);
            if (ref != null && (o1 = (Job)ref.get()) != null) {
                return Job.toType(type, o1);
            }
            if (job != null) {
                weakJobStorage.put(job.id, new WeakReference<Job>(job));
                job.updateMemoryCache();
            }
        }
        if (job != null) {
            if (restoredFromDb) {
                job.expireRestoredJobOrCreateExperationTimer();
            }
            return Job.toType(type, job);
        }
        throw new SRMInvalidRequestException("jobId = " + jobId + " does not correspond to any known job");
    }

    private static <T extends Job> T toType(Class<T> type, Job job) throws SRMInvalidRequestException {
        if (!type.isAssignableFrom(job.getClass())) {
            throw new SRMInvalidRequestException("Job has wrong type, actual type is " + job.getClass().getSimpleName() + " and expected type is " + type.getSimpleName());
        }
        return (T)((Job)type.cast(job));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        this.rlock();
        try {
            State state = this.state;
            return state;
        }
        finally {
            this.runlock();
        }
    }

    public final void setState(State state, String description) throws IllegalStateTransition {
        this.setState(state, description, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setState(State state, String description, boolean save) throws IllegalStateTransition {
        this.wlock();
        try {
            if (state == this.state) {
                return;
            }
            if (this.state == State.PENDING && state != State.DONE && state != State.CANCELED && state != State.FAILED && state != State.RUNNING && state != State.TQUEUED && state != State.RESTORED) {
                throw new IllegalStateTransition("a illegal state transition from " + (Object)((Object)this.state) + " to " + (Object)((Object)state));
            }
            if (this.state == State.TQUEUED && state != State.CANCELED && state != State.FAILED && state != State.RUNNING && state != State.RESTORED) {
                throw new IllegalStateTransition("b illegal state transition from " + (Object)((Object)this.state) + " to " + (Object)((Object)state));
            }
            if (this.state == State.PRIORITYTQUEUED && state != State.CANCELED && state != State.FAILED && state != State.RUNNING && state != State.RESTORED) {
                throw new IllegalStateTransition("b illegal state transition from " + (Object)((Object)this.state) + " to " + (Object)((Object)state));
            }
            if (this.state == State.RUNNING && state != State.CANCELED && state != State.FAILED && state != State.RETRYWAIT && state != State.ASYNCWAIT && state != State.RQUEUED && state != State.READY && state != State.DONE && state != State.RUNNINGWITHOUTTHREAD && state != State.RESTORED) {
                throw new IllegalStateTransition("c illegal state transition from " + (Object)((Object)this.state) + " to " + (Object)((Object)state));
            }
            if (this.state == State.ASYNCWAIT && state != State.CANCELED && state != State.FAILED && state != State.RUNNING && state != State.PRIORITYTQUEUED && state != State.DONE && state != State.RETRYWAIT && state != State.RESTORED) {
                throw new IllegalStateTransition("z illegal state transition from " + (Object)((Object)this.state) + " to " + (Object)((Object)state));
            }
            if (this.state == State.RETRYWAIT && state != State.CANCELED && state != State.FAILED && state != State.RUNNING && state != State.PRIORITYTQUEUED && state != State.RESTORED) {
                throw new IllegalStateTransition("d illegal state transition from " + (Object)((Object)this.state) + " to " + (Object)((Object)state));
            }
            if (this.state == State.RQUEUED && state != State.CANCELED && state != State.FAILED && state != State.READY && state != State.RESTORED) {
                throw new IllegalStateTransition("l illegal state transition from " + (Object)((Object)this.state) + " to " + (Object)((Object)state));
            }
            if (this.state == State.READY && state != State.CANCELED && state != State.FAILED && state != State.TRANSFERRING && state != State.DONE && state != State.RESTORED) {
                throw new IllegalStateTransition("e illegal state transition from " + (Object)((Object)this.state) + " to " + (Object)((Object)state));
            }
            if (this.state == State.TRANSFERRING && state != State.CANCELED && state != State.FAILED && state != State.DONE && state != State.RESTORED) {
                throw new IllegalStateTransition("f illegal state transition from " + (Object)((Object)this.state) + " to " + (Object)((Object)state));
            }
            if (this.state == State.FAILED || this.state == State.DONE || this.state == State.CANCELED) {
                throw new IllegalStateTransition("g illegal state transition from " + (Object)((Object)this.state) + " to " + (Object)((Object)state));
            }
            State old = this.state;
            this.state = state;
            this.lastStateTransitionTime = System.currentTimeMillis();
            this.jobHistory.add(new JobHistory(this.nextLong(), state, description, this.lastStateTransitionTime));
            if (this.errorMessage.length() == 0) {
                this.errorMessage.append(description);
            } else {
                this.errorMessage.append("\nat ");
                this.errorMessage.append(new Date(this.lastStateTransitionTime));
                this.errorMessage.append(" appended:\n");
                this.errorMessage.append(description);
            }
            if (state == State.RETRYWAIT) {
                this.inclreaseNumberOfRetries();
            }
            this.notifySchedulerOfStateChange(old, state);
            if (state.isFinalState()) {
                LifetimeExpiration.cancel(this.id);
            } else if (this.schedulerId == null) {
                throw new IllegalStateTransition("Scheduler ID is null");
            }
            if (!old.isFinalState() && state.isFinalState()) {
                this.updateMemoryCache();
            }
            this.stateChanged(old);
            if (save) {
                this.saveJob();
            }
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryToReady() {
        Scheduler scheduler;
        this.rlock();
        try {
            if (this.state != State.RQUEUED) {
                return;
            }
        }
        finally {
            this.runlock();
        }
        if (this.schedulerId != null && (scheduler = Scheduler.getScheduler(this.schedulerId)) != null) {
            scheduler.tryToReadyJob(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getErrorMessage() {
        StringBuilder errorsb = new StringBuilder();
        this.rlock();
        try {
            if (!this.jobHistory.isEmpty()) {
                JobHistory nextHistoryElement = this.jobHistory.get(this.jobHistory.size() - 1);
                State nexthistoryElState = nextHistoryElement.getState();
                errorsb.append(" at ");
                errorsb.append(new Date(nextHistoryElement.getTransitionTime()));
                errorsb.append(" state ").append((Object)nexthistoryElState);
                errorsb.append(" : ");
                errorsb.append(nextHistoryElement.getDescription());
            }
        }
        finally {
            this.runlock();
        }
        return errorsb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistoryEvent(String description) {
        this.wlock();
        try {
            this.jobHistory.add(new JobHistory(this.nextLong(), this.state, description, System.currentTimeMillis()));
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHistory() {
        StringBuilder historyStringBuillder = new StringBuilder();
        this.rlock();
        try {
            for (JobHistory nextHistoryElement : this.jobHistory) {
                historyStringBuillder.append(" at ");
                historyStringBuillder.append(new Date(nextHistoryElement.getTransitionTime()));
                historyStringBuillder.append(" state ").append((Object)nextHistoryElement.getState());
                historyStringBuillder.append(" : ");
                historyStringBuillder.append(nextHistoryElement.getDescription());
                historyStringBuillder.append('\n');
            }
        }
        finally {
            this.runlock();
        }
        return historyStringBuillder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobHistory> getJobHistory() {
        this.rlock();
        try {
            ArrayList<JobHistory> arrayList = new ArrayList<JobHistory>(this.jobHistory);
            return arrayList;
        }
        finally {
            this.runlock();
        }
    }

    public abstract void run() throws NonFatalJobFailure, FatalJobFailure;

    protected abstract void stateChanged(State var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getNumberOfRetries() {
        this.wlock();
        try {
            int n = this.numberOfRetries;
            return n;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inclreaseNumberOfRetries() {
        this.wlock();
        try {
            ++this.numberOfRetries;
        }
        finally {
            this.wunlock();
        }
    }

    public TimerTask getRetryTimer() {
        return this.retryTimer;
    }

    public abstract String getSubmitterId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPriority() {
        this.rlock();
        try {
            int n = this.priority;
            return n;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(int priority) {
        this.wlock();
        try {
            if (priority < 0) {
                throw new IllegalArgumentException("priority should be greater than or equal to zero");
            }
            this.priority = priority;
        }
        finally {
            this.wunlock();
        }
    }

    public Long getId() {
        return new Long(this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNextJobId() {
        this.rlock();
        try {
            Long l = this.nextJobId;
            return l;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextJobId(Long nextJobId) {
        this.wlock();
        try {
            this.nextJobId = nextJobId;
            this.saveJob();
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSchedulerId() {
        this.rlock();
        try {
            String string = this.schedulerId;
            return string;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScheduler(String schedulerId, long schedulerTimeStamp) {
        this.wlock();
        try {
            if (this.schedulerTimeStamp != schedulerTimeStamp || this.schedulerId != null && schedulerId == null || schedulerId != null && !schedulerId.equals(this.schedulerId)) {
                this.schedulerTimeStamp = schedulerTimeStamp;
                this.schedulerId = schedulerId;
                try {
                    this.getJobStorage().saveJob(this, true);
                }
                catch (SQLException sqle) {
                    logger.error(sqle.toString());
                }
            }
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSchedulerTimeStamp() {
        this.rlock();
        try {
            long l = this.schedulerTimeStamp;
            return l;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long extendLifetimeMillis(long newLifetimeInMillis) throws SRMException {
        this.wlock();
        try {
            if (State.isFinalState(this.state)) {
                if (this.state == State.CANCELED) {
                    throw new SRMAbortedException("can't extend lifetime, job was aborted");
                }
                if (this.state == State.DONE) {
                    throw new SRMReleasedException("can't extend lifetime, job has finished");
                }
                throw new SRMException("can't extend lifetime, job state is " + (Object)((Object)this.state));
            }
            long remainingLifetime = this.getRemainingLifetime();
            if (remainingLifetime >= newLifetimeInMillis) {
                long l = remainingLifetime;
                return l;
            }
            if (!LifetimeExpiration.cancel(this.id)) {
                throw new SRMException(" job expiration has started already ");
            }
            LifetimeExpiration.schedule(this.id, newLifetimeInMillis);
            long l = 0L;
            return l;
        }
        finally {
            this.wunlock();
        }
    }

    private JobIdGenerator getGenerator() {
        if (this.generator == null) {
            this.generator = JobIdGeneratorFactory.getJobIdGeneratorFactory().getJobIdGenerator();
        }
        return this.generator;
    }

    private Long nextId() {
        return this.getGenerator().getNextId();
    }

    private long nextLong() {
        return this.getGenerator().nextLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void expireJob(Job job) {
        try {
            job.wlock();
            try {
                logger.debug("expiring job id=" + job.getId());
                if (job.state == State.READY || job.state == State.TRANSFERRING) {
                    job.setState(State.DONE, "lifetime expired");
                    return;
                }
                if (State.isFinalState(job.state)) {
                    return;
                }
                job.setState(State.FAILED, "lifetime expired");
            }
            finally {
                job.wunlock();
            }
        }
        catch (IllegalStateTransition illegalStateTransition) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxNumberOfRetries() {
        this.rlock();
        try {
            int n = this.maxNumberOfRetries;
            return n;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxNumberOfRetries(int maxNumberOfRetries) {
        this.wlock();
        try {
            this.maxNumberOfRetries = maxNumberOfRetries;
        }
        finally {
            this.wunlock();
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLifetime() {
        this.rlock();
        try {
            long l = this.lifetime;
            return l;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRemainingLifetime() {
        this.wlock();
        try {
            if (State.isFinalState(this.state)) {
                long l = 0L;
                return l;
            }
            long remianingLifetime = this.creationTime + this.lifetime - System.currentTimeMillis();
            long l = remianingLifetime > 0L ? remianingLifetime : 0L;
            return l;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleIfRestored() {
        this.wlock();
        try {
            Scheduler scheduler;
            if (this.getState() == State.RESTORED && this.schedulerId != null && (scheduler = Scheduler.getScheduler(this.schedulerId)) != null) {
                try {
                    scheduler.schedule(this);
                }
                catch (Exception ie) {
                    ie.printStackTrace();
                }
            }
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastStateTransitionTime() {
        this.rlock();
        try {
            long l = this.lastStateTransitionTime;
            return l;
        }
        finally {
            this.runlock();
        }
    }

    public void setRetryTimer(TimerTask retryTimer) {
        this.retryTimer = retryTimer;
    }

    public void applyJdc() {
        this.jdc.apply();
        JDC.push(String.valueOf(this.id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule() throws InterruptedException, IllegalStateTransition {
        this.wlock();
        try {
            if (!State.PENDING.equals((Object)this.state)) {
                throw new IllegalStateException("State is not pending");
            }
            Scheduler scheduler = SchedulerFactory.getSchedulerFactory().getScheduler(this);
            this.setScheduler(scheduler.getId(), 0L);
            scheduler.schedule(this);
        }
        finally {
            this.wunlock();
        }
    }

    public static <T extends Job> Set<T> getActiveJobs(Class<T> type) {
        return sharedMemoryCache.getJobs(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySchedulerOfStateChange(State oldState, State newState) {
        this.wlock();
        try {
            Scheduler scheduler;
            if (this.schedulerId != null && (scheduler = Scheduler.getScheduler(this.schedulerId)) != null) {
                logger.debug("notifySchedulerOfStateChange calls scheduler.stateChanged()");
                scheduler.stateChanged(this, oldState, newState);
                if (this.state.isFinalState()) {
                    this.schedulerId = null;
                }
            }
        }
        finally {
            this.wunlock();
        }
    }

    public final void wlock() {
        this.writeLock.lock();
    }

    public final void wunlock() {
        this.writeLock.unlock();
    }

    public final void rlock() {
        this.writeLock.lock();
    }

    public final void runlock() {
        this.writeLock.unlock();
    }

    public final String toString() {
        return this.toString(false);
    }

    public final String toString(boolean longformat) {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, longformat);
        return sb.toString();
    }

    public abstract void toString(StringBuilder var1, boolean var2);

    public static class JobHistory
    implements Comparable<JobHistory> {
        private final long id;
        private final State state;
        private final long transitionTime;
        private final String description;
        private boolean saved;

        public JobHistory(long id, State state, String description, long transitionTime) {
            this.id = id;
            this.state = state;
            this.description = description.replace('\'', '`');
            this.transitionTime = transitionTime;
        }

        public State getState() {
            return this.state;
        }

        public long getId() {
            return this.id;
        }

        public long getTransitionTime() {
            return this.transitionTime;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public int compareTo(JobHistory o) {
            long oTransitionTime = o.getTransitionTime();
            return this.transitionTime < oTransitionTime ? -1 : (this.transitionTime == oTransitionTime ? 0 : 1);
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof JobHistory)) {
                return false;
            }
            JobHistory jobHistory = (JobHistory)o;
            return jobHistory.id == this.id;
        }

        public int hashCode() {
            return (int)(this.id ^ this.id >>> 32);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("JobHistory[");
            sb.append(new Date(this.transitionTime)).append(',');
            sb.append((Object)this.state).append(',');
            sb.append(this.description).append(']');
            return sb.toString();
        }

        public synchronized boolean isSaved() {
            return this.saved;
        }

        public synchronized void setSaved() {
            this.saved = true;
        }
    }

    private static class LifetimeExpiration
    extends TimerTask {
        private static Map<Long, LifetimeExpiration> _instances = new HashMap<Long, LifetimeExpiration>();
        private static Timer _timer = new Timer();
        private Long _id;

        public static void shutdown() {
            _timer.cancel();
        }

        public static synchronized void schedule(Long id, long time) {
            if (!_instances.containsKey(id)) {
                LifetimeExpiration task = new LifetimeExpiration(id);
                _instances.put(id, task);
                _timer.schedule((TimerTask)task, time);
            }
        }

        public static synchronized boolean contains(Long id) {
            return _instances.containsKey(id);
        }

        public static synchronized boolean cancel(Long id) {
            LifetimeExpiration task = _instances.remove(id);
            if (task == null) {
                return false;
            }
            return task.cancel();
        }

        private static synchronized void remove(Long id) {
            _instances.remove(id);
        }

        private LifetimeExpiration(Long id) {
            this._id = id;
        }

        @Override
        public void run() {
            LifetimeExpiration.remove(this._id);
            try {
                Job.expireJob(Job.getJob(this._id, Job.class));
            }
            catch (IllegalArgumentException e) {
            }
            catch (Exception e) {
                logger.error("Unexpected exception during job timeout", (Throwable)e);
            }
        }
    }
}

