/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import com.google.common.collect.Lists;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.ContainerRequest;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.GetFileRequest;
import org.dcache.srm.request.Job;
import org.dcache.srm.scheduler.FatalJobFailure;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.NonFatalJobFailure;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.v2_2.ArrayOfTGetRequestFileStatus;
import org.dcache.srm.v2_2.SrmPrepareToGetResponse;
import org.dcache.srm.v2_2.SrmStatusOfGetRequestResponse;
import org.dcache.srm.v2_2.TGetRequestFileStatus;
import org.dcache.srm.v2_2.TRequestType;
import org.dcache.srm.v2_2.TSURLReturnStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GetRequest
extends ContainerRequest {
    private static final Logger logger = LoggerFactory.getLogger(GetRequest.class);
    protected String[] protocols;

    public GetRequest(SRMUser user, Long requestCredentialId, String[] surls, String[] protocols, long lifetime, long max_update_period, int max_number_of_retries, String description, String client_host) throws Exception {
        super(user, requestCredentialId, max_number_of_retries, max_update_period, lifetime, description, client_host);
        logger.debug("constructor");
        logger.debug("user = " + user);
        logger.debug("requestCredetialId=" + requestCredentialId);
        int len = protocols.length;
        this.protocols = new String[len];
        System.arraycopy(protocols, 0, this.protocols, 0, len);
        ArrayList requests = Lists.newArrayListWithCapacity((int)surls.length);
        for (String surl : surls) {
            GetFileRequest request = new GetFileRequest(this.getId(), requestCredentialId, surl, lifetime, max_number_of_retries);
            requests.add(request);
        }
        this.setFileRequests(requests);
        this.updateMemoryCache();
    }

    public GetRequest(Long id, Long nextJobId, long creationTime, long lifetime, int stateId, String errorMessage, SRMUser user, String scheduelerId, long schedulerTimeStamp, int numberOfRetries, int maxNumberOfRetries, long lastStateTransitionTime, Job.JobHistory[] jobHistoryArray, Long credentialId, FileRequest[] fileRequests, int retryDeltaTime, boolean should_updateretryDeltaTime, String description, String client_host, String statusCodeString, String[] protocols) throws SQLException {
        super(id, nextJobId, creationTime, lifetime, stateId, errorMessage, user, scheduelerId, schedulerTimeStamp, numberOfRetries, maxNumberOfRetries, lastStateTransitionTime, jobHistoryArray, credentialId, fileRequests, retryDeltaTime, should_updateretryDeltaTime, description, client_host, statusCodeString);
        this.protocols = protocols;
    }

    @Override
    public FileRequest getFileRequestBySurl(URI surl) throws SQLException, SRMException {
        if (surl == null) {
            throw new SRMException("surl is null");
        }
        for (FileRequest request : this.getFileRequests()) {
            if (!((GetFileRequest)request).getSurl().equals(surl)) continue;
            return request;
        }
        throw new SRMException("file request for surl =" + surl + " is not found");
    }

    @Override
    public void schedule() throws InterruptedException, IllegalStateTransition {
        this.saveJob(true);
        for (FileRequest request : this.getFileRequests()) {
            request.schedule();
        }
    }

    @Override
    public String getMethod() {
        return "Get";
    }

    public boolean shouldStopHandlerIfReady() {
        return false;
    }

    @Override
    public void run() throws NonFatalJobFailure, FatalJobFailure {
    }

    @Override
    protected void stateChanged(State oldState) {
        State state = this.getState();
        if (State.isFinalState(state)) {
            logger.debug("get request state changed to " + (Object)((Object)state));
            for (FileRequest request : this.getFileRequests()) {
                try {
                    State fr_state = request.getState();
                    if (State.isFinalState(fr_state)) continue;
                    logger.debug("changing fr#" + request.getId() + " to " + (Object)((Object)state));
                    request.setState(state, "changing file state because request state has changed");
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getProtocols() {
        String[] copy = new String[this.protocols.length];
        this.rlock();
        try {
            System.arraycopy(this.protocols, 0, copy, 0, this.protocols.length);
        }
        finally {
            this.runlock();
        }
        return copy;
    }

    public final SrmPrepareToGetResponse getSrmPrepareToGetResponse(long timeout) throws SRMException, SQLException, InterruptedException {
        Date deadline = this.getDateRelativeToNow(timeout);
        int counter = this._stateChangeCounter.get();
        SrmPrepareToGetResponse response = this.getSrmPrepareToGetResponse();
        while (response.getReturnStatus().getStatusCode().isProcessing() && this._stateChangeCounter.awaitChangeUntil(counter, deadline)) {
            counter = this._stateChangeCounter.get();
            response = this.getSrmPrepareToGetResponse();
        }
        return response;
    }

    public final SrmPrepareToGetResponse getSrmPrepareToGetResponse() throws SRMException, SQLException {
        SrmPrepareToGetResponse response = new SrmPrepareToGetResponse();
        response.setReturnStatus(this.getTReturnStatus());
        response.setRequestToken(this.getTRequestToken());
        ArrayOfTGetRequestFileStatus arrayOfTGetRequestFileStatus = new ArrayOfTGetRequestFileStatus();
        arrayOfTGetRequestFileStatus.setStatusArray(this.getArrayOfTGetRequestFileStatus(null));
        response.setArrayOfFileStatuses(arrayOfTGetRequestFileStatus);
        return response;
    }

    public final SrmStatusOfGetRequestResponse getSrmStatusOfGetRequestResponse() throws SRMException, SQLException {
        return this.getSrmStatusOfGetRequestResponse(null);
    }

    public final SrmStatusOfGetRequestResponse getSrmStatusOfGetRequestResponse(URI[] surls) throws SRMException, SQLException {
        SrmStatusOfGetRequestResponse response = new SrmStatusOfGetRequestResponse();
        response.setReturnStatus(this.getTReturnStatus());
        ArrayOfTGetRequestFileStatus arrayOfTGetRequestFileStatus = new ArrayOfTGetRequestFileStatus();
        arrayOfTGetRequestFileStatus.setStatusArray(this.getArrayOfTGetRequestFileStatus(surls));
        response.setArrayOfFileStatuses(arrayOfTGetRequestFileStatus);
        StringBuilder s = new StringBuilder("getSrmStatusOfGetRequestResponse:");
        s.append(" StatusCode = ").append(response.getReturnStatus().getStatusCode());
        for (TGetRequestFileStatus fs : arrayOfTGetRequestFileStatus.getStatusArray()) {
            s.append(" FileStatusCode = ").append(fs.getStatus().getStatusCode());
        }
        logger.debug(s.toString());
        return response;
    }

    private String getTRequestToken() {
        return this.getId().toString();
    }

    private TGetRequestFileStatus[] getArrayOfTGetRequestFileStatus(URI[] surls) throws SRMException, SQLException {
        int len = surls == null ? this.getNumOfFileRequest() : surls.length;
        TGetRequestFileStatus[] getFileStatuses = new TGetRequestFileStatus[len];
        if (surls == null) {
            for (int i = 0; i < len; ++i) {
                GetFileRequest fr = (GetFileRequest)this.getFileRequests().get(i);
                getFileStatuses[i] = fr.getTGetRequestFileStatus();
            }
        } else {
            for (int i = 0; i < len; ++i) {
                GetFileRequest fr = (GetFileRequest)this.getFileRequestBySurl(surls[i]);
                getFileStatuses[i] = fr.getTGetRequestFileStatus();
            }
        }
        return getFileStatuses;
    }

    @Override
    public TSURLReturnStatus[] getArrayOfTSURLReturnStatus(URI[] surls) throws SRMException, SQLException {
        TSURLReturnStatus[] surlLReturnStatuses;
        int len;
        if (surls == null) {
            len = this.getNumOfFileRequest();
            surlLReturnStatuses = new TSURLReturnStatus[len];
        } else {
            len = surls.length;
            surlLReturnStatuses = new TSURLReturnStatus[surls.length];
        }
        if (surls == null) {
            for (int i = 0; i < len; ++i) {
                GetFileRequest fr = (GetFileRequest)this.getFileRequests().get(i);
                surlLReturnStatuses[i] = fr.getTSURLReturnStatus();
            }
        } else {
            for (int i = 0; i < len; ++i) {
                GetFileRequest fr = (GetFileRequest)this.getFileRequestBySurl(surls[i]);
                surlLReturnStatuses[i] = fr.getTSURLReturnStatus();
            }
        }
        return surlLReturnStatuses;
    }

    @Override
    public TRequestType getRequestType() {
        return TRequestType.PREPARE_TO_GET;
    }
}

