/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import diskCacheV111.srm.RequestFileStatus;
import java.net.URI;
import java.sql.SQLException;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.qos.QOSTicket;
import org.dcache.srm.request.ContainerRequest;
import org.dcache.srm.request.Job;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.util.JDC;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileRequest
extends Job {
    private static final Logger logger = LoggerFactory.getLogger(FileRequest.class);
    protected final Long requestId;
    protected Long credentialId;
    private transient AbstractStorageElement storage;
    private transient Configuration configuration;
    private transient QOSTicket qosTicket;
    private TStatusCode statusCode;

    protected FileRequest(Long requestId, Long requestCredentalId, long lifetime, int maxNumberOfRetries) {
        super(lifetime, maxNumberOfRetries);
        this.credentialId = requestCredentalId;
        this.requestId = requestId;
        logger.debug("created");
    }

    protected FileRequest(Long id, Long nextJobId, long creationTime, long lifetime, int stateId, String errorMessage, String scheduelerId, long schedulerTimeStamp, int numberOfRetries, int maxNumberOfRetries, long lastStateTransitionTime, Job.JobHistory[] jobHistoryArray, Long requestId, Long requestCredentalId, String statusCodeString) {
        super(id, nextJobId, creationTime, lifetime, stateId, errorMessage, scheduelerId, schedulerTimeStamp, numberOfRetries, maxNumberOfRetries, lastStateTransitionTime, jobHistoryArray);
        this.credentialId = requestCredentalId;
        this.requestId = requestId;
        this.statusCode = statusCodeString == null ? null : TStatusCode.fromString(statusCodeString);
        logger.debug("restored");
    }

    public void addDebugHistoryEvent(String description) {
        if (this.getJobStorage().isJdbcLogRequestHistoryInDBEnabled()) {
            this.addHistoryEvent(description);
        }
    }

    public final Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = SRM.getSRM().getConfiguration();
        }
        return this.configuration;
    }

    public RequestCredential getCredential() {
        return RequestCredential.getRequestCredential(this.credentialId);
    }

    public Long getCredentialId() {
        return this.credentialId;
    }

    public abstract RequestFileStatus getRequestFileStatus();

    public abstract TReturnStatus getReturnStatus();

    public boolean equals(Object o) {
        return o == this;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(String status) throws SRMException, SQLException {
        block10: {
            logger.debug("(" + status + ")");
            try {
                this.wlock();
                try {
                    if (status.equalsIgnoreCase("Done")) {
                        State state = this.getState();
                        if (!state.isFinalState()) {
                            if (state == State.READY || state == State.TRANSFERRING || state == State.RUNNING) {
                                this.setState(State.DONE, "set by setStatus to \"Done\"");
                            } else {
                                this.setState(State.CANCELED, "set by setStatus to \"Done\"");
                            }
                        }
                        break block10;
                    }
                    if (status.equalsIgnoreCase("Running")) {
                        this.setState(State.TRANSFERRING, "set by setStatus to \"Running\"");
                        break block10;
                    }
                    String error = "Can't set Status to " + status;
                    logger.error(error);
                    throw new SRMException(error);
                }
                finally {
                    this.wunlock();
                }
            }
            catch (IllegalStateTransition ist) {
                String error = "Can't set Status to " + status + " due to Illegal State Transition : " + ist.getMessage();
                logger.error(error);
                throw new SRMException(error);
            }
        }
    }

    @Override
    protected void stateChanged(State oldState) {
        try {
            this.getRequest().fileRequestStateChanged(this);
        }
        catch (SRMInvalidRequestException ire) {
            logger.error(ire.toString());
        }
    }

    public SRMUser getUser() throws SRMInvalidRequestException {
        return this.getRequest().getUser();
    }

    public ContainerRequest getRequest() throws SRMInvalidRequestException {
        return Job.getJob(this.requestId, ContainerRequest.class);
    }

    public Long getRequestId() {
        return this.requestId;
    }

    public void setQOSTicket(QOSTicket qosTicket) {
        this.qosTicket = qosTicket;
    }

    public QOSTicket getQOSTicket() {
        return this.qosTicket;
    }

    public abstract boolean isTouchingSurl(URI var1);

    public abstract long extendLifetime(long var1) throws SRMException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TStatusCode getStatusCode() {
        this.rlock();
        try {
            TStatusCode tStatusCode = this.statusCode;
            return tStatusCode;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatusCodeString() {
        this.rlock();
        try {
            String string = this.statusCode == null ? null : this.statusCode.getValue();
            return string;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setStateAndStatusCode(State state, String description, TStatusCode statusCode) throws IllegalStateTransition {
        this.wlock();
        try {
            this.setState(state, description);
            this.setStatusCode(statusCode);
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatusCode(TStatusCode statusCode) {
        this.wlock();
        try {
            this.statusCode = statusCode;
        }
        finally {
            this.wunlock();
        }
    }

    @Override
    public String getSubmitterId() {
        try {
            return Long.toString(this.getUser().getId());
        }
        catch (Exception e) {
            logger.error(e.toString());
            return "unknown";
        }
    }

    @Override
    public void applyJdc() {
        this.jdc.apply();
        JDC.push(String.valueOf(this.requestId));
        JDC.push(String.valueOf(this.id));
    }

    public final AbstractStorageElement getStorage() {
        if (this.storage == null) {
            this.storage = SRM.getSRM().getStorage();
        }
        return this.storage;
    }

    protected boolean isProtocolSupported(String[] protocols) throws SRMException {
        for (String supported : this.getStorage().supportedGetProtocols()) {
            for (String protocol : protocols) {
                if (!supported.equals(protocol)) continue;
                return true;
            }
        }
        return false;
    }
}

