/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import diskCacheV111.srm.RequestFileStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.sql.SQLException;
import org.apache.axis.types.UnsignedLong;
import org.dcache.srm.CopyCallbacks;
import org.dcache.srm.FileMetaData;
import org.dcache.srm.PrepareToPutCallbacks;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.SrmCancelUseOfSpaceCallbacks;
import org.dcache.srm.SrmReleaseSpaceCallbacks;
import org.dcache.srm.SrmReserveSpaceCallbacks;
import org.dcache.srm.SrmUseSpaceCallbacks;
import org.dcache.srm.request.CopyRequest;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.Job;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.scheduler.FatalJobFailure;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.JobStorage;
import org.dcache.srm.scheduler.NonFatalJobFailure;
import org.dcache.srm.scheduler.Scheduler;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.util.ShellCommandExecuter;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TCopyRequestFileStatus;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TSURLReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.globus.util.GlobusURL;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CopyFileRequest
extends FileRequest {
    private static final Logger logger = LoggerFactory.getLogger(CopyFileRequest.class);
    private static final String SFN_STRING = "?SFN=";
    private URI from_surl;
    private URI to_surl;
    private URI from_turl;
    private URI to_turl;
    private String local_from_path;
    private String local_to_path;
    private long size;
    private String fromFileId;
    private String toFileId;
    private String toParentFileId;
    private transient FileMetaData toParentFmd;
    private String remoteRequestId;
    private String remoteFileId;
    private String transferId;
    private Exception transferError;
    private String spaceReservationId;
    private boolean weReservedSpace;
    private boolean spaceMarkedAsBeingUsed;
    private static long last_time;

    public CopyFileRequest(Long requestId, Long requestCredentalId, String from_surl, String to_surl, String spaceToken, long lifetime, int max_number_of_retries) throws Exception {
        super(requestId, requestCredentalId, lifetime, max_number_of_retries);
        logger.debug("CopyFileRequest");
        this.from_surl = URI.create(from_surl);
        this.to_surl = URI.create(to_surl);
        this.spaceReservationId = spaceToken;
        this.updateMemoryCache();
        logger.debug("constructor from_url=" + from_surl + " to_url=" + to_surl);
    }

    public CopyFileRequest(Long id, Long nextJobId, JobStorage jobStorage, long creationTime, long lifetime, int stateId, String errorMessage, String scheduelerId, long schedulerTimeStamp, int numberOfRetries, int maxNumberOfRetries, long lastStateTransitionTime, Job.JobHistory[] jobHistoryArray, Long requestId, Long requestCredentalId, String statusCodeString, String FROMURL, String TOURL, String FROMTURL, String TOTURL, String FROMLOCALPATH, String TOLOCALPATH, long size, String fromFileId, String toFileId, String REMOTEREQUESTID, String REMOTEFILEID, String spaceReservationId, String transferId) throws SQLException {
        super(id, nextJobId, creationTime, lifetime, stateId, errorMessage, scheduelerId, schedulerTimeStamp, numberOfRetries, maxNumberOfRetries, lastStateTransitionTime, jobHistoryArray, requestId, requestCredentalId, statusCodeString);
        this.from_surl = URI.create(FROMURL);
        this.to_surl = URI.create(TOURL);
        if (FROMTURL != null && !FROMTURL.equalsIgnoreCase("null")) {
            this.from_turl = URI.create(FROMTURL);
        }
        if (TOTURL != null && !TOTURL.equalsIgnoreCase("null")) {
            this.to_turl = URI.create(TOTURL);
        }
        this.local_from_path = FROMLOCALPATH;
        this.local_to_path = TOLOCALPATH;
        this.size = size;
        this.fromFileId = fromFileId;
        this.toFileId = toFileId;
        if (REMOTEREQUESTID != null && !REMOTEREQUESTID.equalsIgnoreCase("null")) {
            this.remoteRequestId = REMOTEREQUESTID;
        }
        if (REMOTEFILEID != null && !REMOTEFILEID.equalsIgnoreCase("null")) {
            this.remoteFileId = REMOTEFILEID;
        }
        this.spaceReservationId = spaceReservationId;
    }

    public void done() {
        logger.debug("done()");
    }

    public void error() {
        this.done();
    }

    @Override
    public RequestFileStatus getRequestFileStatus() {
        RequestFileStatus rfs = new RequestFileStatus();
        rfs.fileId = this.getId().intValue();
        rfs.SURL = this.getFrom_surl().toString();
        rfs.size = 0L;
        rfs.TURL = this.getTo_surl().toString();
        State state = this.getState();
        rfs.state = state == State.DONE ? "Done" : (state == State.READY ? "Ready" : (state == State.TRANSFERRING ? "Running" : (state == State.FAILED || state == State.CANCELED ? "Failed" : "Pending")));
        return rfs;
    }

    public String getToURL() {
        return this.getTo_surl().toString();
    }

    public String getFromURL() {
        return this.getFrom_surl().toString();
    }

    public String getFromPath() {
        String path = this.getFrom_surl().getPath();
        int indx = path.indexOf(SFN_STRING);
        if (indx != -1) {
            path = path.substring(indx + SFN_STRING.length());
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        logger.debug("getFromPath() returns " + path);
        return path;
    }

    public String getToPath() {
        String path = this.getTo_surl().getPath();
        int indx = path.indexOf(SFN_STRING);
        if (indx != -1) {
            path = path.substring(indx + SFN_STRING.length());
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        logger.debug("getToPath() returns " + path);
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getFrom_turl() {
        this.rlock();
        try {
            URI uRI = this.from_turl;
            return uRI;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrom_turl(URI from_turl) {
        this.wlock();
        try {
            this.from_turl = from_turl;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getTo_turl() {
        this.rlock();
        try {
            URI uRI = this.to_turl;
            return uRI;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTo_turl(URI to_turl) {
        this.wlock();
        try {
            this.to_turl = to_turl;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        this.rlock();
        try {
            long l = this.size;
            return l;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(long size) {
        this.rlock();
        try {
            this.size = size;
        }
        finally {
            this.runlock();
        }
    }

    @Override
    public void toString(StringBuilder sb, boolean longformat) {
        sb.append(" CopyFileRequest ");
        sb.append(" id:").append(this.getId());
        sb.append(" priority:").append(this.getPriority());
        sb.append(" creator priority:");
        try {
            sb.append(this.getUser().getPriority());
        }
        catch (SRMInvalidRequestException ire) {
            sb.append("Unknown");
        }
        sb.append(" state:").append((Object)this.getState());
        if (longformat) {
            sb.append(" fromSurl:").append(this.getFrom_surl());
            sb.append(" fromTurl:").append(this.getFrom_turl() == null ? "null" : this.getFrom_turl());
            sb.append(" toSurl:").append(this.getTo_surl());
            sb.append(" toTurl:").append(this.getTo_turl() == null ? "null" : this.getTo_turl());
            sb.append('\n').append("   status code:").append(this.getStatusCode());
            sb.append('\n').append("   error message:").append(this.getErrorMessage());
            sb.append('\n').append("   History of State Transitions: \n");
            sb.append(this.getHistory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocal_from_path() {
        this.rlock();
        try {
            String string = this.local_from_path;
            return string;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocal_from_path(String local_from_path) {
        this.wlock();
        try {
            this.local_from_path = local_from_path;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocal_to_path() {
        this.rlock();
        try {
            String string = this.local_to_path;
            return string;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocal_to_path(String local_to_path) {
        this.wlock();
        try {
            this.local_to_path = local_to_path;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToFileId() {
        this.rlock();
        try {
            String string = this.toFileId;
            return string;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setToFileId(String toFileId) {
        this.wlock();
        try {
            this.toFileId = toFileId;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFromFileId() {
        this.rlock();
        try {
            String string = this.fromFileId;
            return string;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFromFileId(String fromFileId) {
        this.wlock();
        try {
            this.fromFileId = fromFileId;
        }
        finally {
            this.wunlock();
        }
    }

    private void runScriptCopy() throws SRMException, IOException, GSSException {
        URI from = this.getFrom_turl();
        URI to = this.getTo_turl();
        if (from == null && this.getLocal_from_path() != null && (to.getScheme().equalsIgnoreCase("gsiftp") || to.getScheme().equalsIgnoreCase("http") || to.getScheme().equalsIgnoreCase("ftp") || to.getScheme().equalsIgnoreCase("dcap"))) {
            from = this.getStorage().getGetTurl(this.getUser(), this.getFrom_surl(), new String[]{"gsiftp", "http", "ftp"});
        }
        if (to == null && this.getLocal_to_path() != null && (from.getScheme().equalsIgnoreCase("gsiftp") || from.getScheme().equalsIgnoreCase("http") || from.getScheme().equalsIgnoreCase("ftp") || from.getScheme().equalsIgnoreCase("dcap"))) {
            to = this.getStorage().getPutTurl(this.getUser(), this.getTo_surl(), new String[]{"gsiftp", "http", "ftp"});
        }
        if (from == null || to == null) {
            String error = "could not resolve either source or destination from = " + from + " to = " + to;
            logger.error(error);
            throw new SRMException(error);
        }
        logger.debug("calling scriptCopy({},{})", (Object)from, (Object)to);
        RequestCredential credential = this.getCredential();
        this.scriptCopy(new GlobusURL(from.toString()), new GlobusURL(to.toString()), credential.getDelegatedCredential());
        this.setStateToDone();
    }

    private void runLocalToLocalCopy() throws IllegalStateTransition, SRMException {
        FileMetaData fmd;
        logger.debug("copying from local to local ");
        try {
            fmd = this.getStorage().getFileMetaData(this.getUser(), this.getFrom_surl(), true);
        }
        catch (SRMException srme) {
            try {
                this.setStateAndStatusCode(State.FAILED, srme.getMessage(), TStatusCode.SRM_INVALID_PATH);
            }
            catch (IllegalStateTransition ist) {
                logger.error("Illegal State Transition : " + ist.getMessage());
            }
            return;
        }
        this.size = fmd.size;
        RequestCredential credential = this.getCredential();
        if (this.getToFileId() == null && this.getToParentFileId() == null) {
            this.setState(State.ASYNCWAIT, "calling storage.prepareToPut");
            PutCallbacks callbacks = new PutCallbacks(this.getId());
            logger.debug("calling storage.prepareToPut(" + this.getLocal_to_path() + ")");
            this.getStorage().prepareToPut(this.getUser(), this.getTo_surl(), callbacks, ((CopyRequest)this.getRequest()).isOverwrite());
            logger.debug("callbacks.waitResult()");
            return;
        }
        logger.debug("known source size is " + this.size);
        TAccessLatency accessLatency = ((CopyRequest)this.getRequest()).getTargetAccessLatency();
        TRetentionPolicy retentionPolicy = ((CopyRequest)this.getRequest()).getTargetRetentionPolicy();
        if (this.getSpaceReservationId() == null && retentionPolicy == null && accessLatency == null && this.getToParentFmd().spaceTokens != null && this.getToParentFmd().spaceTokens.length > 0) {
            this.setSpaceReservationId(Long.toString(this.getToParentFmd().spaceTokens[0]));
        }
        if (this.getConfiguration().isReserve_space_implicitely() && this.getSpaceReservationId() == null) {
            this.setState(State.ASYNCWAIT, "reserving space");
            long remaining_lifetime = this.lifetime - (System.currentTimeMillis() - this.creationTime);
            logger.debug("reserving space, size=" + (this.size == 0L ? 1L : this.size));
            if (retentionPolicy == null && this.getToParentFmd() != null && this.getToParentFmd().retentionPolicyInfo != null) {
                retentionPolicy = this.getToParentFmd().retentionPolicyInfo.getRetentionPolicy();
            }
            if (accessLatency == null && this.getToParentFmd() != null && this.getToParentFmd().retentionPolicyInfo != null) {
                accessLatency = this.getToParentFmd().retentionPolicyInfo.getAccessLatency();
            }
            TheReserveSpaceCallbacks callbacks = new TheReserveSpaceCallbacks(this.getId());
            this.getStorage().srmReserveSpace(this.getUser(), this.size == 0L ? 1L : this.size, remaining_lifetime, retentionPolicy == null ? null : retentionPolicy.getValue(), accessLatency == null ? null : accessLatency.getValue(), null, callbacks);
            return;
        }
        if (this.getSpaceReservationId() != null && !this.isSpaceMarkedAsBeingUsed()) {
            this.setState(State.ASYNCWAIT, "marking space as being used");
            long remaining_lifetime = this.lifetime - (System.currentTimeMillis() - this.creationTime);
            CopyUseSpaceCallbacks callbacks = new CopyUseSpaceCallbacks(this.getId());
            this.getStorage().srmMarkSpaceAsBeingUsed(this.getUser(), this.getSpaceReservationId(), this.getTo_surl(), this.size == 0L ? 1L : this.size, remaining_lifetime, ((CopyRequest)this.getRequest()).isOverwrite(), callbacks);
            return;
        }
        this.getStorage().localCopy(this.getUser(), this.getFrom_surl(), this.getTo_surl());
        this.setStateToDone();
    }

    private void runRemoteToLocalCopy() throws IllegalStateTransition, SRMException, NonFatalJobFailure {
        logger.debug("copying from remote to local ");
        RequestCredential credential = this.getCredential();
        if (this.getToFileId() == null && this.getToParentFileId() == null) {
            this.setState(State.ASYNCWAIT, "calling storage.prepareToPut");
            PutCallbacks callbacks = new PutCallbacks(this.getId());
            logger.debug("calling storage.prepareToPut(" + this.getLocal_to_path() + ")");
            this.getStorage().prepareToPut(this.getUser(), this.getTo_surl(), callbacks, ((CopyRequest)this.getRequest()).isOverwrite());
            logger.debug("callbacks.waitResult()");
            return;
        }
        logger.debug("known source size is " + this.size);
        TAccessLatency accessLatency = ((CopyRequest)this.getRequest()).getTargetAccessLatency();
        TRetentionPolicy retentionPolicy = ((CopyRequest)this.getRequest()).getTargetRetentionPolicy();
        if (this.getSpaceReservationId() == null && retentionPolicy == null && accessLatency == null && this.getToParentFmd().spaceTokens != null && this.getToParentFmd().spaceTokens.length > 0) {
            this.setSpaceReservationId(Long.toString(this.getToParentFmd().spaceTokens[0]));
        }
        if (this.getConfiguration().isReserve_space_implicitely() && this.getSpaceReservationId() == null) {
            this.setState(State.ASYNCWAIT, "reserving space");
            long remaining_lifetime = this.lifetime - (System.currentTimeMillis() - this.creationTime);
            logger.debug("reserving space, size=" + (this.size == 0L ? 1L : this.size));
            if (retentionPolicy == null && this.getToParentFmd() != null && this.getToParentFmd().retentionPolicyInfo != null) {
                retentionPolicy = this.getToParentFmd().retentionPolicyInfo.getRetentionPolicy();
            }
            if (accessLatency == null && this.getToParentFmd() != null && this.getToParentFmd().retentionPolicyInfo != null) {
                accessLatency = this.getToParentFmd().retentionPolicyInfo.getAccessLatency();
            }
            TheReserveSpaceCallbacks callbacks = new TheReserveSpaceCallbacks(this.getId());
            this.getStorage().srmReserveSpace(this.getUser(), this.size == 0L ? 1L : this.size, remaining_lifetime, retentionPolicy == null ? null : retentionPolicy.getValue(), accessLatency == null ? null : accessLatency.getValue(), null, callbacks);
            return;
        }
        if (this.getSpaceReservationId() != null && !this.isSpaceMarkedAsBeingUsed()) {
            this.setState(State.ASYNCWAIT, "marking space as being used");
            long remaining_lifetime = this.lifetime - (System.currentTimeMillis() - this.creationTime);
            CopyUseSpaceCallbacks callbacks = new CopyUseSpaceCallbacks(this.getId());
            this.getStorage().srmMarkSpaceAsBeingUsed(this.getUser(), this.getSpaceReservationId(), this.getTo_surl(), this.size == 0L ? 1L : this.size, remaining_lifetime, ((CopyRequest)this.getRequest()).isOverwrite(), callbacks);
            return;
        }
        if (this.getTransferId() == null) {
            this.setState(State.RUNNINGWITHOUTTHREAD, "started remote transfer, waiting completion");
            TheCopyCallbacks copycallbacks = new TheCopyCallbacks(this.getId());
            if (this.getSpaceReservationId() != null) {
                this.setTransferId(this.getStorage().getFromRemoteTURL(this.getUser(), this.getFrom_turl(), this.getTo_surl(), this.getUser(), credential.getId(), this.getSpaceReservationId(), this.size, copycallbacks));
            } else {
                this.setTransferId(this.getStorage().getFromRemoteTURL(this.getUser(), this.getFrom_turl(), this.getTo_surl(), this.getUser(), credential.getId(), copycallbacks));
            }
        } else {
            this.getStorage().killRemoteTransfer(this.getTransferId());
            this.setTransferId(null);
            throw new NonFatalJobFailure(this.getTransferError());
        }
        long remaining_lifetime = this.getCreationTime() + this.getLifetime() - System.currentTimeMillis();
        this.saveJob();
    }

    private void setStateToDone() {
        try {
            this.setState(State.DONE, "setStateToDone called");
            try {
                ((CopyRequest)this.getRequest()).fileRequestCompleted();
            }
            catch (SRMInvalidRequestException ire) {
                logger.error(ire.toString());
            }
        }
        catch (IllegalStateTransition ist) {
            logger.error("setStateToDone: Illegal State Transition : " + ist.getMessage());
        }
    }

    private void setStateToFailed(String error) throws SRMInvalidRequestException {
        try {
            this.setState(State.FAILED, error);
        }
        catch (IllegalStateTransition ist) {
            logger.error("setStateToFailed: Illegal State Transition : " + ist.getMessage());
        }
        ((CopyRequest)this.getRequest()).fileRequestCompleted();
    }

    private void runLocalToRemoteCopy() throws SRMException, IllegalStateTransition, NonFatalJobFailure {
        if (this.getTransferId() != null) {
            this.getStorage().killRemoteTransfer(this.getTransferId());
            this.setTransferId(null);
            throw new NonFatalJobFailure(this.getTransferError());
        }
        logger.debug("copying using storage.putToRemoteTURL");
        RequestCredential credential = this.getCredential();
        TheCopyCallbacks copycallbacks = new TheCopyCallbacks(this.getId());
        this.setTransferId(this.getStorage().putToRemoteTURL(this.getUser(), this.getFrom_surl(), this.getTo_turl(), this.getUser(), credential.getId(), copycallbacks));
        this.setState(State.RUNNINGWITHOUTTHREAD, "started remote transfer, waiting completion");
        this.saveJob();
    }

    @Override
    public void run() throws NonFatalJobFailure, FatalJobFailure {
        logger.debug("copying ");
        try {
            if (this.getFrom_turl() != null && this.getFrom_turl().getScheme().equalsIgnoreCase("dcap") || this.getTo_turl() != null && this.getTo_turl().getScheme().equalsIgnoreCase("dcap") || this.getConfiguration().isUseUrlcopyScript()) {
                try {
                    this.runScriptCopy();
                    return;
                }
                catch (IOException | SRMException | GSSException e) {
                    logger.warn("script failed: {}", (Object)e.toString());
                }
            }
            if (this.getLocal_to_path() != null && this.getLocal_from_path() != null) {
                this.runLocalToLocalCopy();
                return;
            }
            if (this.getLocal_to_path() != null && this.getFrom_turl() != null) {
                this.runRemoteToLocalCopy();
                return;
            }
            if (this.getTo_turl() != null && this.getLocal_from_path() != null) {
                this.runLocalToRemoteCopy();
                return;
            }
            if (this.getFrom_turl() != null && this.getTo_turl() != null) {
                this.javaUrlCopy(this.getFrom_turl().toURL(), this.getTo_turl().toURL());
                logger.debug("copy succeeded");
                this.setStateToDone();
            } else {
                logger.error("Unknown combination of to/from ursl");
                this.setStateToFailed("Unknown combination of to/from ursl");
            }
        }
        catch (IOException | SRMException | IllegalStateTransition e) {
            throw new NonFatalJobFailure(e.toString());
        }
    }

    public static synchronized long unique_current_time() {
        long time = System.currentTimeMillis();
        last_time = last_time < time ? time : last_time + 1L;
        return last_time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scriptCopy(GlobusURL from, GlobusURL to, GSSCredential credential) throws IOException, GSSException {
        block22: {
            String proxy_file = null;
            try {
                int rc;
                String gsiftpclient;
                String to_pwd;
                String to_username;
                String from_pwd;
                int parallel_streams;
                int buffer_size;
                int tcp_buffer_size;
                String command = this.getConfiguration().getTimeout_script();
                command = command + " " + this.getConfiguration().getTimeout();
                command = command + " " + this.getConfiguration().getUrlcopy();
                command = command + " -debug " + this.getConfiguration().isDebug();
                if (credential != null) {
                    try {
                        byte[] data = ((ExtendedGSSCredential)credential).export(0);
                        proxy_file = this.getConfiguration().getProxies_directory() + "/proxy_" + credential.hashCode() + "_at_" + CopyFileRequest.unique_current_time();
                        logger.debug("saving credential " + credential.getName().toString() + " in proxy_file " + proxy_file);
                        FileOutputStream out = new FileOutputStream(proxy_file);
                        out.write(data);
                        out.close();
                        logger.debug("save succeeded ");
                    }
                    catch (IOException ioe) {
                        logger.error("saving credentials to " + proxy_file + " failed");
                        logger.error(ioe.toString());
                        proxy_file = null;
                    }
                }
                if (proxy_file != null) {
                    command = command + " -x509_user_proxy " + proxy_file;
                    command = command + " -x509_user_key " + proxy_file;
                    command = command + " -x509_user_cert " + proxy_file;
                }
                if ((tcp_buffer_size = this.getConfiguration().getTcp_buffer_size()) > 0) {
                    command = command + " -tcp_buffer_size " + tcp_buffer_size;
                }
                if ((buffer_size = this.getConfiguration().getBuffer_size()) > 0) {
                    command = command + " -buffer_size " + buffer_size;
                }
                if ((parallel_streams = this.getConfiguration().getParallel_streams()) > 0) {
                    command = command + " -parallel_streams " + parallel_streams;
                }
                command = command + " -src-protocol " + from.getProtocol();
                command = from.getProtocol().equals("file") ? command + " -src-host-port localhost" : command + " -src-host-port " + from.getHost() + ":" + from.getPort();
                command = command + " -src-path " + from.getPath() + " -dst-protocol " + to.getProtocol();
                command = to.getProtocol().equals("file") ? command + " -dst-host-port localhost" : command + " -dst-host-port " + to.getHost() + ":" + to.getPort();
                command = command + " -dst-path " + to.getPath();
                String from_username = from.getUser();
                if (from_username != null) {
                    command = command + " -src_username " + from_username;
                }
                if ((from_pwd = from.getPwd()) != null) {
                    command = command + " -src_userpasswd " + from_pwd;
                }
                if ((to_username = to.getUser()) != null) {
                    command = command + " -dst_username " + to_username;
                }
                if ((to_pwd = to.getPwd()) != null) {
                    command = command + " -dst_userpasswd " + to_pwd;
                }
                if ((gsiftpclient = this.getConfiguration().getGsiftpclinet()) != null) {
                    command = command + " -use-kftp " + gsiftpclient.toLowerCase().contains("kftp");
                }
                if ((rc = ShellCommandExecuter.execute(command)) != 0) {
                    logger.debug("return code = " + rc + ", failure");
                    throw new IOException("return code = " + rc + ", failure");
                }
                logger.debug("return code = 0, success");
                if (proxy_file == null) break block22;
            }
            catch (Throwable throwable) {
                if (proxy_file != null) {
                    try {
                        logger.debug(" deleting proxy file" + proxy_file);
                        File f = new File(proxy_file);
                        if (!f.delete()) {
                            logger.error("error deleting proxy cash " + proxy_file);
                        }
                    }
                    catch (Exception e) {
                        logger.error("error deleting proxy cash " + proxy_file);
                        logger.error(e.toString());
                    }
                }
                throw throwable;
            }
            try {
                logger.debug(" deleting proxy file" + proxy_file);
                File f = new File(proxy_file);
                if (!f.delete()) {
                    logger.error("error deleting proxy cash " + proxy_file);
                }
            }
            catch (Exception e) {
                logger.error("error deleting proxy cash " + proxy_file);
                logger.error(e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void javaUrlCopy(URL from, URL to) throws IOException {
        OutputStream out;
        InputStream in = from.getProtocol().equals("file") ? new FileInputStream(from.getPath()) : from.openConnection().getInputStream();
        if (to.getProtocol().equals("file")) {
            out = new FileOutputStream(to.getPath());
        } else {
            URLConnection to_connect = to.openConnection();
            to_connect.setDoInput(false);
            to_connect.setDoOutput(true);
            out = to_connect.getOutputStream();
        }
        try {
            int l;
            int buffer_size = 0;
            if (buffer_size <= 0) {
                buffer_size = 4096;
            }
            byte[] bytes = new byte[buffer_size];
            long total = 0L;
            while ((l = in.read(bytes)) != -1) {
                total += (long)l;
                out.write(bytes, 0, l);
            }
            logger.debug("done, copied " + total + " bytes");
        }
        finally {
            in.close();
            out.close();
        }
    }

    @Override
    protected void stateChanged(State oldState) {
        State state = this.getState();
        if (State.isFinalState(state)) {
            Object callbacks;
            SRMUser user;
            if (this.getTransferId() != null && state != State.DONE) {
                this.getStorage().killRemoteTransfer(this.getTransferId());
            }
            try {
                user = this.getUser();
            }
            catch (SRMInvalidRequestException ire) {
                logger.error(ire.toString());
                return;
            }
            if (this.getSpaceReservationId() != null && this.isWeReservedSpace()) {
                logger.debug("storage.releaseSpace(" + this.getSpaceReservationId() + "\"");
                callbacks = new TheReleaseSpaceCallbacks(this.getId());
                this.getStorage().srmReleaseSpace(user, this.getSpaceReservationId(), null, (SrmReleaseSpaceCallbacks)callbacks);
            }
            if (this.getSpaceReservationId() != null && this.isSpaceMarkedAsBeingUsed()) {
                callbacks = new CopyCancelUseOfSpaceCallbacks(this.getId());
                this.getStorage().srmUnmarkSpaceAsBeingUsed(user, this.getSpaceReservationId(), this.getTo_surl(), (SrmCancelUseOfSpaceCallbacks)callbacks);
            }
            if (this.getRemoteRequestId() != null) {
                if (this.getLocal_from_path() != null) {
                    this.remoteFileRequestDone(this.getTo_surl(), this.getRemoteRequestId(), this.getRemoteFileId());
                } else {
                    this.remoteFileRequestDone(this.getFrom_surl(), this.getRemoteRequestId(), this.getRemoteFileId());
                }
            }
        }
    }

    @Override
    public boolean isTouchingSurl(URI surl) {
        return surl.equals(this.getFrom_surl()) || surl.equals(this.getTo_surl());
    }

    public void remoteFileRequestDone(URI SURL2, String remoteRequestId, String remoteFileId) {
        try {
            logger.debug("setting remote file status to Done, SURL=" + SURL2 + " remoteRequestId=" + remoteRequestId + " remoteFileId=" + remoteFileId);
            ((CopyRequest)this.getRequest()).remoteFileRequestDone(SURL2.toString(), remoteRequestId, remoteFileId);
        }
        catch (Exception e) {
            logger.error("set remote file status to done failed, surl = " + SURL2 + " requestId = " + remoteRequestId + " fileId = " + remoteFileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRemoteFileId() {
        this.rlock();
        try {
            String string = this.remoteFileId;
            return string;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRemoteRequestId() {
        this.rlock();
        try {
            String string = this.remoteRequestId;
            return string;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getFrom_surl() {
        this.rlock();
        try {
            URI uRI = this.from_surl;
            return uRI;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getTo_surl() {
        this.rlock();
        try {
            URI uRI = this.to_surl;
            return uRI;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteRequestId(String remoteRequestId) {
        this.wlock();
        try {
            this.remoteRequestId = remoteRequestId;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteFileId(String remoteFileId) {
        this.wlock();
        try {
            this.remoteFileId = remoteFileId;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSpaceReservationId() {
        this.rlock();
        try {
            String string = this.spaceReservationId;
            return string;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpaceReservationId(String spaceReservationId) {
        this.wlock();
        try {
            this.spaceReservationId = spaceReservationId;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getToParentFileId() {
        this.rlock();
        try {
            String string = this.toParentFileId;
            return string;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setToParentFileId(String toParentFileId) {
        this.wlock();
        try {
            this.toParentFileId = toParentFileId;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileMetaData getToParentFmd() {
        this.rlock();
        try {
            FileMetaData fileMetaData = this.toParentFmd;
            return fileMetaData;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setToParentFmd(FileMetaData toParentFmd) {
        this.wlock();
        try {
            this.toParentFmd = toParentFmd;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTransferId(String transferId) {
        this.wlock();
        try {
            this.transferId = transferId;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception getTransferError() {
        this.rlock();
        try {
            Exception exception = this.transferError;
            return exception;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTransferError(Exception transferError) {
        this.wlock();
        try {
            this.transferError = transferError;
        }
        finally {
            this.wunlock();
        }
    }

    public TCopyRequestFileStatus getTCopyRequestFileStatus() throws SQLException {
        org.apache.axis.types.URI from_surl;
        org.apache.axis.types.URI to_surl;
        TCopyRequestFileStatus copyRequestFileStatus = new TCopyRequestFileStatus();
        copyRequestFileStatus.setFileSize(new UnsignedLong(this.size));
        copyRequestFileStatus.setEstimatedWaitTime((int)(this.getRemainingLifetime() / 1000L));
        copyRequestFileStatus.setRemainingFileLifetime((int)(this.getRemainingLifetime() / 1000L));
        try {
            to_surl = new org.apache.axis.types.URI(this.getTo_surl().toASCIIString());
        }
        catch (Exception e) {
            logger.error(e.toString());
            throw new SQLException("wrong surl format");
        }
        try {
            from_surl = new org.apache.axis.types.URI(this.getFrom_surl().toASCIIString());
        }
        catch (Exception e) {
            logger.error(e.toString());
            throw new SQLException("wrong surl format");
        }
        copyRequestFileStatus.setSourceSURL(from_surl);
        copyRequestFileStatus.setTargetSURL(to_surl);
        TReturnStatus returnStatus = this.getReturnStatus();
        if (TStatusCode.SRM_SPACE_LIFETIME_EXPIRED.equals(returnStatus.getStatusCode())) {
            returnStatus.setStatusCode(TStatusCode.SRM_FAILURE);
        }
        copyRequestFileStatus.setStatus(returnStatus);
        return copyRequestFileStatus;
    }

    @Override
    public TReturnStatus getReturnStatus() {
        TReturnStatus returnStatus = new TReturnStatus();
        State state = this.getState();
        returnStatus.setExplanation(state.toString());
        if (this.getStatusCode() != null) {
            returnStatus.setStatusCode(this.getStatusCode());
        } else if (state == State.DONE) {
            returnStatus.setStatusCode(TStatusCode.SRM_SUCCESS);
        } else if (state == State.READY) {
            returnStatus.setStatusCode(TStatusCode.SRM_REQUEST_INPROGRESS);
        } else if (state == State.TRANSFERRING) {
            returnStatus.setStatusCode(TStatusCode.SRM_REQUEST_INPROGRESS);
        } else if (state == State.FAILED) {
            returnStatus.setStatusCode(TStatusCode.SRM_FAILURE);
            returnStatus.setExplanation("FAILED: " + this.getErrorMessage());
        } else if (state == State.CANCELED) {
            returnStatus.setStatusCode(TStatusCode.SRM_ABORTED);
        } else if (state == State.TQUEUED) {
            returnStatus.setStatusCode(TStatusCode.SRM_REQUEST_QUEUED);
        } else if (state == State.RUNNING || state == State.RQUEUED || state == State.ASYNCWAIT) {
            returnStatus.setStatusCode(TStatusCode.SRM_REQUEST_INPROGRESS);
        } else {
            returnStatus.setStatusCode(TStatusCode.SRM_REQUEST_QUEUED);
        }
        return returnStatus;
    }

    public TSURLReturnStatus getTSURLReturnStatus(URI surl) throws SQLException {
        org.apache.axis.types.URI tsurl;
        if (surl == null) {
            surl = this.getTo_surl();
        }
        try {
            tsurl = new org.apache.axis.types.URI(surl.toASCIIString());
        }
        catch (Exception e) {
            logger.error(e.toString());
            throw new SQLException("wrong surl format");
        }
        TReturnStatus returnStatus = this.getReturnStatus();
        if (TStatusCode.SRM_SPACE_LIFETIME_EXPIRED.equals(returnStatus.getStatusCode())) {
            returnStatus.setStatusCode(TStatusCode.SRM_FAILURE);
        }
        TSURLReturnStatus surlReturnStatus = new TSURLReturnStatus();
        surlReturnStatus.setSurl(tsurl);
        surlReturnStatus.setStatus(returnStatus);
        return surlReturnStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWeReservedSpace() {
        this.rlock();
        try {
            boolean bl = this.weReservedSpace;
            return bl;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWeReservedSpace(boolean weReservedSpace) {
        this.wlock();
        try {
            this.weReservedSpace = weReservedSpace;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSpaceMarkedAsBeingUsed() {
        this.rlock();
        try {
            boolean bl = this.spaceMarkedAsBeingUsed;
            return bl;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpaceMarkedAsBeingUsed(boolean spaceMarkedAsBeingUsed) {
        this.wlock();
        try {
            this.spaceMarkedAsBeingUsed = spaceMarkedAsBeingUsed;
        }
        finally {
            this.wunlock();
        }
    }

    public String getTransferId() {
        return this.transferId;
    }

    @Override
    public long extendLifetime(long newLifetime) throws SRMException {
        long remainingLifetime = this.getRemainingLifetime();
        if (remainingLifetime >= newLifetime) {
            return remainingLifetime;
        }
        long requestLifetime = this.getRequest().extendLifetimeMillis(newLifetime);
        if (requestLifetime < newLifetime) {
            newLifetime = requestLifetime;
        }
        if (remainingLifetime >= newLifetime) {
            return remainingLifetime;
        }
        String spaceToken = this.getSpaceReservationId();
        if (!this.getConfiguration().isReserve_space_implicitely() || spaceToken == null || !this.isWeReservedSpace()) {
            return this.extendLifetimeMillis(newLifetime);
        }
        if (remainingLifetime >= (newLifetime = this.extendLifetimeMillis(newLifetime))) {
            return remainingLifetime;
        }
        SRMUser user = this.getUser();
        return this.getStorage().srmExtendReservationLifetime(user, spaceToken, newLifetime);
    }

    public static class CopyCancelUseOfSpaceCallbacks
    implements SrmCancelUseOfSpaceCallbacks {
        Long fileRequestJobId;

        public CopyFileRequest getCopyFileRequest() throws SQLException, SRMInvalidRequestException {
            return Job.getJob(this.fileRequestJobId, CopyFileRequest.class);
        }

        public CopyCancelUseOfSpaceCallbacks(Long fileRequestJobId) {
            this.fileRequestJobId = fileRequestJobId;
        }

        @Override
        public void CancelUseOfSpaceFailed(Exception e) {
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                String error = e.toString();
                logger.error("CopyCancelUseOfSpaceCallbacks exception", (Throwable)e);
            }
            catch (Exception e1) {
                logger.error(e1.toString());
            }
        }

        @Override
        public void CancelUseOfSpaceFailed(String reason) {
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                logger.error("CopyCancelUseOfSpaceCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void UseOfSpaceSpaceCanceled() {
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                logger.debug("Umarked Space as Being Used");
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }
    }

    public static class CopyUseSpaceCallbacks
    implements SrmUseSpaceCallbacks {
        Long fileRequestJobId;

        public CopyFileRequest getCopyFileRequest() throws SQLException, SRMInvalidRequestException {
            return Job.getJob(this.fileRequestJobId, CopyFileRequest.class);
        }

        public CopyUseSpaceCallbacks(Long fileRequestJobId) {
            this.fileRequestJobId = fileRequestJobId;
        }

        @Override
        public void SrmUseSpaceFailed(Exception e) {
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                String error = e.toString();
                try {
                    fr.setState(State.FAILED, error);
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("CopyUseSpaceCallbacks exception");
                logger.error(e.toString());
            }
            catch (Exception e1) {
                logger.error(e1.toString());
            }
        }

        @Override
        public void SrmUseSpaceFailed(String reason) {
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                try {
                    fr.setState(State.FAILED, reason);
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("CopyUseSpaceCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void SrmNoFreeSpace(String reason) {
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                try {
                    fr.setStateAndStatusCode(State.FAILED, reason, TStatusCode.SRM_NO_FREE_SPACE);
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("CopyUseSpaceCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void SrmReleased(String reason) {
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                try {
                    fr.setStateAndStatusCode(State.FAILED, reason, TStatusCode.SRM_NO_FREE_SPACE);
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("CopyUseSpaceCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void SrmNotAuthorized(String reason) {
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                try {
                    fr.setStateAndStatusCode(State.FAILED, reason, TStatusCode.SRM_AUTHORIZATION_FAILURE);
                }
                catch (IllegalStateTransition ist) {
                    logger.error("can not fail state:" + ist);
                }
                logger.error("CopyUseSpaceCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void SrmExpired(String reason) {
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                try {
                    fr.setStateAndStatusCode(State.FAILED, reason, TStatusCode.SRM_SPACE_LIFETIME_EXPIRED);
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("CopyUseSpaceCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void SpaceUsed() {
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                logger.debug("Space Marked as Being Used");
                State state = fr.getState();
                if (state == State.ASYNCWAIT) {
                    logger.debug("CopyUseSpaceCallbacks Space Marked as Being Used for file " + fr.getToURL());
                    fr.setSpaceMarkedAsBeingUsed(true);
                    Scheduler scheduler = Scheduler.getScheduler(fr.getSchedulerId());
                    try {
                        scheduler.schedule(fr);
                    }
                    catch (Exception ie) {
                        logger.error(ie.toString());
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }
    }

    private static class TheReleaseSpaceCallbacks
    implements SrmReleaseSpaceCallbacks {
        Long fileRequestJobId;

        public TheReleaseSpaceCallbacks(Long fileRequestJobId) {
            this.fileRequestJobId = fileRequestJobId;
        }

        public CopyFileRequest getCopyFileRequest() throws SQLException, SRMInvalidRequestException {
            return Job.getJob(this.fileRequestJobId, CopyFileRequest.class);
        }

        @Override
        public void ReleaseSpaceFailed(String error) {
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                fr.setSpaceReservationId(null);
                logger.error("TheReleaseSpaceCallbacks error: " + error);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void ReleaseSpaceFailed(Exception e) {
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                fr.setSpaceReservationId(null);
                logger.error("TheReleaseSpaceCallbacks exception");
                logger.error(e.toString());
            }
            catch (Exception e1) {
                logger.error(e1.toString());
            }
        }

        public void Timeout() {
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                fr.setSpaceReservationId(null);
                logger.error("TheReleaseSpaceCallbacks Timeout");
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void SpaceReleased(String spaceReservationToken, long remainingSpaceSize) {
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                logger.debug("TheReleaseSpaceCallbacks: SpaceReleased");
                fr.setSpaceReservationId(null);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }
    }

    public static class TheReserveSpaceCallbacks
    implements SrmReserveSpaceCallbacks {
        Long fileRequestJobId;

        public CopyFileRequest getCopyFileRequest() throws SQLException, SRMInvalidRequestException {
            return Job.getJob(this.fileRequestJobId, CopyFileRequest.class);
        }

        public TheReserveSpaceCallbacks(Long fileRequestJobId) {
            this.fileRequestJobId = fileRequestJobId;
        }

        @Override
        public void ReserveSpaceFailed(String reason) {
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                try {
                    fr.setState(State.FAILED, reason);
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("CopyReserveSpaceCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void NoFreeSpace(String reason) {
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                try {
                    fr.setStateAndStatusCode(State.FAILED, reason, TStatusCode.SRM_NO_FREE_SPACE);
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("CopyReserveSpaceCallbacks error NoFreeSpace : " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void SpaceReserved(String spaceReservationToken, long reservedSpaceSize) {
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                logger.debug("Space Reserved: spaceReservationToken:" + spaceReservationToken);
                State state = fr.getState();
                if (state == State.ASYNCWAIT) {
                    logger.debug("CopyReserveSpaceCallbacks Space Reserved for file " + fr.getTo_surl());
                    fr.setSpaceReservationId(spaceReservationToken);
                    fr.setWeReservedSpace(true);
                    Scheduler scheduler = Scheduler.getScheduler(fr.getSchedulerId());
                    try {
                        scheduler.schedule(fr);
                    }
                    catch (Exception ie) {
                        logger.error(ie.toString());
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void ReserveSpaceFailed(Exception e) {
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                String error = e.toString();
                try {
                    fr.setState(State.FAILED, error);
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("CopyReserveSpaceCallbacks exception");
                logger.error(e.toString());
            }
            catch (Exception e1) {
                logger.error(e1.toString());
            }
        }
    }

    private static class TheCopyCallbacks
    implements CopyCallbacks {
        private Long fileRequestJobId;
        private boolean completed;
        private boolean success;

        public TheCopyCallbacks(Long fileRequestJobId) {
            this.fileRequestJobId = fileRequestJobId;
        }

        public synchronized boolean waitResult(long timeout) {
            long start;
            long current = start = System.currentTimeMillis();
            while (!this.completed) {
                long wait = timeout - (current - start);
                if (wait > 0L) {
                    try {
                        this.wait(wait);
                    }
                    catch (InterruptedException ie) {}
                } else {
                    this.completed = true;
                    this.success = false;
                    return false;
                }
                current = System.currentTimeMillis();
            }
            return this.success;
        }

        public synchronized void complete(boolean success) {
            this.success = success;
            this.completed = true;
            this.notifyAll();
        }

        private CopyFileRequest getCopyFileRequest() throws SRMInvalidRequestException {
            return Job.getJob(this.fileRequestJobId, CopyFileRequest.class);
        }

        @Override
        public void copyComplete(FileMetaData fmd) {
            try {
                CopyFileRequest copyFileRequest = this.getCopyFileRequest();
                logger.debug("copy succeeded");
                copyFileRequest.setStateToDone();
                this.complete(true);
            }
            catch (SRMInvalidRequestException ire) {
                logger.error(ire.toString());
            }
        }

        @Override
        public void copyFailed(SRMException e) {
            CopyFileRequest copyFileRequest;
            try {
                copyFileRequest = this.getCopyFileRequest();
            }
            catch (SRMInvalidRequestException ire) {
                logger.error(ire.toString());
                return;
            }
            copyFileRequest.setTransferError(e);
            logger.error("copy failed:");
            logger.error(e.toString());
            State state = copyFileRequest.getState();
            Scheduler scheduler = Scheduler.getScheduler(copyFileRequest.getSchedulerId());
            if (!State.isFinalState(state) && scheduler != null) {
                try {
                    scheduler.schedule(copyFileRequest);
                }
                catch (InterruptedException | IllegalStateTransition ie) {
                    logger.error(ie.toString());
                }
            }
            this.complete(false);
        }
    }

    private static class PutCallbacks
    implements PrepareToPutCallbacks {
        Long fileRequestJobId;
        public boolean completed;
        public boolean success;
        public String fileId;
        public FileMetaData fmd;
        public String parentFileId;
        public FileMetaData parentFmd;
        public String error_message;

        public synchronized boolean waitResult(long timeout) {
            long start;
            long current = start = System.currentTimeMillis();
            while (!this.completed) {
                long wait = timeout - (current - start);
                if (wait > 0L) {
                    try {
                        this.wait(wait);
                    }
                    catch (InterruptedException ie) {}
                } else {
                    this.completed = true;
                    this.success = false;
                    this.error_message = "PutCallbacks wait timeout expired";
                    return false;
                }
                current = System.currentTimeMillis();
            }
            return this.success;
        }

        public synchronized void complete(boolean success) {
            this.success = success;
            this.completed = true;
            this.notifyAll();
        }

        public PutCallbacks(Long fileRequestJobId) {
            if (fileRequestJobId == null) {
                throw new NullPointerException("fileRequestJobId should be non-null");
            }
            this.fileRequestJobId = fileRequestJobId;
        }

        public CopyFileRequest getCopyFileRequest() throws SQLException, SRMInvalidRequestException {
            return Job.getJob(this.fileRequestJobId, CopyFileRequest.class);
        }

        @Override
        public void DuplicationError(String reason) {
            this.error_message = reason;
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                try {
                    fr.setStateAndStatusCode(State.FAILED, this.error_message, TStatusCode.SRM_DUPLICATION_ERROR);
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutCallbacks Timeout");
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
            this.complete(false);
        }

        @Override
        public void Error(String error) {
            this.error_message = error;
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                try {
                    fr.setState(State.FAILED, this.error_message);
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutCallbacks Timeout");
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
            this.complete(false);
        }

        @Override
        public void Exception(Exception e) {
            this.error_message = e.toString();
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                try {
                    fr.setState(State.FAILED, this.error_message);
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutCallbacks Timeout");
            }
            catch (Exception e1) {
                logger.error(e1.toString());
            }
            this.complete(false);
        }

        @Override
        public void GetStorageInfoFailed(String reason) {
            this.error_message = reason;
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                try {
                    fr.setState(State.FAILED, this.error_message);
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutCallbacks Timeout");
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
            this.complete(false);
        }

        @Override
        public void StorageInfoArrived(String fileId, FileMetaData fmd, String parentFileId, FileMetaData parentFmd) {
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                logger.debug("StorageInfoArrived: FileId:" + fileId);
                State state = fr.getState();
                if (state == State.ASYNCWAIT) {
                    logger.debug("PutCallbacks StorageInfoArrived for file " + fr.getTo_surl() + " fmd =" + fmd);
                    fr.setToFileId(fileId);
                    fr.setToParentFileId(parentFileId);
                    fr.setToParentFmd(parentFmd);
                    Scheduler scheduler = Scheduler.getScheduler(fr.getSchedulerId());
                    try {
                        scheduler.schedule(fr);
                    }
                    catch (Exception ie) {
                        logger.error(ie.toString());
                    }
                }
                this.complete(true);
            }
            catch (Exception e) {
                logger.error(e.toString());
                this.complete(false);
            }
        }

        @Override
        public void Timeout() {
            this.error_message = "PutCallbacks Timeout";
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                try {
                    fr.setState(State.FAILED, this.error_message);
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutCallbacks Timeout");
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
            this.complete(false);
        }

        @Override
        public void InvalidPathError(String reason) {
            this.error_message = reason;
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                try {
                    fr.setStateAndStatusCode(State.FAILED, this.error_message, TStatusCode.SRM_INVALID_PATH);
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutCallbacks Timeout");
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
            this.complete(false);
        }

        @Override
        public void AuthorizationError(String reason) {
            this.error_message = reason;
            try {
                CopyFileRequest fr = this.getCopyFileRequest();
                try {
                    fr.setStateAndStatusCode(State.FAILED, this.error_message, TStatusCode.SRM_AUTHORIZATION_FAILURE);
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutCallbacks Timeout");
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
            this.complete(false);
        }
    }
}

