/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.qos.terapaths;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.qos.QOSPlugin;
import org.dcache.srm.qos.QOSTicket;
import org.dcache.srm.qos.terapaths.TerapathsTicket;
import org.dcache.srm.util.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import terapathsexamplejavaclient.Bandwidth;
import terapathsexamplejavaclient.Bandwidths;
import terapathsexamplejavaclient.ReservationData;
import terapathsexamplejavaclient.ScheduleSlots;
import terapathsexamplejavaclient.TpsAPISEI;
import terapathsexamplejavaclient.TpsAPI_Impl;
import terapathsexamplejavaclient.Who;

public class TerapathsPlugin
implements QOSPlugin {
    private static final Logger logger = LoggerFactory.getLogger(TerapathsPlugin.class);
    AbstractStorageElement storage;
    private Collection<QOSTicket> tickets = new ArrayList<QOSTicket>();
    private static TpsAPISEI tpsAPISEIPort;
    Properties properties = new Properties();
    String propFile;
    Date lastRetrieval;
    String username;
    String password;
    String[] bandwidths;

    @Override
    public void setSrmConfiguration(Configuration configuration) {
        this.propFile = configuration.getQosConfigFile();
        this.storage = configuration.getStorage();
    }

    @Override
    public QOSTicket createTicket(String credential, Long bytes, String srcURL, int srcPortMin, int srcPortMax, String srcProtocol, String dstURL, int destPortMin, int dstPortMax, String dstProtocol) {
        return new TerapathsTicket(credential, bytes, srcURL, srcPortMin, srcPortMax, srcProtocol, dstURL, destPortMin, dstPortMax, dstProtocol);
    }

    @Override
    public void addTicket(QOSTicket qosTicket) {
        assert (qosTicket instanceof TerapathsTicket);
        this.tickets.add(qosTicket);
    }

    @Override
    public boolean submit() {
        boolean result = true;
        ScheduleSlots[] ss = null;
        long startTime = new Date().getTime();
        logger.debug("Submitting qos request...");
        if (this.lastRetrieval == null || this.lastRetrieval.before(this.lastModification())) {
            try {
                this.properties.load(new FileInputStream(this.propFile));
            }
            catch (FileNotFoundException ex) {
                logger.error(ex.toString());
                return false;
            }
            catch (IOException ex) {
                logger.error(ex.toString());
                return false;
            }
            try {
                TpsAPI_Impl tpsAPI = new TpsAPI_Impl();
                tpsAPISEIPort = tpsAPI.getTpsAPISEIPort();
                ((Stub)tpsAPISEIPort)._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.properties.getProperty("serviceUrl", "http://198.124.220.9:8080/terapathsAPI/tpsAPI?wsdl"));
            }
            catch (ServiceException ex) {
                logger.error(ex.toString());
                return false;
            }
            catch (Exception ex) {
                logger.error(ex.toString());
                return false;
            }
            try {
                System.setProperty("javax.net.ssl.keyStoreType", "JKS");
                if (this.properties.getProperty("keyStore") != null) {
                    System.setProperty("javax.net.ssl.keyStore", this.properties.getProperty("keyStore", "/usr/java/jdk1.5.0_14/jre/lib/security/keystore"));
                }
                System.setProperty("javax.net.ssl.keyStorePassword", this.properties.getProperty("keyStorePassword", "secret"));
                System.setProperty("javax.net.ssl.trustStoreType", "JKS");
                if (this.properties.getProperty("trustStore") != null) {
                    System.setProperty("javax.net.ssl.trustStore", this.properties.getProperty("trustStore", "/usr/java/jdk1.5.0_14/jre/lib/security/cacerts2"));
                }
                System.setProperty("javax.net.ssl.trustStorePassword", this.properties.getProperty("trustStorePassword", "secret"));
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
            this.username = this.properties.getProperty("username", "terapaths");
            this.password = this.properties.getProperty("password", "terapaths");
            String bandwidthStr = this.properties.getProperty("bandwidthClasses");
            if (bandwidthStr != null) {
                this.bandwidths = bandwidthStr.split(",");
            }
            if (this.bandwidths == null || this.bandwidths.length == 0) {
                this.bandwidths = new String[1];
                this.bandwidths[0] = "CS1_1";
            }
        }
        for (QOSTicket ticket : this.tickets) {
            TerapathsTicket tpTicket = (TerapathsTicket)ticket;
            if (!tpTicket.srcIP.toLowerCase().equals(tpTicket.srcIP.toUpperCase())) {
                try {
                    tpTicket.srcIP = InetAddress.getByName(tpTicket.srcIP).getHostAddress();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (!tpTicket.dstIP.toLowerCase().equals(tpTicket.dstIP.toUpperCase())) {
                try {
                    tpTicket.dstIP = InetAddress.getByName(tpTicket.dstIP).getHostAddress();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            try {
                Bandwidths[] bws = tpsAPISEIPort.tpsAPI_getBandwidths(this.username, this.password, tpTicket.srcIP, tpTicket.dstIP);
                if (bws != null) {
                    boolean successFlag = false;
                    for (Bandwidths bw1 : bws) {
                        int j;
                        if (bw1 == null) continue;
                        for (j = 0; j < bw1.getBw().length; ++j) {
                            int k;
                            Bandwidth bw = bw1.getBw()[j];
                            for (k = 0; k < this.bandwidths.length && !this.bandwidths[k].equals(bw.getClassName()); ++k) {
                            }
                            if (k == this.bandwidths.length) continue;
                            long endTime = startTime + (long)(Double.parseDouble(this.properties.getProperty("extraTimePerc", "1.1")) * ((double)tpTicket.bytes / (double)(bw.getBandwidth() * 8L)) * 1000.0);
                            try {
                                ss = tpsAPISEIPort.tpsAPI_getSchedule(this.username, this.password, "unidirectional", tpTicket.srcIP, tpTicket.dstIP, startTime, endTime, bw);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            if (ss != null && ss.length > 0) {
                                ReservationData rdRcv;
                                ReservationData rdSnd = new ReservationData();
                                rdSnd.setBandwidth(bw);
                                rdSnd.setDestIp(tpTicket.dstIP);
                                rdSnd.setDestPortMax(tpTicket.dstPortMax);
                                rdSnd.setDestPortMin(tpTicket.dstPortMin);
                                rdSnd.setDirection("unidirectional");
                                rdSnd.setDuration(Math.max((endTime - startTime) / 1000L, Long.parseLong(this.properties.getProperty("minReservationSec", "60"))));
                                rdSnd.setProtocol(tpTicket.srcProtocol);
                                rdSnd.setSrcIp(tpTicket.srcIP);
                                rdSnd.setSrcPortMax(tpTicket.srcPortMax);
                                rdSnd.setSrcPortMin(tpTicket.srcPortMin);
                                rdSnd.setStartTime(startTime);
                                rdSnd.setUserName(this.username);
                                rdSnd.setWho(new Who(this.password));
                                if (!rdSnd.getDestIp().toLowerCase().equals(rdSnd.getDestIp().toUpperCase())) {
                                    try {
                                        rdSnd.setDestIp(InetAddress.getByName(rdSnd.getDestIp()).getHostAddress());
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                }
                                if (!rdSnd.getSrcIp().toLowerCase().equals(rdSnd.getSrcIp().toUpperCase())) {
                                    try {
                                        rdSnd.setSrcIp(InetAddress.getByName(rdSnd.getSrcIp()).getHostAddress());
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                }
                                if ((rdRcv = tpsAPISEIPort.tpsAPI_reserve(rdSnd)) == null || rdRcv.getStartTime() == rdSnd.getStartTime() && rdRcv.getDuration() == rdSnd.getDuration()) continue;
                                tpTicket.id = rdRcv.getId();
                                tpTicket.startTime = startTime;
                                tpTicket.endTime = endTime;
                                tpTicket.bandwidth = rdRcv.getBandwidth().getBandwidth();
                                logger.debug("Submitted qos request " + tpTicket.id);
                                successFlag = true;
                                break;
                            }
                            if (successFlag) break;
                        }
                        if (j != bw1.getBw().length) continue;
                        result = false;
                    }
                    continue;
                }
                result = false;
            }
            catch (RemoteException ex) {
                logger.error(ex.toString());
                return false;
            }
            catch (Exception ex) {
                logger.error(ex.toString());
                return false;
            }
        }
        return result;
    }

    @Override
    public void sayStatus(QOSTicket qosTicket) {
        assert (qosTicket instanceof TerapathsTicket);
    }

    private Date lastModification() {
        try {
            File file = new File(this.propFile);
            return new Date(file.lastModified());
        }
        catch (Exception e) {
            return null;
        }
    }
}

