/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.qos.lambdastation;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class LambdaStationMap {
    private List<Site> Sites = new LinkedList<Site>();

    public LambdaStationMap() {
    }

    public LambdaStationMap(String map_file) {
        try {
            this.read(map_file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(String file) throws Exception {
        String domain = "";
        String name = "";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(file);
        Node root = document.getFirstChild();
        while (root != null && !"l-station-map".equals(root.getNodeName())) {
            root = document.getNextSibling();
        }
        if (root == null) {
            System.err.println(" error, root element \"l-station-map\" is not found");
            throw new IOException();
        }
        if (root != null && root.getNodeName().equals("l-station-map")) {
            for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1 || !node.getNodeName().equals("site")) continue;
                boolean enabled = true;
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child.getNodeType() == 1) {
                        Node g_c = child.getFirstChild();
                        if (g_c.getNodeType() == 3) {
                            String node_name;
                            Text t = (Text)g_c;
                            String text_value = t.getData().trim();
                            switch (node_name = child.getNodeName().trim()) {
                                case "domain": {
                                    domain = text_value;
                                    break;
                                }
                                case "enable-LS": {
                                    String inh = text_value;
                                    if (!inh.startsWith("n")) break;
                                    enabled = false;
                                    break;
                                }
                                case "name": {
                                    name = text_value;
                                }
                            }
                        }
                    } else if (child.getNodeType() == 3) {
                        Text t1 = (Text)child;
                        String tv = t1.getData().trim();
                        continue;
                    }
                    if (child.getNodeType() != 3) continue;
                    Text t = (Text)child;
                    String text_value = t.getData().trim();
                    break;
                }
                this.set(domain, name, enabled);
            }
        }
    }

    private void set(String name, String value, boolean enabled) {
        name = name.trim();
        value = value == null ? null : value.trim();
        Site site = new Site(name, value, enabled);
        this.Sites.add(site);
    }

    public void say(String words) {
        System.out.println("LS_MAP: " + words);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Lambda station Map:");
        Iterator<Site> i$ = this.Sites.iterator();
        while (i$.hasNext()) {
            Site Site2;
            Site s = Site2 = i$.next();
            sb.append("\n\tdomain=").append(s.domain);
            sb.append("\tname=").append(s.name);
            if (s.enabled) {
                sb.append("\tLS enabled=").append("yes");
                continue;
            }
            sb.append("\tLS enabled=").append("no");
        }
        return sb.toString();
    }

    public String getName(String url) {
        StringTokenizer urlTokenizer = new StringTokenizer(url, ":");
        String tok = (String)urlTokenizer.nextElement();
        tok = (String)urlTokenizer.nextElement();
        Iterator<Site> i$ = this.Sites.iterator();
        while (i$.hasNext()) {
            Site Site2;
            Site s = Site2 = i$.next();
            if (!tok.contains(s.domain)) continue;
            return s.name;
        }
        return null;
    }

    public boolean enabled(String url) {
        Iterator<Site> i$ = this.Sites.iterator();
        while (i$.hasNext()) {
            Site Site2;
            Site s = Site2 = i$.next();
            if (!url.contains(s.domain)) continue;
            return s.enabled;
        }
        return false;
    }

    private class Site {
        public String domain;
        public String name;
        public boolean enabled;

        public Site(String domain, String name, boolean enabled) {
            this.domain = domain;
            this.name = name;
            this.enabled = enabled;
        }
    }
}

