/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.GetRequest;
import org.dcache.srm.request.Job;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.request.sql.GetFileRequestStorage;
import org.dcache.srm.request.sql.GetRequestStorage;
import org.dcache.srm.scheduler.Scheduler;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.SrmStatusOfGetRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfGetRequestResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmStatusOfGetRequest {
    private static Logger logger = LoggerFactory.getLogger(SrmStatusOfGetRequest.class);
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SrmStatusOfGetRequestRequest statusOfGetRequestRequest;
    SrmStatusOfGetRequestResponse response;
    Scheduler getScheduler;
    SRMUser user;
    RequestCredential credential;
    GetRequestStorage getStorage;
    GetFileRequestStorage getFileRequestStorage;
    Configuration configuration;
    private int results_num;
    private int max_results_num;
    int numOfLevels;
    boolean longFormat;
    String servicePathAndSFNPart = "";
    int port;
    String host;

    public SrmStatusOfGetRequest(SRMUser user, RequestCredential credential, SrmStatusOfGetRequestRequest statusOfGetRequestRequest, AbstractStorageElement storage, SRM srm, String client_host) {
        this.statusOfGetRequestRequest = statusOfGetRequestRequest;
        this.user = user;
        this.credential = credential;
        this.storage = storage;
        this.getScheduler = srm.getGetRequestScheduler();
        this.configuration = srm.getConfiguration();
    }

    public SrmStatusOfGetRequestResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmGetStatus();
        }
        catch (URISyntaxException e) {
            logger.debug(" malformed uri : " + e.getMessage());
            this.response = SrmStatusOfGetRequest.getFailedResponse(" malformed uri : " + e.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SQLException sqle) {
            logger.error(sqle.toString());
            this.response = SrmStatusOfGetRequest.getFailedResponse("sql error " + sqle.getMessage(), TStatusCode.SRM_INTERNAL_ERROR);
        }
        catch (SRMInvalidRequestException e) {
            logger.error(e.toString());
            this.response = SrmStatusOfGetRequest.getFailedResponse(e.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = SrmStatusOfGetRequest.getFailedResponse(srme.toString());
        }
        return this.response;
    }

    public static final SrmStatusOfGetRequestResponse getFailedResponse(String error) {
        return SrmStatusOfGetRequest.getFailedResponse(error, null);
    }

    public static final SrmStatusOfGetRequestResponse getFailedResponse(String error, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(error);
        SrmStatusOfGetRequestResponse srmPrepareToGetResponse = new SrmStatusOfGetRequestResponse();
        srmPrepareToGetResponse.setReturnStatus(status);
        return srmPrepareToGetResponse;
    }

    private static URI[] toUris(org.apache.axis.types.URI[] uris) throws URISyntaxException {
        URI[] result = new URI[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            result[i] = new URI(uris[i].toString());
        }
        return result;
    }

    public SrmStatusOfGetRequestResponse srmGetStatus() throws SRMException, URISyntaxException, SQLException {
        Long requestId;
        String requestToken = this.statusOfGetRequestRequest.getRequestToken();
        if (requestToken == null) {
            return SrmStatusOfGetRequest.getFailedResponse("request contains no request token");
        }
        try {
            requestId = new Long(requestToken);
        }
        catch (NumberFormatException nfe) {
            return SrmStatusOfGetRequest.getFailedResponse(" requestToken \"" + requestToken + "\"is not valid", TStatusCode.SRM_FAILURE);
        }
        GetRequest getRequest = Job.getJob(requestId, GetRequest.class);
        if (this.statusOfGetRequestRequest.getArrayOfSourceSURLs() == null) {
            return getRequest.getSrmStatusOfGetRequestResponse();
        }
        URI[] surls = SrmStatusOfGetRequest.toUris(this.statusOfGetRequestRequest.getArrayOfSourceSURLs().getUrlArray());
        if (surls.length == 0) {
            return getRequest.getSrmStatusOfGetRequestResponse();
        }
        return getRequest.getSrmStatusOfGetRequestResponse(surls);
    }
}

