/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import java.sql.SQLException;
import org.apache.axis.types.URI;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.CopyRequest;
import org.dcache.srm.request.Job;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.request.sql.CopyFileRequestStorage;
import org.dcache.srm.request.sql.CopyRequestStorage;
import org.dcache.srm.scheduler.Scheduler;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.SrmStatusOfCopyRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfCopyRequestResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmStatusOfCopyRequest {
    private static Logger logger = LoggerFactory.getLogger(SrmStatusOfCopyRequest.class);
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SrmStatusOfCopyRequestRequest request;
    SrmStatusOfCopyRequestResponse response;
    Scheduler scheduler;
    SRMUser user;
    RequestCredential credential;
    CopyRequestStorage copyRequestStorage;
    CopyFileRequestStorage copyFileRequestStorage;
    Configuration configuration;
    private int results_num;
    private int max_results_num;
    int numOfLevels;
    boolean longFormat;
    String servicePathAndSFNPart = "";
    int port;
    String host;

    public SrmStatusOfCopyRequest(SRMUser user, RequestCredential credential, SrmStatusOfCopyRequestRequest request, AbstractStorageElement storage, SRM srm, String client_host) {
        this.request = request;
        this.user = user;
        this.credential = credential;
        this.storage = storage;
        this.scheduler = srm.getCopyRequestScheduler();
        this.configuration = srm.getConfiguration();
    }

    public SrmStatusOfCopyRequestResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmStatusOfCopyRequest();
        }
        catch (URI.MalformedURIException mue) {
            logger.debug(" malformed uri : " + mue.getMessage());
            this.response = SrmStatusOfCopyRequest.getFailedResponse(" malformed uri : " + mue.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SQLException sqle) {
            logger.error(sqle.toString());
            this.response = SrmStatusOfCopyRequest.getFailedResponse("sql error " + sqle.getMessage(), TStatusCode.SRM_INTERNAL_ERROR);
        }
        catch (SRMInvalidRequestException e) {
            logger.error(e.toString());
            this.response = SrmStatusOfCopyRequest.getFailedResponse(e.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = SrmStatusOfCopyRequest.getFailedResponse(srme.toString());
        }
        return this.response;
    }

    public static final SrmStatusOfCopyRequestResponse getFailedResponse(String text) {
        return SrmStatusOfCopyRequest.getFailedResponse(text, null);
    }

    public static final SrmStatusOfCopyRequestResponse getFailedResponse(String text, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        SrmStatusOfCopyRequestResponse response = new SrmStatusOfCopyRequestResponse();
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(text);
        response.setReturnStatus(status);
        return response;
    }

    public SrmStatusOfCopyRequestResponse srmStatusOfCopyRequest() throws SRMException, URI.MalformedURIException, SQLException {
        Long requestId;
        String requestToken = this.request.getRequestToken();
        if (requestToken == null) {
            return SrmStatusOfCopyRequest.getFailedResponse("request contains no request token", TStatusCode.SRM_INVALID_REQUEST);
        }
        try {
            requestId = new Long(requestToken);
        }
        catch (NumberFormatException nfe) {
            return SrmStatusOfCopyRequest.getFailedResponse(" requestToken \"" + requestToken + "\"is not valid", TStatusCode.SRM_INVALID_REQUEST);
        }
        CopyRequest copyRequest = Job.getJob(requestId, CopyRequest.class);
        if (this.request.getArrayOfSourceSURLs() == null || this.request.getArrayOfTargetSURLs() == null) {
            return copyRequest.getSrmStatusOfCopyRequest();
        }
        URI[] fromsurls = this.request.getArrayOfSourceSURLs().getUrlArray();
        URI[] tosurls = this.request.getArrayOfTargetSURLs().getUrlArray();
        if (fromsurls.length == 0 || tosurls.length != fromsurls.length) {
            return copyRequest.getSrmStatusOfCopyRequest();
        }
        String[] fromsurlStrings = new String[fromsurls.length];
        for (int i = 0; i < fromsurls.length; ++i) {
            fromsurlStrings[i] = fromsurls[i].toString();
        }
        String[] tosurlStrings = new String[tosurls.length];
        for (int i = 0; i < tosurls.length; ++i) {
            tosurlStrings[i] = tosurls[i].toString();
        }
        return copyRequest.getSrmStatusOfCopyRequest(fromsurlStrings, tosurlStrings);
    }
}

