/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import java.net.URISyntaxException;
import java.util.concurrent.CountDownLatch;
import org.apache.axis.types.URI;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.RemoveFileCallbacks;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.GetFileRequest;
import org.dcache.srm.request.PutFileRequest;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.ArrayOfTSURLReturnStatus;
import org.dcache.srm.v2_2.SrmRmRequest;
import org.dcache.srm.v2_2.SrmRmResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TSURLReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmRm {
    private static Logger logger = LoggerFactory.getLogger(SrmRm.class);
    AbstractStorageElement storage;
    SrmRmRequest request;
    SrmRmResponse response;
    SRMUser user;
    Configuration configuration;

    public SrmRm(SRMUser user, RequestCredential credential, SrmRmRequest request, AbstractStorageElement storage, SRM srm, String client_host) {
        this.request = request;
        this.user = user;
        this.storage = storage;
        this.configuration = srm.getConfiguration();
        if (this.configuration == null) {
            throw new NullPointerException("configuration is null");
        }
    }

    public SrmRmResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmRm();
        }
        catch (URISyntaxException e) {
            logger.debug(" malformed uri : " + e.getMessage());
            this.response = SrmRm.getResponse(" malformed uri : " + e.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = SrmRm.getFailedResponse(srme.toString());
        }
        return this.response;
    }

    public static final SrmRmResponse getFailedResponse(String error) {
        return SrmRm.getResponse(error, TStatusCode.SRM_FAILURE);
    }

    public static final SrmRmResponse getResponse(String error, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(error);
        SrmRmResponse response = new SrmRmResponse();
        response.setReturnStatus(status);
        return response;
    }

    public SrmRmResponse srmRm() throws SRMException, URISyntaxException {
        int end;
        if (this.request == null) {
            return SrmRm.getResponse(" null request passed to SrmRm()", TStatusCode.SRM_INVALID_REQUEST);
        }
        if (this.request.getArrayOfSURLs() == null) {
            return SrmRm.getResponse("null array of Surls", TStatusCode.SRM_INVALID_REQUEST);
        }
        URI[] surls = this.request.getArrayOfSURLs().getUrlArray();
        if (surls == null || surls.length == 0) {
            return SrmRm.getResponse("empty array of Surl Infos", TStatusCode.SRM_INVALID_REQUEST);
        }
        TSURLReturnStatus[] surlReturnStatusArray = new TSURLReturnStatus[surls.length];
        boolean any_failed = false;
        StringBuilder error = new StringBuilder();
        RemoveFile[] callbacks = new RemoveFile[surls.length];
        for (int i = 0; i < surls.length; ++i) {
            surlReturnStatusArray[i] = new TSURLReturnStatus();
            surlReturnStatusArray[i].setSurl(surls[i]);
            callbacks[i] = new RemoveFile();
        }
        int start = 0;
        int n = end = callbacks.length > this.configuration.getSizeOfSingleRemoveBatch() ? this.configuration.getSizeOfSingleRemoveBatch() : callbacks.length;
        while (end <= callbacks.length) {
            java.net.URI surl;
            int i;
            for (i = start; i < end; ++i) {
                try {
                    surl = new java.net.URI(surls[i].toString());
                    this.storage.removeFile(this.user, surl, callbacks[i]);
                    continue;
                }
                catch (RuntimeException re) {
                    logger.error(re.toString());
                    surlReturnStatusArray[i].setStatus(new TReturnStatus(TStatusCode.SRM_INTERNAL_ERROR, "RuntimeException " + re.getMessage()));
                    continue;
                }
                catch (Exception e) {
                    logger.error(e.toString());
                    surlReturnStatusArray[i].setStatus(new TReturnStatus(TStatusCode.SRM_INTERNAL_ERROR, "Exception " + e));
                }
            }
            try {
                for (i = start; i < end; ++i) {
                    callbacks[i].waitToComplete();
                    surl = new java.net.URI(surls[i].toString());
                    TReturnStatus status = callbacks[i].getStatus();
                    for (PutFileRequest putFileRequest : SRM.getSRM().getActiveFileRequests(PutFileRequest.class, surl)) {
                        try {
                            putFileRequest.setState(State.CANCELED, "Upload aborted because the file was deleted by another request");
                            status = new TReturnStatus(TStatusCode.SRM_SUCCESS, "Upload was aborted");
                        }
                        catch (IllegalStateTransition e) {
                            logger.debug("srmRm attempted to abort put request {}, but failed: {}", (Object)putFileRequest.getId(), (Object)e.getMessage());
                        }
                    }
                    for (GetFileRequest getFileRequest : SRM.getSRM().getActiveFileRequests(GetFileRequest.class, surl)) {
                        try {
                            getFileRequest.setState(State.CANCELED, "Download aborted because the file was deleted by another request");
                        }
                        catch (IllegalStateTransition e) {
                            logger.debug("srmRm attempted to abort get request {}, but failed: {}", (Object)getFileRequest.getId(), (Object)e.getMessage());
                        }
                    }
                    surlReturnStatusArray[i].setStatus(status);
                    if (status.getStatusCode() == TStatusCode.SRM_SUCCESS) continue;
                    any_failed = true;
                    error.append(surlReturnStatusArray[i].getStatus().getExplanation());
                    error.append('\n');
                }
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            if (end == callbacks.length) break;
            start = end;
            if (end + this.configuration.getSizeOfSingleRemoveBatch() < callbacks.length) {
                end += this.configuration.getSizeOfSingleRemoveBatch();
                continue;
            }
            end = callbacks.length;
        }
        SrmRmResponse srmRmResponse = any_failed ? SrmRm.getFailedResponse("problem with one or more files: \n" + error) : SrmRm.getResponse("successfully removed files", TStatusCode.SRM_SUCCESS);
        srmRmResponse.setArrayOfFileStatuses(new ArrayOfTSURLReturnStatus(surlReturnStatusArray));
        return srmRmResponse;
    }

    private class RemoveFile
    implements RemoveFileCallbacks {
        public TReturnStatus status;
        private CountDownLatch _done = new CountDownLatch(1);
        private boolean success = true;

        public TReturnStatus getStatus() {
            return this.status;
        }

        @Override
        public void RemoveFileFailed(String reason) {
            this.status = new TReturnStatus(TStatusCode.SRM_FAILURE, reason);
            logger.info("RemoveFileFailed:" + reason);
            this.done();
        }

        @Override
        public void FileNotFound(String reason) {
            this.status = new TReturnStatus(TStatusCode.SRM_INVALID_PATH, reason);
            logger.info("RemoveFileFailed:" + reason);
            this.done();
        }

        @Override
        public void RemoveFileSucceeded() {
            this.status = new TReturnStatus(TStatusCode.SRM_SUCCESS, null);
            this.done();
        }

        @Override
        public void Exception(Exception e) {
            this.status = new TReturnStatus(TStatusCode.SRM_FAILURE, "Exception: " + e.getMessage());
            logger.warn(e.toString());
            this.done();
        }

        @Override
        public void Timeout() {
            this.status = new TReturnStatus(TStatusCode.SRM_FAILURE, "Timeout: ");
            logger.warn("Timeout");
            this.done();
        }

        @Override
        public void PermissionDenied() {
            this.status = new TReturnStatus(TStatusCode.SRM_AUTHORIZATION_FAILURE, "Permission denied");
            this.done();
        }

        public void waitToComplete() throws InterruptedException {
            this._done.await();
        }

        public void done() {
            this._done.countDown();
        }
    }
}

