/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.scheduler.Scheduler;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.ArrayOfTSupportedTransferProtocol;
import org.dcache.srm.v2_2.SrmGetTransferProtocolsRequest;
import org.dcache.srm.v2_2.SrmGetTransferProtocolsResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.dcache.srm.v2_2.TSupportedTransferProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmGetTransferProtocols {
    private static Logger logger = LoggerFactory.getLogger(SrmGetTransferProtocols.class);
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SRMUser user;
    Scheduler scheduler;
    RequestCredential credential;
    Configuration configuration;
    SrmGetTransferProtocolsRequest request;
    SrmGetTransferProtocolsResponse response;
    SRM srm;

    public SrmGetTransferProtocols(SRMUser user, RequestCredential credential, SrmGetTransferProtocolsRequest request, AbstractStorageElement storage, SRM srm, String client_host) {
        if (request == null) {
            throw new NullPointerException("request is null");
        }
        this.request = request;
        this.user = user;
        this.credential = credential;
        if (storage == null) {
            throw new NullPointerException("storage is null");
        }
        this.storage = storage;
        this.srm = srm;
        this.scheduler = srm.getCopyRequestScheduler();
        if (this.scheduler == null) {
            throw new NullPointerException("scheduler is null");
        }
        this.configuration = srm.getConfiguration();
        if (this.configuration == null) {
            throw new NullPointerException("configuration is null");
        }
    }

    public SrmGetTransferProtocolsResponse getResponse() {
        String[] protocols;
        if (this.response != null) {
            return this.response;
        }
        this.response = new SrmGetTransferProtocolsResponse();
        try {
            protocols = this.srm.getProtocols(this.user, this.credential);
        }
        catch (Exception e) {
            logger.warn(e.toString());
            return SrmGetTransferProtocols.getFailedResponse("SrmGetTransferProtocols failed: " + e, TStatusCode.SRM_INTERNAL_ERROR);
        }
        TSupportedTransferProtocol[] arrayOfProtocols = new TSupportedTransferProtocol[protocols.length];
        for (int i = 0; i < protocols.length; ++i) {
            arrayOfProtocols[i] = new TSupportedTransferProtocol(protocols[i], null);
        }
        ArrayOfTSupportedTransferProtocol protocolArray = new ArrayOfTSupportedTransferProtocol();
        protocolArray.setProtocolArray(arrayOfProtocols);
        this.response.setProtocolInfo(protocolArray);
        this.response.setReturnStatus(new TReturnStatus(TStatusCode.SRM_SUCCESS, "success"));
        return this.response;
    }

    public static final SrmGetTransferProtocolsResponse getFailedResponse(String text) {
        return SrmGetTransferProtocols.getFailedResponse(text, null);
    }

    public static final SrmGetTransferProtocolsResponse getFailedResponse(String error, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        SrmGetTransferProtocolsResponse response = new SrmGetTransferProtocolsResponse();
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(error);
        response.setReturnStatus(status);
        return response;
    }
}

