/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import org.apache.axis.types.URI;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.ArrayOfTRequestTokenReturn;
import org.dcache.srm.v2_2.SrmGetRequestTokensRequest;
import org.dcache.srm.v2_2.SrmGetRequestTokensResponse;
import org.dcache.srm.v2_2.TRequestTokenReturn;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmGetRequestTokens {
    private static Logger logger = LoggerFactory.getLogger(SrmGetRequestTokens.class);
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SrmGetRequestTokensRequest request;
    SrmGetRequestTokensResponse response;
    SRMUser user;
    RequestCredential credential;
    Configuration configuration;

    public SrmGetRequestTokens(SRMUser user, RequestCredential credential, SrmGetRequestTokensRequest request, AbstractStorageElement storage, SRM srm, String client_host) {
        if (request == null) {
            throw new NullPointerException("request is null");
        }
        this.request = request;
        this.user = user;
        this.credential = credential;
        if (storage == null) {
            throw new NullPointerException("storage is null");
        }
        this.storage = storage;
        this.configuration = srm.getConfiguration();
        if (this.configuration == null) {
            throw new NullPointerException("configuration is null");
        }
    }

    public SrmGetRequestTokensResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmGetRequestTokens();
        }
        catch (URI.MalformedURIException mue) {
            logger.debug(" malformed uri : " + mue.getMessage());
            this.response = SrmGetRequestTokens.getFailedResponse(" malformed uri : " + mue.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = SrmGetRequestTokens.getFailedResponse(srme.toString());
        }
        return this.response;
    }

    public static final SrmGetRequestTokensResponse getFailedResponse(String text) {
        return SrmGetRequestTokens.getFailedResponse(text, null);
    }

    public static final SrmGetRequestTokensResponse getFailedResponse(String text, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        SrmGetRequestTokensResponse response = new SrmGetRequestTokensResponse();
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(text);
        response.setReturnStatus(status);
        return response;
    }

    public SrmGetRequestTokensResponse srmGetRequestTokens() throws SRMException, URI.MalformedURIException {
        if (this.request == null) {
            return SrmGetRequestTokens.getFailedResponse("srmGetRequestTokens: null request passed to SrmGetRequestTokens", TStatusCode.SRM_INVALID_REQUEST);
        }
        String description = this.request.getUserRequestDescription();
        String[] requestTokens = this.storage.srmGetRequestTokens(this.user, description);
        if (requestTokens.length > 0) {
            TRequestTokenReturn[] requestTokenReturns = new TRequestTokenReturn[requestTokens.length];
            for (int i = 0; i < requestTokens.length; ++i) {
                requestTokenReturns[i] = new TRequestTokenReturn(requestTokens[i], null);
            }
            SrmGetRequestTokensResponse response = new SrmGetRequestTokensResponse(new TReturnStatus(TStatusCode.SRM_SUCCESS, "OK"), new ArrayOfTRequestTokenReturn(requestTokenReturns));
            return response;
        }
        return SrmGetRequestTokens.getFailedResponse("userRequestDescription does not refer to any existing known requests", TStatusCode.SRM_INVALID_REQUEST);
    }
}

