/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import java.net.URISyntaxException;
import org.apache.axis.types.URI;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMAbortedException;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMReleasedException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.BringOnlineRequest;
import org.dcache.srm.request.ContainerRequest;
import org.dcache.srm.request.CopyRequest;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.Job;
import org.dcache.srm.request.PutRequest;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.ArrayOfTSURLLifetimeReturnStatus;
import org.dcache.srm.v2_2.SrmExtendFileLifeTimeRequest;
import org.dcache.srm.v2_2.SrmExtendFileLifeTimeResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TSURLLifetimeReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmExtendFileLifeTime {
    private static Logger logger = LoggerFactory.getLogger(SrmExtendFileLifeTime.class);
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SrmExtendFileLifeTimeRequest request;
    SrmExtendFileLifeTimeResponse response;
    SRMUser user;
    Configuration configuration;
    URI[] surls;
    Integer newFileLifetime;
    Integer newPinLifetime;
    String token;
    Long requestId;
    Job job;

    public SrmExtendFileLifeTime(SRMUser user, RequestCredential credential, SrmExtendFileLifeTimeRequest request, AbstractStorageElement storage, SRM srm, String client_host) {
        this.request = request;
        this.user = user;
        this.storage = storage;
        this.configuration = srm.getConfiguration();
    }

    public SrmExtendFileLifeTimeResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmExtendFileLifeTime();
        }
        catch (URISyntaxException e) {
            logger.debug(" malformed uri : " + e.getMessage());
            this.response = this.getFailedResponse(" malformed uri : " + e.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMInvalidRequestException e) {
            logger.debug(e.toString());
            this.response = this.getFailedResponse(e.toString(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = this.getFailedResponse(srme.toString());
        }
        return this.response;
    }

    public final SrmExtendFileLifeTimeResponse getFailedResponse(String error) {
        return this.getFailedResponse(error, null);
    }

    public final SrmExtendFileLifeTimeResponse getFailedResponse(String error, TStatusCode statusCode) {
        logger.debug("getFailedResponse(" + error + "," + statusCode + ")");
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(error);
        SrmExtendFileLifeTimeResponse response = new SrmExtendFileLifeTimeResponse();
        response.setReturnStatus(status);
        return response;
    }

    public SrmExtendFileLifeTimeResponse srmExtendSURLLifeTime() throws URISyntaxException {
        int failuresCount = 0;
        int len = this.surls.length;
        TSURLLifetimeReturnStatus[] surlStatus = new TSURLLifetimeReturnStatus[len];
        for (int i = 0; i < len; ++i) {
            surlStatus[i] = new TSURLLifetimeReturnStatus();
            surlStatus[i].setSurl(this.surls[i]);
            java.net.URI surl = new java.net.URI(this.surls[i].toString());
            try {
                int lifetimeLeft = this.storage.srmExtendSurlLifetime(this.user, surl, this.newFileLifetime);
                surlStatus[i].setFileLifetime(lifetimeLeft);
                surlStatus[i].setStatus(new TReturnStatus(TStatusCode.SRM_SUCCESS, "ok"));
                continue;
            }
            catch (SRMException e) {
                ++failuresCount;
                String error = "surl=" + this.surls[i] + "lifetime can't extended:" + e;
                if (logger.isDebugEnabled()) {
                    logger.debug(error, (Throwable)e);
                } else {
                    logger.warn(error);
                }
                surlStatus[i].setStatus(new TReturnStatus(TStatusCode.SRM_FAILURE, e.toString()));
            }
        }
        SrmExtendFileLifeTimeResponse response = new SrmExtendFileLifeTimeResponse();
        response.setArrayOfFileStatuses(new ArrayOfTSURLLifetimeReturnStatus(surlStatus));
        TReturnStatus returnStatus = new TReturnStatus();
        returnStatus.setStatusCode(failuresCount == 0 ? TStatusCode.SRM_SUCCESS : (failuresCount == len ? TStatusCode.SRM_FAILURE : TStatusCode.SRM_PARTIAL_SUCCESS));
        response.setReturnStatus(returnStatus);
        response.getReturnStatus().setExplanation("success");
        return response;
    }

    public SrmExtendFileLifeTimeResponse srmExtendTURLorPinLifeTime() throws SRMInvalidRequestException {
        try {
            this.requestId = new Long(this.token);
        }
        catch (NumberFormatException nfe) {
            return this.getFailedResponse(" requestToken \"" + this.token + "\"is not valid", TStatusCode.SRM_INVALID_REQUEST);
        }
        ContainerRequest containerRequest = Job.getJob(this.requestId, ContainerRequest.class);
        long configMaximumLifetime = containerRequest instanceof CopyRequest ? this.configuration.getCopyLifetime() : (containerRequest instanceof PutRequest ? this.configuration.getPutLifetime() : (containerRequest instanceof BringOnlineRequest ? this.configuration.getBringOnlineLifetime() : this.configuration.getGetLifetime()));
        long newLifetimeInMillis = this.newPinLifetime > 0 ? ((long)(this.newPinLifetime * 1000) > configMaximumLifetime ? configMaximumLifetime : (long)(this.newPinLifetime * 1000)) : configMaximumLifetime;
        int failuresCount = 0;
        int len = this.surls.length;
        TSURLLifetimeReturnStatus[] surlStatus = new TSURLLifetimeReturnStatus[len];
        for (int i = 0; i < len; ++i) {
            String error;
            FileRequest fileRequest;
            surlStatus[i] = new TSURLLifetimeReturnStatus();
            surlStatus[i].setSurl(this.surls[i]);
            try {
                fileRequest = containerRequest.getFileRequestBySurl(java.net.URI.create(this.surls[i].toString()));
            }
            catch (Exception e) {
                error = "request for requestToken \"" + this.token + "\" for surl=" + this.surls[i] + "can't be found:" + e;
                logger.warn(error, (Throwable)e);
                ++failuresCount;
                surlStatus[i].setStatus(new TReturnStatus(TStatusCode.SRM_INVALID_PATH, error));
                continue;
            }
            if (fileRequest == null) {
                String err = "fileRequest for surl=" + this.surls[i] + "is not found in request with id = " + this.token;
                logger.warn(err);
                ++failuresCount;
                surlStatus[i].setStatus(new TReturnStatus(TStatusCode.SRM_INVALID_PATH, err));
                continue;
            }
            try {
                long lifetimeLeftMillis = fileRequest.extendLifetime(newLifetimeInMillis);
                int lifetimeLeftSec = lifetimeLeftMillis >= 0L ? (int)(lifetimeLeftMillis / 1000L) : (int)lifetimeLeftMillis;
                surlStatus[i].setFileLifetime(lifetimeLeftSec);
                surlStatus[i].setStatus(new TReturnStatus(TStatusCode.SRM_SUCCESS, "ok"));
                continue;
            }
            catch (SRMReleasedException e) {
                error = "request for requestToken \"" + this.token + "\" for surl=" + this.surls[i] + "can't be extended:" + e;
                logger.warn(error);
                ++failuresCount;
                surlStatus[i].setStatus(new TReturnStatus(TStatusCode.SRM_RELEASED, error));
                continue;
            }
            catch (SRMInvalidRequestException e) {
                error = "request for requestToken \"" + this.token + "\" for surl=" + this.surls[i] + "can't be extended:" + e;
                logger.warn(error);
                ++failuresCount;
                surlStatus[i].setStatus(new TReturnStatus(TStatusCode.SRM_INVALID_REQUEST, error));
                continue;
            }
            catch (SRMAbortedException e) {
                ++failuresCount;
                error = "request for requestToken \"" + this.token + "\" for surl=" + this.surls[i] + "can't be extended:" + e;
                logger.warn(error);
                surlStatus[i].setStatus(new TReturnStatus(TStatusCode.SRM_ABORTED, error));
                continue;
            }
            catch (SRMException e) {
                ++failuresCount;
                error = "request for requestToken \"" + this.token + "\" for surl=" + this.surls[i] + "can't be extended:" + e;
                logger.warn(error, (Throwable)e);
                surlStatus[i].setStatus(new TReturnStatus(TStatusCode.SRM_FAILURE, error));
            }
        }
        SrmExtendFileLifeTimeResponse response = new SrmExtendFileLifeTimeResponse();
        response.setArrayOfFileStatuses(new ArrayOfTSURLLifetimeReturnStatus(surlStatus));
        TReturnStatus returnStatus = new TReturnStatus();
        returnStatus.setStatusCode(failuresCount == 0 ? TStatusCode.SRM_SUCCESS : (failuresCount == len ? TStatusCode.SRM_FAILURE : TStatusCode.SRM_PARTIAL_SUCCESS));
        response.setReturnStatus(returnStatus);
        return response;
    }

    public SrmExtendFileLifeTimeResponse srmExtendFileLifeTime() throws SRMException, URISyntaxException {
        if (this.request == null) {
            return this.getFailedResponse(" null request passed to SrmRm()", TStatusCode.SRM_INVALID_REQUEST);
        }
        this.surls = this.request.getArrayOfSURLs().getUrlArray();
        if (this.surls == null) {
            return this.getFailedResponse(" surls array is not defined", TStatusCode.SRM_INVALID_REQUEST);
        }
        this.newFileLifetime = this.request.getNewFileLifeTime();
        this.newPinLifetime = this.request.getNewPinLifeTime();
        this.token = this.request.getRequestToken();
        if (this.token == null) {
            if (this.newFileLifetime == null) {
                return this.getFailedResponse(" both requestToken and newFileLifetime parameters are null", TStatusCode.SRM_INVALID_REQUEST);
            }
            return this.srmExtendSURLLifeTime();
        }
        if (this.newPinLifetime == null) {
            return this.getFailedResponse(" requestToken is not null and newPinLifetime is null", TStatusCode.SRM_INVALID_REQUEST);
        }
        return this.srmExtendTURLorPinLifeTime();
    }
}

