/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import java.sql.SQLException;
import org.apache.axis.types.URI;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.ContainerRequest;
import org.dcache.srm.request.Job;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.SrmAbortRequestRequest;
import org.dcache.srm.v2_2.SrmAbortRequestResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmAbortRequest {
    private static Logger logger = LoggerFactory.getLogger(SrmAbortRequest.class);
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SrmAbortRequestRequest srmAbortRequestRequest;
    SrmAbortRequestResponse response;
    SRMUser user;
    RequestCredential credential;
    Configuration configuration;
    private int results_num;
    private int max_results_num;
    int numOfLevels;
    boolean longFormat;
    String servicePathAndSFNPart = "";
    int port;
    String host;

    public SrmAbortRequest(SRMUser user, RequestCredential credential, SrmAbortRequestRequest srmAbortRequestRequest, AbstractStorageElement storage, SRM srm, String client_host) {
        this.srmAbortRequestRequest = srmAbortRequestRequest;
        this.user = user;
        this.credential = credential;
        this.storage = storage;
        this.configuration = srm.getConfiguration();
    }

    public SrmAbortRequestResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmAbortRequest();
        }
        catch (URI.MalformedURIException mue) {
            logger.debug(" malformed uri : " + mue.getMessage());
            this.response = SrmAbortRequest.getFailedResponse(" malformed uri : " + mue.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMInvalidRequestException ire) {
            logger.debug(" invalid request : " + ire.getMessage());
            this.response = SrmAbortRequest.getFailedResponse(" invalid request : " + ire.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SQLException sqle) {
            logger.error(sqle.toString());
            this.response = SrmAbortRequest.getFailedResponse("sql error " + sqle.getMessage(), TStatusCode.SRM_INTERNAL_ERROR);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = SrmAbortRequest.getFailedResponse(srme.toString());
        }
        catch (IllegalStateTransition ist) {
            logger.error("Illegal State Transition : " + ist.getMessage());
            this.response = SrmAbortRequest.getFailedResponse("Illegal State Transition : " + ist.getMessage());
        }
        return this.response;
    }

    public static final SrmAbortRequestResponse getFailedResponse(String error) {
        return SrmAbortRequest.getFailedResponse(error, null);
    }

    public static final SrmAbortRequestResponse getFailedResponse(String error, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(error);
        SrmAbortRequestResponse srmReleaseFilesResponse = new SrmAbortRequestResponse();
        srmReleaseFilesResponse.setReturnStatus(status);
        return srmReleaseFilesResponse;
    }

    public SrmAbortRequestResponse srmAbortRequest() throws SRMException, URI.MalformedURIException, SQLException, IllegalStateTransition {
        State state;
        Long requestId;
        String requestToken = this.srmAbortRequestRequest.getRequestToken();
        if (requestToken == null) {
            return SrmAbortRequest.getFailedResponse("request contains no request token");
        }
        try {
            requestId = new Long(requestToken);
        }
        catch (NumberFormatException nfe) {
            return SrmAbortRequest.getFailedResponse(" requestToken \"" + requestToken + "\"is not valid", TStatusCode.SRM_INVALID_REQUEST);
        }
        Job job = Job.getJob(requestId, Job.class);
        if (job instanceof ContainerRequest) {
            ((ContainerRequest)job).getTReturnStatus();
        }
        if (!State.isFinalState(state = job.getState())) {
            job.setState(State.CANCELED, "SrmAbortRequest called");
        }
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(TStatusCode.SRM_SUCCESS);
        SrmAbortRequestResponse srmAbortRequestResponse = new SrmAbortRequestResponse();
        srmAbortRequestResponse.setReturnStatus(status);
        return srmAbortRequestResponse;
    }
}

