/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.client.axis;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;
import org.dcache.srm.client.axis.ISRMStub;
import org.dcache.srm.client.axis.ISRM_PortType;
import org.dcache.srm.client.axis.SRMServerV1;

public class SRMServerV1Locator
extends Service
implements SRMServerV1 {
    private static final long serialVersionUID = -2612073659479050609L;
    private String ISRM_address = "https://fndca.fnal.gov:24129/srm/managerv1";
    private String ISRMWSDDServiceName = "ISRM";
    private Collection ports;

    public SRMServerV1Locator() {
    }

    public SRMServerV1Locator(EngineConfiguration config) {
        super(config);
    }

    public SRMServerV1Locator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    @Override
    public String getISRMAddress() {
        return this.ISRM_address;
    }

    public String getISRMWSDDServiceName() {
        return this.ISRMWSDDServiceName;
    }

    public void setISRMWSDDServiceName(String name) {
        this.ISRMWSDDServiceName = name;
    }

    @Override
    public ISRM_PortType getISRM() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.ISRM_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getISRM(endpoint);
    }

    @Override
    public ISRM_PortType getISRM(URL portAddress) throws ServiceException {
        try {
            ISRMStub _stub = new ISRMStub(portAddress, this);
            _stub.setPortName(this.getISRMWSDDServiceName());
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public void setISRMEndpointAddress(String address) {
        this.ISRM_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (ISRM_PortType.class.isAssignableFrom(serviceEndpointInterface)) {
                ISRMStub _stub = new ISRMStub(new URL(this.ISRM_address), this);
                _stub.setPortName(this.getISRMWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("ISRM".equals(inputPortName)) {
            return this.getISRM();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("http://srm.1.0.ns", "SRMServerV1");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("http://srm.1.0.ns", "ISRM"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"ISRM".equals(portName)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
        this.setISRMEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

