/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.client;

import org.dcache.srm.client.Transport;

public final class TransportUtil {
    private TransportUtil() {
    }

    public static String uriSchemaFor(Transport transport) {
        if (transport == Transport.TCP) {
            return "http";
        }
        return "httpg";
    }

    public static boolean hasGsiMode(Transport transport) {
        return transport == Transport.SSL || transport == Transport.GSI;
    }

    public static String gsiModeFor(Transport transport, boolean do_delegation, boolean full_delegation) {
        switch (transport) {
            case GSI: {
                if (do_delegation) {
                    return full_delegation ? "gsifull" : "gsilimited";
                }
                return "gsi";
            }
            case SSL: {
                return "ssl";
            }
            case TCP: {
                throw new RuntimeException("No GSI mode needed for TCP transport");
            }
        }
        throw new RuntimeException("Unknown transport: " + (Object)((Object)transport));
    }
}

