/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.client;

import diskCacheV111.srm.RequestFileStatus;
import diskCacheV111.srm.RequestStatus;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.xml.rpc.ServiceException;
import org.apache.axis.types.URI;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRMException;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.client.Transport;
import org.dcache.srm.client.TurlGetterPutter;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.util.RequestStatusTool;
import org.dcache.srm.util.SrmUrl;
import org.dcache.srm.v2_2.ArrayOfAnyURI;
import org.dcache.srm.v2_2.ArrayOfString;
import org.dcache.srm.v2_2.ArrayOfTPutFileRequest;
import org.dcache.srm.v2_2.ArrayOfTPutRequestFileStatus;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmPrepareToPutRequest;
import org.dcache.srm.v2_2.SrmPrepareToPutResponse;
import org.dcache.srm.v2_2.SrmPutDoneRequest;
import org.dcache.srm.v2_2.SrmPutDoneResponse;
import org.dcache.srm.v2_2.SrmStatusOfPutRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfPutRequestResponse;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TAccessPattern;
import org.dcache.srm.v2_2.TConnectionType;
import org.dcache.srm.v2_2.TFileStorageType;
import org.dcache.srm.v2_2.TOverwriteMode;
import org.dcache.srm.v2_2.TPutFileRequest;
import org.dcache.srm.v2_2.TPutRequestFileStatus;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TRetentionPolicyInfo;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.dcache.srm.v2_2.TTransferParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteTurlPutterV2
extends TurlGetterPutter {
    private static final Logger logger = LoggerFactory.getLogger(RemoteTurlPutterV2.class);
    private ISRM srmv2;
    private String requestToken;
    private String targetSpaceToken;
    private HashMap<String, Integer> pendingSurlsToIndex = new HashMap();
    SrmPrepareToPutResponse srmPrepareToPutResponse;
    final Transport transport;
    protected String[] SURLs;
    protected int number_of_file_reqs;
    protected boolean createdMap;
    long[] sizes;
    long retry_timout;
    long requestLifetime;
    int retry_num;
    private TFileStorageType storageType;
    private TRetentionPolicy retentionPolicy;
    private TAccessLatency accessLatency;
    private TOverwriteMode overwriteMode;

    public RemoteTurlPutterV2(AbstractStorageElement storage, RequestCredential credential, String[] SURLs, long[] sizes, String[] protocols, PropertyChangeListener listener, long retry_timeout, int retry_num, long requestLifetime, TFileStorageType storageType, TRetentionPolicy retentionPolicy, TAccessLatency accessLatency, TOverwriteMode overwriteMode, String targetSpaceToken, Transport transport) {
        super(storage, credential, protocols);
        this.SURLs = SURLs;
        this.number_of_file_reqs = SURLs.length;
        this.addListener(listener);
        this.sizes = sizes;
        this.retry_num = retry_num;
        this.retry_timout = retry_timeout;
        this.requestLifetime = requestLifetime;
        this.storageType = storageType;
        this.accessLatency = accessLatency;
        this.retentionPolicy = retentionPolicy;
        this.overwriteMode = overwriteMode;
        this.targetSpaceToken = targetSpaceToken;
        this.transport = transport;
    }

    protected void putDone(String surl) throws RemoteException, URI.MalformedURIException {
        URI[] surlArray = new URI[1];
        SrmPutDoneRequest srmPutDoneRequest = new SrmPutDoneRequest();
        srmPutDoneRequest.setRequestToken(this.requestToken);
        srmPutDoneRequest.setArrayOfSURLs(new ArrayOfAnyURI(surlArray));
        SrmPutDoneResponse srmPutDoneResponse = this.srmv2.srmPutDone(srmPutDoneRequest);
        TReturnStatus returnStatus = srmPutDoneResponse.getReturnStatus();
        if (returnStatus == null) {
            logger.error("srmPutDone return status is null");
            return;
        }
        logger.debug("srmPutDone status code=" + returnStatus.getStatusCode());
    }

    @Override
    public void getInitialRequest() throws SRMException {
        if (this.number_of_file_reqs == 0) {
            logger.debug("number_of_file_reqs is 0, nothing to do");
            return;
        }
        try {
            SrmUrl srmUrl = new SrmUrl(this.SURLs[0]);
            this.srmv2 = new SRMClientV2(srmUrl, this.credential.getDelegatedCredential(), this.retry_timout, this.retry_num, true, true, this.transport);
            int len = this.SURLs.length;
            TPutFileRequest[] fileRequests = new TPutFileRequest[len];
            for (int i = 0; i < len; ++i) {
                URI uri = new URI(this.SURLs[i]);
                fileRequests[i] = new TPutFileRequest();
                fileRequests[i].setTargetSURL(uri);
                this.pendingSurlsToIndex.put(this.SURLs[i], i);
            }
            SrmPrepareToPutRequest srmPrepareToPutRequest = new SrmPrepareToPutRequest();
            if (this.retentionPolicy != null || this.accessLatency != null) {
                TRetentionPolicyInfo retentionPolicyInfo = new TRetentionPolicyInfo();
                retentionPolicyInfo.setRetentionPolicy(this.retentionPolicy);
                retentionPolicyInfo.setAccessLatency(this.accessLatency);
                srmPrepareToPutRequest.setTargetFileRetentionPolicyInfo(retentionPolicyInfo);
            }
            TTransferParameters transferParameters = new TTransferParameters();
            transferParameters.setAccessPattern(TAccessPattern.TRANSFER_MODE);
            transferParameters.setConnectionType(TConnectionType.WAN);
            transferParameters.setArrayOfTransferProtocols(new ArrayOfString(this.protocols));
            srmPrepareToPutRequest.setTransferParameters(transferParameters);
            srmPrepareToPutRequest.setArrayOfFileRequests(new ArrayOfTPutFileRequest(fileRequests));
            srmPrepareToPutRequest.setDesiredFileStorageType(this.storageType);
            srmPrepareToPutRequest.setDesiredTotalRequestTime((int)this.requestLifetime);
            srmPrepareToPutRequest.setOverwriteOption(this.overwriteMode);
            srmPrepareToPutRequest.setTargetSpaceToken(this.targetSpaceToken);
            this.srmPrepareToPutResponse = this.srmv2.srmPrepareToPut(srmPrepareToPutRequest);
        }
        catch (IOException | InterruptedException | ServiceException e) {
            logger.error("failed to connect to {} {}", (Object)this.SURLs[0], (Object)e.getMessage());
            throw new SRMException("failed to connect to " + this.SURLs[0], e);
        }
    }

    @Override
    public void run() {
        if (this.number_of_file_reqs == 0) {
            logger.debug("number_of_file_reqs is 0, nothing to do");
            return;
        }
        try {
            int len = this.SURLs.length;
            if (this.srmPrepareToPutResponse == null) {
                throw new IOException(" null srmPrepareToPutResponse");
            }
            TReturnStatus status = this.srmPrepareToPutResponse.getReturnStatus();
            if (status == null) {
                throw new IOException(" null return status");
            }
            TStatusCode statusCode = status.getStatusCode();
            if (statusCode == null) {
                throw new IOException(" null status code");
            }
            if (RequestStatusTool.isFailedRequestStatus(status)) {
                throw new IOException("srmPrepareToPut submission failed, unexpected or failed status : " + statusCode + " explanation=" + status.getExplanation());
            }
            this.requestToken = this.srmPrepareToPutResponse.getRequestToken();
            logger.debug(" srm returned requestToken = " + this.requestToken + " one of remote surls = " + this.SURLs[0]);
            ArrayOfTPutRequestFileStatus arrayOfTPutRequestFileStatus = this.srmPrepareToPutResponse.getArrayOfFileStatuses();
            if (arrayOfTPutRequestFileStatus == null) {
                throw new IOException("returned PutRequestFileStatuses is an empty array");
            }
            TPutRequestFileStatus[] putRequestFileStatuses = arrayOfTPutRequestFileStatus.getStatusArray();
            if (putRequestFileStatuses == null) {
                throw new IOException("returned PutRequestFileStatuses is an empty array");
            }
            if (putRequestFileStatuses.length != len) {
                throw new IOException("incorrect number of GetRequestFileStatusesin RequestStatus expected " + len + " received " + putRequestFileStatuses.length);
            }
            boolean haveCompletedFileRequests = false;
            while (!this.pendingSurlsToIndex.isEmpty()) {
                int expectedResponseLength;
                URI surl;
                long estimatedWaitInSeconds = Integer.MAX_VALUE;
                for (TPutRequestFileStatus putRequestFileStatus : putRequestFileStatuses) {
                    int indx;
                    surl = putRequestFileStatus.getSURL();
                    if (surl == null) {
                        logger.error("invalid putRequestFileStatus, surl is null");
                        continue;
                    }
                    String surl_string = surl.toString();
                    if (!this.pendingSurlsToIndex.containsKey(surl_string)) {
                        logger.error("invalid putRequestFileStatus, surl = " + surl_string + " not found");
                        continue;
                    }
                    TReturnStatus fileStatus = putRequestFileStatus.getStatus();
                    if (fileStatus == null) {
                        throw new IOException(" null file return status");
                    }
                    TStatusCode fileStatusCode = fileStatus.getStatusCode();
                    if (fileStatusCode == null) {
                        throw new IOException(" null file status code");
                    }
                    if (RequestStatusTool.isFailedFileRequestStatus(fileStatus)) {
                        String error = "retreval of surl " + surl_string + " failed, status = " + fileStatusCode + " explanation=" + fileStatus.getExplanation();
                        logger.error(error);
                        indx = this.pendingSurlsToIndex.remove(surl_string);
                        this.notifyOfFailure(this.SURLs[indx], error, this.requestToken, null);
                        haveCompletedFileRequests = true;
                        continue;
                    }
                    if (putRequestFileStatus.getTransferURL() != null) {
                        String turl = putRequestFileStatus.getTransferURL().toString();
                        indx = this.pendingSurlsToIndex.remove(surl_string);
                        this.notifyOfTURL(this.SURLs[indx], turl, this.requestToken, null, null);
                        continue;
                    }
                    if (putRequestFileStatus.getEstimatedWaitTime() == null || (long)putRequestFileStatus.getEstimatedWaitTime().intValue() >= estimatedWaitInSeconds || putRequestFileStatus.getEstimatedWaitTime() < 1) continue;
                    estimatedWaitInSeconds = putRequestFileStatus.getEstimatedWaitTime().intValue();
                }
                if (this.pendingSurlsToIndex.isEmpty()) {
                    logger.debug("no more pending transfers, breaking the loop");
                    break;
                }
                if (estimatedWaitInSeconds > 60L) {
                    estimatedWaitInSeconds = 60L;
                }
                try {
                    logger.debug("sleeping " + estimatedWaitInSeconds + " seconds ...");
                    Thread.sleep(estimatedWaitInSeconds * 1000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                SrmStatusOfPutRequestRequest srmStatusOfPutRequestRequest = new SrmStatusOfPutRequestRequest();
                srmStatusOfPutRequestRequest.setRequestToken(this.requestToken);
                if (haveCompletedFileRequests) {
                    String[] pendingSurlStrings = this.pendingSurlsToIndex.keySet().toArray(new String[this.pendingSurlsToIndex.size()]);
                    expectedResponseLength = pendingSurlStrings.length;
                    URI[] surlArray = new URI[expectedResponseLength];
                    for (int i = 0; i < expectedResponseLength; ++i) {
                        URI uri;
                        surlArray[i] = uri = new URI(pendingSurlStrings[i]);
                    }
                    srmStatusOfPutRequestRequest.setArrayOfTargetSURLs(new ArrayOfAnyURI(surlArray));
                } else {
                    expectedResponseLength = this.SURLs.length;
                    URI[] surlArray = new URI[expectedResponseLength];
                    for (int i = 0; i < expectedResponseLength; ++i) {
                        surlArray[i] = surl = new URI(this.SURLs[i]);
                    }
                    srmStatusOfPutRequestRequest.setArrayOfTargetSURLs(new ArrayOfAnyURI(surlArray));
                }
                SrmStatusOfPutRequestResponse srmStatusOfPutRequestResponse = this.srmv2.srmStatusOfPutRequest(srmStatusOfPutRequestRequest);
                if (srmStatusOfPutRequestResponse == null) {
                    throw new IOException(" null srmStatusOfPutRequestResponse");
                }
                arrayOfTPutRequestFileStatus = srmStatusOfPutRequestResponse.getArrayOfFileStatuses();
                if (arrayOfTPutRequestFileStatus == null) {
                    throw new IOException("incorrect number of RequestFileStatuses");
                }
                putRequestFileStatuses = arrayOfTPutRequestFileStatus.getStatusArray();
                if (putRequestFileStatuses == null || putRequestFileStatuses.length != expectedResponseLength) {
                    logger.error("incorrect number of RequestFileStatuses");
                    throw new IOException("incorrect number of RequestFileStatuses");
                }
                status = srmStatusOfPutRequestResponse.getReturnStatus();
                if (status == null) {
                    throw new IOException(" null return status");
                }
                statusCode = status.getStatusCode();
                if (statusCode == null) {
                    throw new IOException(" null status code");
                }
                if (!RequestStatusTool.isFailedRequestStatus(status)) continue;
                throw new IOException("srmPrepareToPut update failed, unexpected or failed status : " + statusCode + " explanation=" + status.getExplanation());
            }
        }
        catch (IOException | SRMException ioe) {
            logger.error(ioe.toString());
            this.notifyOfFailure(ioe);
        }
    }

    public static RequestFileStatus getFileRequest(RequestStatus rs, Integer nextID) {
        RequestFileStatus[] frs = rs.fileStatuses;
        if (frs == null) {
            return null;
        }
        for (RequestFileStatus fr : frs) {
            if (fr.fileId != nextID) continue;
            return fr;
        }
        return null;
    }

    public static void staticPutDone(RequestCredential credential, String surl, String requestTokenString, long retry_timeout, int retry_num, Transport transport) throws Exception {
        SrmUrl srmUrl = new SrmUrl(surl);
        SRMClientV2 srmv2 = new SRMClientV2(srmUrl, credential.getDelegatedCredential(), retry_timeout, retry_num, true, true, transport);
        String requestToken = requestTokenString;
        String[] surl_strings = new String[]{surl};
        URI[] surlArray = new URI[]{new URI(surl)};
        SrmPutDoneRequest srmPutDoneRequest = new SrmPutDoneRequest();
        srmPutDoneRequest.setRequestToken(requestToken);
        srmPutDoneRequest.setArrayOfSURLs(new ArrayOfAnyURI(surlArray));
        SrmPutDoneResponse srmPutDoneResponse = srmv2.srmPutDone(srmPutDoneRequest);
        TReturnStatus returnStatus = srmPutDoneResponse.getReturnStatus();
        if (returnStatus == null) {
            logger.error("srmPutDone return status is null");
            return;
        }
        logger.debug("srmPutDone status code=" + returnStatus.getStatusCode());
    }
}

