/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.table;

import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.freehep.swing.table.SortableTableModel;
import org.freehep.swing.table.TableColumnHeaderListener;
import org.freehep.swing.table.TableHeaderCellRenderer;

public class TableSorter {
    private static Icon downTriangle = new Triangle(false);
    private static Icon upTriangle = new Triangle(true);
    private SortableTableModel model;
    private JTableHeader header;

    public TableSorter(JTable table) {
        table.addPropertyChangeListener("model", new ModelChangeListener());
        this.modelChanged(table.getModel());
        this.header = table.getTableHeader();
        this.header.addMouseListener(new HeaderListener());
        this.header.setDefaultRenderer(new HeaderRenderer());
    }

    public TableSorter(JTable table, int column) {
        this(table, column, true);
    }

    public TableSorter(JTable table, int column, boolean ascending) {
        this(table);
        this.sort(column, ascending);
    }

    public int getSortOnColumn() {
        return this.model == null ? -1 : this.model.getSortOnColumn();
    }

    public void setSortOnColumn(int column) {
        if (this.model != null) {
            this.model.sort(column, true);
        }
    }

    public boolean isSortAscending() {
        return this.model == null ? true : this.model.isSortAscending();
    }

    public void setSortAscending(boolean ascending) {
        if (this.model != null) {
            this.model.sort(this.model.getSortOnColumn(), ascending);
        }
    }

    private void sort(int sortOnColumn, boolean sortAscending) {
        if (this.model != null) {
            this.model.sort(sortOnColumn, sortAscending);
            this.header.resizeAndRepaint();
        }
    }

    private void modelChanged(TableModel model) {
        this.model = model instanceof SortableTableModel ? (SortableTableModel)model : null;
    }

    private static class Triangle
    implements Icon {
        private boolean up;
        private static final int size = 16;
        private static final int[] xxdown = new int[]{3, 12, 7};
        private static final int[] yydown = new int[]{5, 5, 10};
        private static final int[] xxup = new int[]{2, 12, 7};
        private static final int[] yyup = new int[]{10, 10, 4};

        Triangle(boolean up) {
            this.up = up;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int[] xp = new int[3];
            int[] yp = new int[3];
            for (int i = 0; i < 3; ++i) {
                xp[i] = x + (this.up ? xxup[i] : xxdown[i]);
                yp[i] = y + (this.up ? yyup[i] : yydown[i]);
            }
            g.setColor(c.getForeground());
            g.fillPolygon(xp, yp, 3);
        }
    }

    private class HeaderRenderer
    extends TableHeaderCellRenderer {
        private HeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            if (TableSorter.this.model != null && table.convertColumnIndexToModel(col) == TableSorter.this.model.getSortOnColumn()) {
                label.setIcon(TableSorter.this.model.isSortAscending() ? downTriangle : upTriangle);
            } else {
                label.setIcon(null);
            }
            return label;
        }
    }

    private class HeaderListener
    extends TableColumnHeaderListener {
        private HeaderListener() {
        }

        @Override
        public void headerClicked(JTable table, int col) {
            if (TableSorter.this.model != null) {
                if (col != TableSorter.this.model.getSortOnColumn()) {
                    TableSorter.this.sort(col, true);
                } else {
                    TableSorter.this.sort(TableSorter.this.model.getSortOnColumn(), !TableSorter.this.model.isSortAscending());
                }
            }
        }
    }

    private class ModelChangeListener
    implements PropertyChangeListener {
        private ModelChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TableSorter.this.modelChanged((TableModel)evt.getNewValue());
        }
    }
}

