/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.event;

import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class MouseInputRouter
implements MouseInputListener {
    MouseInputListener left;
    MouseInputListener middle;
    MouseInputListener right;

    public MouseInputRouter(Component c) {
        c.addMouseMotionListener(this);
        c.addMouseListener(this);
    }

    public void setLeftMouseInputListener(MouseInputListener l) {
        this.left = l;
    }

    public void setMiddleMouseInputListener(MouseInputListener l) {
        this.middle = l;
    }

    public void setRightInputListener(MouseInputListener l) {
        this.right = l;
    }

    private MouseEvent convertMouseEvent(MouseEvent event) {
        int modifiers = event.getModifiers() | event.getModifiersEx();
        modifiers |= 0x10;
        modifiers &= 0xFFFFFFF7;
        modifiers &= 0xFFFFFFFB;
        modifiers |= 0x400;
        modifiers &= 0xFFFFF7FF;
        return new MouseEvent(event.getComponent(), event.getID(), event.getWhen(), modifiers &= 0xFFFFEFFF, event.getX(), event.getY(), event.getClickCount(), event.isPopupTrigger(), event.getButton());
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.left != null && SwingUtilities.isLeftMouseButton(event)) {
            this.left.mousePressed(event);
        }
        if (this.middle != null && SwingUtilities.isMiddleMouseButton(event)) {
            this.middle.mousePressed(this.convertMouseEvent(event));
        }
        if (this.right != null && SwingUtilities.isRightMouseButton(event)) {
            this.right.mousePressed(this.convertMouseEvent(event));
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.left != null && SwingUtilities.isLeftMouseButton(event)) {
            this.left.mouseReleased(event);
        }
        if (this.middle != null && SwingUtilities.isMiddleMouseButton(event)) {
            this.middle.mouseReleased(this.convertMouseEvent(event));
        }
        if (this.right != null && SwingUtilities.isRightMouseButton(event)) {
            this.right.mouseReleased(this.convertMouseEvent(event));
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.left != null && SwingUtilities.isLeftMouseButton(event)) {
            this.left.mouseClicked(event);
        }
        if (this.middle != null && SwingUtilities.isMiddleMouseButton(event)) {
            this.middle.mouseClicked(this.convertMouseEvent(event));
        }
        if (this.right != null && SwingUtilities.isRightMouseButton(event)) {
            this.right.mouseClicked(this.convertMouseEvent(event));
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.left != null && SwingUtilities.isLeftMouseButton(event)) {
            this.left.mouseDragged(event);
        }
        if (this.middle != null && SwingUtilities.isMiddleMouseButton(event)) {
            this.middle.mouseDragged(this.convertMouseEvent(event));
        }
        if (this.right != null && SwingUtilities.isRightMouseButton(event)) {
            this.right.mouseDragged(this.convertMouseEvent(event));
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.left != null) {
            this.left.mouseMoved(event);
        }
        if (this.middle != null) {
            this.middle.mouseMoved(event);
        }
        if (this.right != null) {
            this.right.mouseMoved(event);
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        if (this.left != null) {
            this.left.mouseEntered(event);
        }
        if (this.middle != null) {
            this.middle.mouseEntered(event);
        }
        if (this.right != null) {
            this.right.mouseEntered(event);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        if (this.left != null) {
            this.left.mouseExited(event);
        }
        if (this.middle != null) {
            this.middle.mouseExited(event);
        }
        if (this.right != null) {
            this.right.mouseExited(event);
        }
    }
}

