/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation.validator;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.validator.AbstractValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlValidator
extends AbstractValidator<String> {
    private static final long serialVersionUID = 1L;
    public static final int ALLOW_ALL_SCHEMES = 1;
    public static final int ALLOW_2_SLASHES = 2;
    public static final int NO_FRAGMENTS = 4;
    private static final String ALPHA_CHARS = "a-zA-Z";
    private static final String ALPHA_NUMERIC_CHARS = "a-zA-Z\\d";
    private static final String SPECIAL_CHARS = ";/@&=,.?:+$";
    private static final String VALID_CHARS = "[^\\s;/@&=,.?:+$]";
    private static final String SCHEME_CHARS = "a-zA-Z";
    private static final String AUTHORITY_CHARS = "a-zA-Z\\d\\-\\.";
    private static final String ATOM = "[^\\s;/@&=,.?:+$]+";
    private static final String URL_PATTERN = "^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?";
    private static final int PARSE_URL_SCHEME = 2;
    private static final int PARSE_URL_AUTHORITY = 4;
    private static final int PARSE_URL_PATH = 5;
    private static final int PARSE_URL_QUERY = 7;
    private static final int PARSE_URL_FRAGMENT = 9;
    private static final String SCHEME_PATTERN = "^[a-zA-Z].*$";
    private static final String AUTHORITY_PATTERN = "^(.+(:.*)?@)?([a-zA-Z\\d\\-\\.]*)(:\\d*)?(.*)?";
    private static final int PARSE_AUTHORITY_HOST_IP = 3;
    private static final int PARSE_AUTHORITY_PORT = 4;
    private static final int PARSE_AUTHORITY_EXTRA = 5;
    private static final String PATH_PATTERN = "^(/[-\\w:@&?=+,.!/~*'%$_;]*)?$";
    private static final String QUERY_PATTERN = "^(.*)$";
    private static final String LEGAL_ASCII_PATTERN = "^[\\x00-\\x7F]+$";
    private static final String IP_V4_DOMAIN_PATTERN = "^(\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})$";
    private static final String DOMAIN_PATTERN = "^[^\\s;/@&=,.?:+$]+(\\.[^\\s;/@&=,.?:+$]+)*$";
    private static final String PORT_PATTERN = "^:(\\d{1,5})$";
    private static final String ATOM_PATTERN = "([^\\s;/@&=,.?:+$]+)";
    private static final String ALPHA_PATTERN = "^[a-zA-Z]";
    private long options = 0L;
    private final Set<String> allowedSchemes = new HashSet<String>();
    protected String[] defaultSchemes = new String[]{"http", "https", "ftp"};

    public UrlValidator() {
        this(null);
    }

    public UrlValidator(String[] schemes) {
        this(schemes, 0);
    }

    public UrlValidator(int options) {
        this(null, options);
    }

    public UrlValidator(String[] schemes, int options) {
        this.options = options;
        if (this.isOn(1L)) {
            return;
        }
        if (schemes == null) {
            schemes = this.defaultSchemes;
        }
        this.allowedSchemes.addAll(Arrays.asList(schemes));
    }

    @Override
    protected void onValidate(IValidatable<String> validatable) {
        String url = validatable.getValue();
        if (url != null && !this.isValid(url)) {
            this.error(validatable);
        }
    }

    public final boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        Matcher matchAsciiPat = Pattern.compile(LEGAL_ASCII_PATTERN).matcher(value);
        if (!matchAsciiPat.matches()) {
            return false;
        }
        Matcher matchUrlPat = Pattern.compile(URL_PATTERN).matcher(value);
        if (!matchUrlPat.matches()) {
            return false;
        }
        if (!this.isValidScheme(matchUrlPat.group(2))) {
            return false;
        }
        if (!this.isValidAuthority(matchUrlPat.group(4))) {
            return false;
        }
        if (!this.isValidPath(matchUrlPat.group(5))) {
            return false;
        }
        if (!this.isValidQuery(matchUrlPat.group(7))) {
            return false;
        }
        return this.isValidFragment(matchUrlPat.group(9));
    }

    protected boolean isValidScheme(String scheme) {
        if (scheme == null) {
            return false;
        }
        if (!Pattern.compile(SCHEME_PATTERN).matcher(scheme).matches()) {
            return false;
        }
        return !this.isOff(1L) || this.allowedSchemes.contains(scheme);
    }

    protected boolean isValidAuthority(String authority) {
        Matcher portMatcher;
        if (authority == null) {
            return false;
        }
        Matcher authorityMatcher = Pattern.compile(AUTHORITY_PATTERN).matcher(authority);
        if (!authorityMatcher.matches()) {
            return false;
        }
        boolean ipV4Address = false;
        boolean hostname = false;
        String hostIP = authorityMatcher.group(3);
        Matcher matchIPV4Pat = Pattern.compile(IP_V4_DOMAIN_PATTERN).matcher(hostIP);
        ipV4Address = matchIPV4Pat.matches();
        if (ipV4Address) {
            for (int i = 1; i <= 4; ++i) {
                String ipSegment = matchIPV4Pat.group(i);
                if (ipSegment == null || ipSegment.length() <= 0) {
                    return false;
                }
                try {
                    if (Integer.parseInt(ipSegment) <= 255) continue;
                    return false;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        } else {
            hostname = Pattern.compile(DOMAIN_PATTERN).matcher(hostIP).matches();
        }
        if (hostname) {
            char[] chars = hostIP.toCharArray();
            int size = 1;
            for (char ch : chars) {
                if (ch != '.') continue;
                ++size;
            }
            String[] domainSegment = new String[size];
            boolean match = true;
            int segmentCount = 0;
            int segmentLength = 0;
            while (match) {
                Matcher atomMatcher = Pattern.compile(ATOM_PATTERN).matcher(hostIP);
                match = atomMatcher.find();
                if (!match) continue;
                domainSegment[segmentCount] = atomMatcher.group(1);
                segmentLength = domainSegment[segmentCount].length() + 1;
                hostIP = segmentLength >= hostIP.length() ? "" : hostIP.substring(segmentLength);
                ++segmentCount;
            }
            if (segmentCount > 1) {
                String topLevel = domainSegment[segmentCount - 1];
                if (topLevel.length() < 2) {
                    return false;
                }
                Matcher alphaMatcher = Pattern.compile(ALPHA_PATTERN).matcher(topLevel.substring(0, 1));
                if (!alphaMatcher.matches()) {
                    return false;
                }
            }
        }
        if (!hostname && !ipV4Address) {
            return false;
        }
        String port = authorityMatcher.group(4);
        if (port != null && !(portMatcher = Pattern.compile(PORT_PATTERN).matcher(port)).matches()) {
            return false;
        }
        String extra = authorityMatcher.group(5);
        return UrlValidator.isBlankOrNull(extra);
    }

    protected boolean isValidPath(String path) {
        if (path == null) {
            return false;
        }
        Matcher pathMatcher = Pattern.compile(PATH_PATTERN).matcher(path);
        if (!pathMatcher.matches()) {
            return false;
        }
        int slash2Count = this.countToken("//", path);
        if (this.isOff(2L) && slash2Count > 0) {
            return false;
        }
        int slashCount = this.countToken("/", path);
        int dot2Count = this.countToken("/..", path);
        return dot2Count <= 0 || slashCount - slash2Count - 1 > dot2Count;
    }

    protected boolean isValidQuery(String query) {
        if (query == null) {
            return true;
        }
        Matcher queryMatcher = Pattern.compile(QUERY_PATTERN).matcher(query);
        return queryMatcher.matches();
    }

    protected boolean isValidFragment(String fragment) {
        if (fragment == null) {
            return true;
        }
        return this.isOff(4L);
    }

    protected int countToken(String token, String target) {
        int tokenIndex = 0;
        int count = 0;
        while (tokenIndex != -1) {
            if ((tokenIndex = target.indexOf(token, tokenIndex)) <= -1) continue;
            ++tokenIndex;
            ++count;
        }
        return count;
    }

    public static boolean isBlankOrNull(String value) {
        return value == null || value.trim().length() == 0;
    }

    public boolean isOn(long flag) {
        return (this.options & flag) > 0L;
    }

    public boolean isOff(long flag) {
        return (this.options & flag) == 0L;
    }
}

