/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.loader;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.repeater.AbstractRepeater;
import org.apache.wicket.resource.IPropertiesFactory;
import org.apache.wicket.resource.Properties;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.locator.ResourceNameIterator;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentStringResourceLoader
implements IStringResourceLoader {
    private static final Logger log = LoggerFactory.getLogger(ComponentStringResourceLoader.class);

    @Override
    public String loadStringResource(Class<?> clazz, String key, Locale locale, String style, String variation) {
        if (clazz == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("key: '" + key + "'; class: '" + clazz.getName() + "'; locale: '" + locale + "'; Style: '" + style + "'; Variation: '" + variation + '\'');
        }
        IPropertiesFactory propertiesFactory = this.getPropertiesFactory();
        do {
            String path = clazz.getName().replace('.', '/');
            ResourceNameIterator iter = this.newResourceNameIterator(path, locale, style, variation);
            while (iter.hasNext()) {
                String value;
                String newPath = iter.next();
                Properties props = propertiesFactory.load(clazz, newPath);
                if (props == null || (value = props.getString(key)) == null) continue;
                return value;
            }
        } while (!this.isStopResourceSearch(clazz) && (clazz = clazz.getSuperclass()) != null);
        return null;
    }

    protected ResourceNameIterator newResourceNameIterator(String path, Locale locale, String style, String variation) {
        return Application.get().getResourceSettings().getResourceStreamLocator().newResourceNameIterator(path, locale, style, variation, null, false);
    }

    protected IPropertiesFactory getPropertiesFactory() {
        return Application.get().getResourceSettings().getPropertiesFactory();
    }

    @Override
    public String loadStringResource(Component component, String key, Locale locale, String style, String variation) {
        if (component == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("component: '" + component.toString(false) + "'; key: '" + key + '\'');
        }
        String string = null;
        String prefix = this.getResourcePath(component);
        for (Component current : this.getComponentTrail(component)) {
            Class<?> clazz = current.getClass();
            if (!Strings.isEmpty((CharSequence)prefix)) {
                string = this.loadStringResource(clazz, prefix + '.' + key, locale, style, variation);
                if (string != null) {
                    return string;
                }
                if (!(current instanceof AbstractRepeater)) {
                    prefix = Strings.afterFirst((String)prefix, (char)'.');
                }
            }
            if ((string = this.loadStringResource(clazz, key, locale, style, variation)) == null) continue;
            return string;
        }
        return string;
    }

    protected String getResourcePath(Component component) {
        Component current = (Component)Args.notNull((Object)component, (String)"component");
        StringBuilder buffer = new StringBuilder();
        while (current.getParent() != null) {
            boolean skip = current.getParent() instanceof AbstractRepeater;
            if (!skip) {
                if (buffer.length() > 0) {
                    buffer.insert(0, '.');
                }
                buffer.insert(0, current.getId());
            }
            current = current.getParent();
        }
        return buffer.toString();
    }

    private List<Component> getComponentTrail(Component component) {
        ArrayList<Component> path = new ArrayList<Component>();
        while (component != null) {
            path.add(0, component);
            component = component.getParent();
        }
        return path;
    }

    protected boolean isStopResourceSearch(Class<?> clazz) {
        if (clazz == null || clazz.equals(Object.class) || clazz.equals(Application.class)) {
            return true;
        }
        if (clazz.equals(WebPage.class) || clazz.equals(WebMarkupContainer.class) || clazz.equals(WebComponent.class)) {
            return true;
        }
        return clazz.equals(Page.class) || clazz.equals(MarkupContainer.class) || clazz.equals(Component.class);
    }
}

