/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.css.ICssCompressor;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.PackageResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssPackageResource
extends PackageResource {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(CssPackageResource.class);

    public CssPackageResource(Class<?> scope, String name, Locale locale, String style, String variation) {
        super(scope, name, locale, style, variation);
    }

    @Override
    protected byte[] processResponse(IResource.Attributes attributes, byte[] bytes) {
        byte[] processedResponse = super.processResponse(attributes, bytes);
        ICssCompressor compressor = this.getCompressor();
        if (compressor != null) {
            try {
                String nonCompressed = new String(processedResponse, "UTF-8");
                return compressor.compress(nonCompressed).getBytes();
            }
            catch (Exception e) {
                log.error("Error while filtering content", (Throwable)e);
                return processedResponse;
            }
        }
        return processedResponse;
    }

    protected ICssCompressor getCompressor() {
        ICssCompressor compressor = null;
        if (Application.exists()) {
            compressor = Application.get().getResourceSettings().getCssCompressor();
        }
        return compressor;
    }
}

