/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.caching.IStaticCacheableResource;
import org.apache.wicket.util.io.ByteArrayOutputStream;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.resource.WebExternalResourceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextRelativeResource
extends AbstractResource
implements IStaticCacheableResource {
    private static final String CACHE_PREFIX = "context-relative:/";
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ContextRelativeResource.class);
    private final String path;

    public ContextRelativeResource(String pathRelativeToContextRoot) {
        if (pathRelativeToContextRoot == null) {
            throw new IllegalArgumentException("Cannot have null path for ContextRelativeResource.");
        }
        if (!pathRelativeToContextRoot.startsWith("/")) {
            pathRelativeToContextRoot = "/" + pathRelativeToContextRoot;
        }
        this.path = pathRelativeToContextRoot;
    }

    public Serializable getCacheKey() {
        return CACHE_PREFIX + this.path;
    }

    public IResourceStream getCacheableResourceStream() {
        return new WebExternalResourceStream(this.path);
    }

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse resourceResponse = new AbstractResource.ResourceResponse();
        final WebExternalResourceStream webExternalResourceStream = new WebExternalResourceStream(this.path);
        resourceResponse.setContentType(webExternalResourceStream.getContentType());
        resourceResponse.setLastModified(webExternalResourceStream.lastModifiedTime());
        resourceResponse.setFileName(this.path);
        resourceResponse.setWriteCallback(new AbstractResource.WriteCallback(){

            public void writeData(IResource.Attributes attributes) {
                InputStream inputStream = null;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    inputStream = webExternalResourceStream.getInputStream();
                    Streams.copy((InputStream)inputStream, (OutputStream)baos);
                    attributes.getResponse().write(baos.toByteArray());
                }
                catch (ResourceStreamNotFoundException rsnfx) {
                    throw new WicketRuntimeException(rsnfx);
                }
                catch (IOException iox) {
                    throw new WicketRuntimeException(iox);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)inputStream);
                    IOUtils.closeQuietly((Closeable)baos);
                }
            }
        });
        return resourceResponse;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContextRelativeResource other = (ContextRelativeResource)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }
}

