/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.repeater;

import java.util.Iterator;
import org.apache.wicket.markup.repeater.IItemFactory;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultItemReuseStrategy
implements IItemReuseStrategy {
    private static final long serialVersionUID = 1L;
    private static final IItemReuseStrategy instance = new DefaultItemReuseStrategy();

    public static IItemReuseStrategy getInstance() {
        return instance;
    }

    @Override
    public <T> Iterator<Item<T>> getItems(final IItemFactory<T> factory, final Iterator<IModel<T>> newModels, Iterator<Item<T>> existingItems) {
        return new Iterator<Item<T>>(){
            private int index = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return newModels.hasNext();
            }

            @Override
            public Item<T> next() {
                IModel model = (IModel)newModels.next();
                Item item = factory.newItem(this.index, model);
                ++this.index;
                return item;
            }
        };
    }
}

