/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.markup.parser.XmlTag;

public class OpenCloseTagExpander
extends AbstractMarkupFilter {
    private static final List<String> replaceForTags = Arrays.asList("a", "q", "sub", "sup", "abbr", "acronym", "cite", "code", "del", "dfn", "em", "ins", "kbd", "samp", "var", "label", "textarea", "tr", "td", "th", "caption", "thead", "tbody", "tfoot", "dl", "dt", "dd", "li", "ol", "ul", "h1", "h2", "h3", "h4", "h5", "h6", "i", "pre", "title", "div", "span", "p", "strong", "b", "e", "select", "col", "article", "aside", "command", "details", "summary", "figure", "figcaption", "footer", "header", "hgroup", "mark", "meter", "nav", "progress", "ruby", "rt", "rp", "section", "audio", "video", "canvas", "datalist", "output");
    private ComponentTag next = null;

    public MarkupElement nextElement() throws ParseException {
        if (this.next != null) {
            ComponentTag rtn = this.next;
            this.next = null;
            return rtn;
        }
        return super.nextElement();
    }

    protected MarkupElement onComponentTag(ComponentTag tag) throws ParseException {
        if (tag.isOpenClose()) {
            String name = tag.getName();
            if (tag.getNamespace() != null) {
                name = tag.getNamespace() + ":" + tag.getName();
            }
            if (this.contains(name) && this.onFound(tag)) {
                this.next = new ComponentTag(tag.getName(), XmlTag.TagType.CLOSE);
                this.next.setNamespace(tag.getNamespace());
                this.next.setOpenTag(tag);
                this.next.setModified(true);
            }
        }
        return tag;
    }

    protected boolean onFound(ComponentTag tag) {
        tag.setType(XmlTag.TagType.OPEN);
        tag.setModified(true);
        return true;
    }

    protected boolean contains(String name) {
        return replaceForTags.contains(name.toLowerCase());
    }
}

