/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.behavior;

import org.apache.wicket.Component;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.behavior.IBehaviorListener;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public abstract class AbstractAjaxBehavior
extends Behavior
implements IBehaviorListener {
    private static final long serialVersionUID = 1L;
    private Component component;

    public final void bind(Component hostComponent) {
        if (hostComponent == null) {
            throw new IllegalArgumentException("Argument hostComponent must be not null");
        }
        if (this.component != null) {
            throw new IllegalStateException("this kind of handler cannot be attached to multiple components; it is already attached to component " + this.component + ", but component " + hostComponent + " wants to be attached too");
        }
        this.component = hostComponent;
        this.onBind();
    }

    public CharSequence getCallbackUrl() {
        if (this.getComponent() == null) {
            throw new IllegalArgumentException("Behavior must be bound to a component to create the URL");
        }
        RequestListenerInterface rli = IBehaviorListener.INTERFACE;
        return this.getComponent().urlFor(this, rli, new PageParameters());
    }

    public final void onComponentTag(Component component, ComponentTag tag) {
        this.onComponentTag(tag);
    }

    public final void afterRender(Component hostComponent) {
        this.onComponentRendered();
    }

    protected final Component getComponent() {
        return this.component;
    }

    protected void onComponentTag(ComponentTag tag) {
    }

    protected void onBind() {
    }

    protected void onComponentRendered() {
    }

    public boolean getStatelessHint(Component component) {
        return false;
    }

    public final void unbind(Component component) {
        this.onUnbind();
        component = null;
        super.unbind(component);
    }

    protected void onUnbind() {
    }
}

