/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.application;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.util.collections.UrlExternalFormComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassResolver
implements IClassResolver {
    private final ConcurrentMap<String, WeakReference<Class<?>>> classes = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Class<?> resolveClass(String className) throws ClassNotFoundException {
        Class<Comparable<Byte>> clazz = null;
        WeakReference ref = (WeakReference)this.classes.get(className);
        if (ref != null) {
            clazz = (Class<Byte>)ref.get();
        }
        if (clazz == null) {
            if (className.equals("byte")) {
                clazz = Byte.TYPE;
            } else if (className.equals("short")) {
                clazz = Short.TYPE;
            } else if (className.equals("int")) {
                clazz = Integer.TYPE;
            } else if (className.equals("long")) {
                clazz = Long.TYPE;
            } else if (className.equals("float")) {
                clazz = Float.TYPE;
            } else if (className.equals("double")) {
                clazz = Double.TYPE;
            } else if (className.equals("boolean")) {
                clazz = Boolean.TYPE;
            } else if (className.equals("char")) {
                clazz = Character.TYPE;
            } else {
                ConcurrentMap<String, WeakReference<Class<?>>> concurrentMap = this.classes;
                synchronized (concurrentMap) {
                    clazz = Class.forName(className, false, this.getClassLoader());
                    if (clazz == null) {
                        throw new ClassNotFoundException(className);
                    }
                }
                this.classes.put(className, new WeakReference<Class<Byte>>(clazz));
            }
        }
        return clazz;
    }

    public abstract ClassLoader getClassLoader();

    @Override
    public Iterator<URL> getResources(String name) {
        TreeSet<URL> resultSet = new TreeSet<URL>((Comparator<URL>)new UrlExternalFormComparator());
        try {
            Enumeration<URL> resources = Application.class.getClassLoader().getResources(name);
            this.loadResources(resources, resultSet);
            resources = Application.get().getClass().getClassLoader().getResources(name);
            this.loadResources(resources, resultSet);
            resources = this.getClassLoader().getResources(name);
            this.loadResources(resources, resultSet);
        }
        catch (Exception e) {
            throw new WicketRuntimeException(e);
        }
        return resultSet.iterator();
    }

    private void loadResources(Enumeration<URL> resources, Set<URL> loadedResources) {
        if (resources != null) {
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                loadedResources.add(url);
            }
        }
    }
}

