/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.markup.html.form;

import org.apache.wicket.ajax.AjaxChannel;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AjaxFallbackButton
extends Button {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AjaxFallbackButton.class);
    private final Form<?> mForm;

    public AjaxFallbackButton(String id, Form<?> form) {
        this(id, null, form);
    }

    public AjaxFallbackButton(String id, IModel<String> model, Form<?> form) {
        super(id, model);
        this.mForm = form;
        this.add(new AjaxFormSubmitBehavior(form, "onclick"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                AjaxFallbackButton.this.onSubmit(target, AjaxFallbackButton.this.getForm());
            }

            protected void onAfterSubmit(AjaxRequestTarget target) {
                AjaxFallbackButton.this.onAfterSubmit(target, AjaxFallbackButton.this.getForm());
            }

            protected void onError(AjaxRequestTarget target) {
                AjaxFallbackButton.this.onError(target, AjaxFallbackButton.this.getForm());
            }

            protected CharSequence getEventHandler() {
                return new AppendingStringBuffer(super.getEventHandler()).append("; return false;");
            }

            protected IAjaxCallDecorator getAjaxCallDecorator() {
                return AjaxFallbackButton.this.getAjaxCallDecorator();
            }

            protected AjaxChannel getChannel() {
                return AjaxFallbackButton.this.getChannel();
            }

            public boolean getDefaultProcessing() {
                return AjaxFallbackButton.this.getDefaultFormProcessing();
            }
        });
    }

    protected void onError(AjaxRequestTarget target, Form<?> form) {
    }

    @Override
    public final void onSubmit() {
        if (AjaxRequestTarget.get() == null) {
            this.onSubmit(null, this.getForm());
        }
    }

    @Override
    public final void onAfterSubmit() {
        if (AjaxRequestTarget.get() == null) {
            this.onAfterSubmit(null, this.getForm());
        }
    }

    @Override
    public Form<?> getForm() {
        return this.mForm == null ? super.getForm() : this.mForm;
    }

    protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
    }

    protected void onAfterSubmit(AjaxRequestTarget target, Form<?> form) {
    }

    protected IAjaxCallDecorator getAjaxCallDecorator() {
        return null;
    }

    protected AjaxChannel getChannel() {
        return null;
    }

    protected final boolean isButtonEnabled() {
        return this.isEnabledInHierarchy();
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        String tagName = tag.getName();
        if (LOG.isWarnEnabled() && !"input".equalsIgnoreCase(tagName) && !"button".equalsIgnoreCase(tagName)) {
            LOG.warn("{} must be used only with <input type=\"submit\"> or <input type=\"submit\"> markup elements. The fallback functionality doesn't work for other markup elements. Component path: {}, markup element: {}.", new Object[]{AjaxFallbackButton.class.getSimpleName(), this.getClassRelativePath(), tagName});
        }
        super.onComponentTag(tag);
    }
}

