/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import java.util.UUID;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.util.string.JavaScriptUtils;
import org.apache.wicket.util.string.StringValue;

public abstract class AjaxNewWindowNotifyingBehavior
extends AbstractDefaultAjaxBehavior {
    private final String windowName;
    private static final String PARAM_WINDOW_NAME = "windowName";
    private boolean hasBeenRendered;

    public AjaxNewWindowNotifyingBehavior() {
        this(UUID.randomUUID().toString());
    }

    public AjaxNewWindowNotifyingBehavior(String windowName) {
        this.windowName = windowName;
    }

    protected final void onBind() {
        super.onBind();
        Component component = this.getComponent();
        if (!(component instanceof WebPage)) {
            throw new WicketRuntimeException(AjaxNewWindowNotifyingBehavior.class.getName() + " can be assigned only to WebPage instances.");
        }
    }

    public CharSequence getCallbackUrl() {
        return super.getCallbackUrl() + "&" + PARAM_WINDOW_NAME + "=' + window.name + '";
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        if (!this.hasBeenRendered) {
            this.hasBeenRendered = true;
            response.renderOnDomReadyJavaScript(String.format("window.name='%s'", this.windowName));
        }
        CharSequence callbackScript = JavaScriptUtils.escapeQuotes(this.getCallbackScript());
        response.renderOnLoadJavaScript("setTimeout('" + callbackScript + "', 30);");
    }

    protected void respond(AjaxRequestTarget target) {
        StringValue uuidParam = this.getComponent().getRequest().getRequestParameters().getParameterValue(PARAM_WINDOW_NAME);
        if (!this.windowName.equals(uuidParam.toString())) {
            this.onNewWindow(target);
        }
    }

    protected abstract void onNewWindow(AjaxRequestTarget var1);
}

