/*
 * Decompiled with CFR 0.152.
 */
package org.opensciencegrid.authz.service;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Category;
import org.opensaml.SAMLAction;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSubject;
import org.opensciencegrid.authz.common.GridId;
import org.opensciencegrid.authz.common.LocalId;
import org.opensciencegrid.authz.saml.XACMLObligation;
import org.opensciencegrid.authz.service.GRIDIdentityMappingService;
import org.opensciencegrid.authz.service.SAMLAuthZServiceBase;

public class BasicMappingAuthZService
extends SAMLAuthZServiceBase {
    GRIDIdentityMappingService mapService;
    protected String serviceIdentity = "BasicMappingAuthZService";
    static Category log = Category.getInstance((String)BasicMappingAuthZService.class.getName());

    public BasicMappingAuthZService(GRIDIdentityMappingService gRIDIdentityMappingService) {
        this.mapService = gRIDIdentityMappingService;
    }

    protected SAMLAuthZServiceBase.AuthzDecision authorize(SAMLSubject sAMLSubject, String string, Iterator iterator, Iterator iterator2) throws SAMLException {
        log.debug((Object)("entered authorize method of: " + this.serviceIdentity));
        SAMLAuthZServiceBase.AuthzDecision authzDecision = new SAMLAuthZServiceBase.AuthzDecision();
        authzDecision.issuer = this.serviceIdentity;
        ArrayList<SAMLAction> arrayList = new ArrayList<SAMLAction>(1);
        arrayList.add(new SAMLAction("opensciencegrid:authorization", "access_as_local_identity"));
        log.debug((Object)"This service supports only the following action: access_as_local_identity");
        authzDecision.actions = this.locatePermissibleActions(iterator, arrayList);
        if (authzDecision.actions != null) {
            log.debug((Object)"Supported action is requested");
            log.debug((Object)"Checking if VOMS attribute (FQAN) is present in Subject Evidence");
            SAMLAuthZServiceBase.FQAN fQAN = this.findFQANinSubjectEvidence(iterator2, sAMLSubject);
            if (fQAN != null) {
                log.debug((Object)("found VOMS attribute with data \"" + fQAN.data + "\" from \"" + fQAN.issuer + "\""));
            } else {
                log.debug((Object)"no VOMS attribute found in Subject evidence");
            }
            GridId gridId = new GridId();
            gridId.setUserDN(sAMLSubject.getName().getName());
            gridId.setHostDN(string);
            if (fQAN != null) {
                gridId.setUserFQAN(fQAN.data);
                gridId.setUserFQANIssuer(fQAN.issuer);
            }
            log.debug((Object)"Request mapping from mapping service");
            LocalId localId = null;
            try {
                localId = this.mapService.mapCredentials(gridId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (localId != null) {
                log.debug((Object)"Received PERMIT decision from mapping service");
                authzDecision.decision = "Permit";
                authzDecision.obligations = this.createObligations(localId);
            } else {
                log.debug((Object)"Received DENY decision from mapping service");
                authzDecision.decision = "Deny";
            }
        } else {
            log.debug((Object)"No supported action was requested, responding with indeterminate");
            authzDecision.decision = "Indeterminate";
            log.debug((Object)"Setting actions to mapping action, obligations to null");
            authzDecision.actions = new ArrayList(1);
            authzDecision.actions.add(new SAMLAction("opensciencegrid:authorization", "access_as_local_identity"));
            authzDecision.obligations = null;
        }
        return authzDecision;
    }

    private ArrayList createObligations(LocalId localId) throws SAMLException {
        String[] stringArray;
        ArrayList<XACMLObligation> arrayList = new ArrayList<XACMLObligation>();
        String string = localId.getUserName();
        if (string != null) {
            arrayList.add(new XACMLObligation("opensciencegrid:authorization:UserIdObligation", "Permit", "opensciencegrid:authorization:attribute:UserId", "http://www.w3.org/2001/XMLSchema#string", string));
        }
        if ((string = localId.getGroupName()) != null) {
            arrayList.add(new XACMLObligation("opensciencegrid:authorization:GroupIdObligation", "Permit", "opensciencegrid:authorization:attribute:GroupId", "http://www.w3.org/2001/XMLSchema#string", string));
        }
        if ((stringArray = localId.getSupplementalGroupNames()) != null) {
            string = stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string.concat(" " + stringArray[i]);
            }
            arrayList.add(new XACMLObligation("opensciencegrid:authorization:SupGroupIdsObligation", "Permit", "opensciencegrid:authorization:attribute:SupGroupIds", "http://www.w3.org/2001/XMLSchema#string", string));
        }
        if ((string = localId.getRootPath()) != null) {
            arrayList.add(new XACMLObligation("opensciencegrid:authorization:RootPathObligation", "Permit", "opensciencegrid:authorization:attribute:RootPath", "http://www.w3.org/2001/XMLSchema#string", string));
        }
        if ((string = localId.getRelativeHomePath()) != null) {
            arrayList.add(new XACMLObligation("opensciencegrid:authorization:RelHomePathObligation", "Permit", "opensciencegrid:authorization:attribute:RelHomePath", "http://www.w3.org/2001/XMLSchema#string", string));
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }
}

