/*
 * Decompiled with CFR 0.152.
 */
package org.opensciencegrid.authz.saml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Category;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLAction;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAuthorizationDecisionStatement;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSubject;
import org.opensaml.XML;
import org.opensciencegrid.authz.saml.XACMLObligation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ObligatedAuthorizationDecisionStatement
extends SAMLAuthorizationDecisionStatement {
    private ArrayList xacmlObligations = null;
    static Category log = Category.getInstance((String)ObligatedAuthorizationDecisionStatement.class.getName());

    public ObligatedAuthorizationDecisionStatement(SAMLSubject sAMLSubject, String string, String string2, Collection collection, Collection collection2, Collection collection3) throws SAMLException {
        super(sAMLSubject, string, string2, collection, collection2);
        if (collection3 == null) {
            throw new SAMLException(SAMLException.RESPONDER, "ObligatedAuthorizationDecisionStatement() requires at least one obligation");
        }
        this.xacmlObligations = new ArrayList(1);
        this.xacmlObligations.addAll(collection3);
        log.debug((Object)"instantiated ObligatedAuthorizationDecisionStatement through default constructor");
    }

    public ObligatedAuthorizationDecisionStatement(Element element) throws SAMLException {
        super(element);
        log.debug((Object)"Constructing ObligatedAuthorizationDecisionStatement from DOM tree");
        this.fromDOM(element);
    }

    public ObligatedAuthorizationDecisionStatement(InputStream inputStream) throws SAMLException {
        super(ObligatedAuthorizationDecisionStatement.fromStream((InputStream)inputStream));
        log.debug((Object)"Constructing ObligatedAuthorizationDecisionStatement from a stream");
        this.fromDOM(ObligatedAuthorizationDecisionStatement.fromStream((InputStream)inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        Node node;
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed((Element)element, (String)"opensciencegrid:authorization:saml", (String)"ObligatedAuthorizationDecisionStatement")) {
            node = QName.getQNameAttribute((Element)element, (String)"http://www.w3.org/2001/XMLSchema-instance", (String)"type");
            if (!(XML.isElementNamed((Element)element, (String)"urn:oasis:names:tc:SAML:1.0:protocol", (String)"Statement") && XML.isElementNamed((Element)element, (String)"urn:oasis:names:tc:SAML:1.0:protocol", (String)"SubjectStatement") && node != null && "opensciencegrid:authorization:saml".equals(node.getNamespaceURI()) && "ObligatedAuthorizationDecisionStatementType".equals(node.getLocalName()))) {
                throw new MalformedException(SAMLException.REQUESTER, "ObligatedAuthorizationDecisionStatement.fromDOM() requires opensciencegrid:authorization:saml:ObligatedAuthorizationDecisionStatement at root");
            }
        }
        for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !XML.isElementNamed((Element)((Element)node), (String)"opensciencegrid:authorization:saml", (String)"XACMLObligation")) continue;
            if (this.xacmlObligations == null) {
                this.xacmlObligations = new ArrayList(1);
            }
            this.xacmlObligations.add(new XACMLObligation((Element)node));
        }
    }

    public Iterator getXACMLObligations() {
        if (this.xacmlObligations == null) {
            return new ArrayList(0).iterator();
        }
        return this.xacmlObligations.iterator();
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        log.debug((Object)"returning DOM tree with ObligatedAuthorizationDecisionStatement");
        Element element = document.createElementNS("opensciencegrid:authorization:saml", "ObligatedAuthorizationDecisionStatement");
        element.setAttributeNS(null, "Resource", this.getResource());
        element.setAttributeNS(null, "Decision", this.getDecision());
        element.appendChild(this.getSubject().toDOM(document));
        Iterator iterator = this.getActions();
        while (iterator.hasNext()) {
            element.appendChild(((SAMLAction)iterator.next()).toDOM(document));
        }
        iterator = this.getEvidence();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof SAMLAssertion) {
                element.appendChild(((SAMLAssertion)e).toDOM(document));
                continue;
            }
            if (!(e instanceof String)) continue;
            element.appendChild(document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference")).appendChild(document.createTextNode((String)e));
        }
        iterator = this.getXACMLObligations();
        while (iterator.hasNext()) {
            element.appendChild(((XACMLObligation)iterator.next()).toDOM(document));
        }
        this.root = element;
        return this.root;
    }
}

