/*
 * Decompiled with CFR 0.152.
 */
package org.opensciencegrid.authz.client;

import java.io.File;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Category;
import org.glite.security.voms.VOMSAttribute;
import org.glite.security.voms.VOMSValidator;
import org.glite.security.voms.ac.AttributeCertificate;
import org.globus.gsi.gssapi.GSSConstants;
import org.gridforum.jgss.ExtendedGSSContext;
import org.opensaml.SAMLSubject;
import org.opensciencegrid.authz.client.GRIDIdentityMappingServiceClient;
import org.opensciencegrid.authz.client.SAMLAuthZClientBase;
import org.opensciencegrid.authz.common.LocalId;
import org.opensciencegrid.authz.service.StorageAuthorizationServiceImpl;

public class PRIMAAuthzModule
extends SAMLAuthZClientBase {
    private URL serviceLocation;
    private String requestedServiceName;
    private String gssIdentity;
    private String fqanValue;
    static Category log = Category.getInstance((String)GRIDIdentityMappingServiceClient.class.getName());

    public PRIMAAuthzModule(URL uRL) throws ServiceException {
        this.serviceLocation = uRL;
        this.requestedServiceName = "";
    }

    public void setRequestedServiceName(String string) {
        this.requestedServiceName = string;
    }

    public LocalId mapCredentials(String string, String string2, String string3, String string4) throws Exception {
        this.requestedServiceName = string3;
        this.gssIdentity = string;
        this.fqanValue = string2;
        SAMLSubject sAMLSubject = this.getSAMLSubjectFromString(this.gssIdentity);
        ArrayList arrayList = null;
        if (string4 == null && this.fqanValue != null && this.fqanValue.length() != 0) {
            arrayList = this.createFQANEvidenceFromString(sAMLSubject, this.gssIdentity, this.fqanValue);
        } else if (this.gssIdentity != null && this.gssIdentity.length() != 0 && string4 != null && string4.length() != 0) {
            arrayList = this.createFQANEvidenceFromString(sAMLSubject, this.gssIdentity, string4);
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        return this.mapCredentials(sAMLSubject, arrayList);
    }

    public LocalId mapCredentials(ExtendedGSSContext extendedGSSContext, String string, String string2) throws Exception {
        X509Certificate[] x509CertificateArray = (X509Certificate[])extendedGSSContext.inquireByOid(GSSConstants.X509_CERT_CHAIN);
        VOMSValidator vOMSValidator = new VOMSValidator(x509CertificateArray);
        vOMSValidator.parse();
        List list = vOMSValidator.getVOMSAttributes();
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            VOMSAttribute vOMSAttribute = (VOMSAttribute)iterator.next();
            AttributeCertificate attributeCertificate = vOMSAttribute.getAC();
            String string3 = attributeCertificate.getIssuer().toString();
            log.debug((Object)("VOMS Server is '" + string3 + "'"));
            List list2 = vOMSAttribute.getFullyQualifiedAttributes();
            Iterator iterator2 = list2.iterator();
            if (iterator2.hasNext()) {
                this.fqanValue = (String)iterator2.next();
                log.debug((Object)("FQAN is '" + this.fqanValue + "'"));
            } else {
                log.error((Object)"No FQAN found");
            }
        } else {
            log.error((Object)"No attribute found");
        }
        this.requestedServiceName = ((Object)extendedGSSContext.getTargName()).toString();
        this.gssIdentity = ((Object)extendedGSSContext.getSrcName()).toString();
        return this.mapCredentials(this.gssIdentity, this.fqanValue, string, string2);
    }

    public LocalId mapCredentials(File file, String string, String string2) throws Exception {
        return null;
    }

    public LocalId mapCredentials(String string, String string2, String string3) throws Exception {
        this.requestedServiceName = string2;
        SAMLSubject sAMLSubject = this.getSAMLSubjectFromString(string);
        ArrayList arrayList = string != null && string.length() != 0 && string3 != null && string3.length() != 0 ? this.createFQANEvidenceFromString(sAMLSubject, string, string3) : new ArrayList();
        return this.mapCredentials(sAMLSubject, arrayList);
    }

    private LocalId mapCredentials(String string) throws Exception {
        String string2 = System.getProperty("voms.cert.dir");
        log.debug((Object)("dir " + string2));
        String string3 = null;
        String string4 = null;
        log.debug((Object)("gssIdentity --------->" + this.gssIdentity));
        SAMLSubject sAMLSubject = this.getSAMLSubjectFromString(this.gssIdentity);
        ArrayList arrayList = null;
        if (string == null && string3 != null && string3.length() != 0 && string4 != null && string4.length() != 0) {
            arrayList = this.createFQANEvidenceFromString(sAMLSubject, string3, string4);
        } else if (this.gssIdentity != null && this.gssIdentity.length() != 0 && string != null && string.length() != 0) {
            arrayList = this.createFQANEvidenceFromString(sAMLSubject, this.gssIdentity, string);
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        return this.mapCredentials(sAMLSubject, arrayList);
    }

    private LocalId mapCredentials(SAMLSubject sAMLSubject, ArrayList arrayList) throws Exception {
        LocalId localId = null;
        ArrayList arrayList2 = this.createMappingActions();
        StorageAuthorizationServiceImpl storageAuthorizationServiceImpl = new StorageAuthorizationServiceImpl();
        localId = storageAuthorizationServiceImpl.authorize_local_id(sAMLSubject, this.requestedServiceName, arrayList2.iterator(), arrayList.iterator(), this.serviceLocation);
        return localId;
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 3) {
                System.out.println(" Usage java org.opensciencegrid.authz.client.PRIMAAuthzModule <serviceLocation> <proxyFile> <requestedServiceName> [desiredIdentity]");
                System.exit(0);
            }
            PRIMAAuthzModule pRIMAAuthzModule = new PRIMAAuthzModule(new URL(stringArray[0]));
            pRIMAAuthzModule.setRequestedServiceName(stringArray[2]);
            LocalId localId = null;
            localId = stringArray.length == 4 ? pRIMAAuthzModule.mapCredentials(stringArray[1], "", stringArray[3]) : pRIMAAuthzModule.mapCredentials(stringArray[1], "", null);
            if (localId != null) {
                System.out.println("Access may be granted with the following local identity qualifications:");
                System.out.println("user name:                " + localId.getUserName());
                System.out.println("primary group name:       " + localId.getGroupName());
                System.out.println("supplemental group names: " + localId.getSupplementalGroupNames());
                System.out.println("root directory:           " + localId.getRootPath());
                System.out.println("relative home directory:  " + localId.getRelativeHomePath());
                System.out.println("FS root directory:        " + localId.getFSRootPath());
                System.out.println("UID:  " + localId.getUID());
                System.out.println("GID:  " + localId.getGID());
                System.out.println("Priority:  " + localId.getPriority());
                System.out.println("ReadOnly:  " + localId.getReadOnlyFlag());
            } else {
                System.out.println("Not authorized - no mapping could be retrieved");
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }
}

