/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util.proxy;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralSubtree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyRestrictionData {
    private static final Logger LOGGER = Logger.getLogger(ProxyRestrictionData.class);
    private Vector<GeneralSubtree> m_permittedGeneralSubtrees = new Vector();
    private Vector<GeneralSubtree> m_excludedGeneralSubtrees = new Vector();
    public static final String SOURCE_RESTRICTION_OID = "1.2.840.113612.5.5.1.1.2.1";
    public static final String TARGET_RESTRICTION_OID = "1.2.840.113612.5.5.1.1.2.2";

    public ProxyRestrictionData(byte[] bytes) throws IOException {
        ASN1Sequence nameSpaceRestrictionsSeq = (ASN1Sequence)ASN1Object.fromByteArray((byte[])bytes);
        switch (nameSpaceRestrictionsSeq.size()) {
            case 0: {
                return;
            }
            case 1: {
                DERTaggedObject taggedSequence = (DERTaggedObject)nameSpaceRestrictionsSeq.getObjectAt(0);
                if (taggedSequence.getTagNo() == 0) {
                    ProxyRestrictionData.copyCondSequenceToVector((DERSequence)taggedSequence.getObject(), this.m_permittedGeneralSubtrees);
                    break;
                }
                if (taggedSequence.getTagNo() == 1) {
                    ProxyRestrictionData.copyCondSequenceToVector((DERSequence)taggedSequence.getObject(), this.m_excludedGeneralSubtrees);
                    break;
                }
                LOGGER.error((Object)("Illegal tag number in the proxy restriction NameConstraints data structure: " + taggedSequence.getTagNo() + ", should have been 0 or 1"));
                throw new IllegalArgumentException("Illegal tag number in the proxy restriction NameConstraints data structure: " + taggedSequence.getTagNo() + ", should have been 0 or 1");
            }
            case 2: {
                DERTaggedObject taggedSequence = (DERTaggedObject)nameSpaceRestrictionsSeq.getObjectAt(0);
                if (taggedSequence.getTagNo() != 0) {
                    LOGGER.error((Object)("Illegal tag number in the proxy restriction NameConstraints data structure: " + taggedSequence.getTagNo() + ", should have been 0"));
                    throw new IllegalArgumentException("Illegal tag number in the proxy restriction NameConstraints data structure: " + taggedSequence.getTagNo() + ", should have been 0");
                }
                ProxyRestrictionData.copyCondSequenceToVector((DERSequence)taggedSequence.getObject(), this.m_permittedGeneralSubtrees);
                taggedSequence = (DERTaggedObject)nameSpaceRestrictionsSeq.getObjectAt(1);
                if (taggedSequence.getTagNo() == 1) {
                    ProxyRestrictionData.copyCondSequenceToVector((DERSequence)taggedSequence.getObject(), this.m_excludedGeneralSubtrees);
                    break;
                }
                LOGGER.error((Object)("Illegal tag number in the proxy restriction NameConstraints data structure: " + taggedSequence.getTagNo() + ", should have been 1"));
                throw new IllegalArgumentException("Illegal tag number in the proxy restriction NameConstraints data structure: " + taggedSequence.getTagNo() + ", should have been 1");
            }
            default: {
                LOGGER.error((Object)("Illegal number of items in the proxy restriction NameConstraints data structure: " + nameSpaceRestrictionsSeq.size() + ", should have been 0 to 2"));
                throw new IllegalArgumentException("Illegal number of items in the proxy restriction NameConstraints data structure: " + nameSpaceRestrictionsSeq.size() + ", should have been 0 to 2");
            }
        }
    }

    public ProxyRestrictionData() {
    }

    private static void copyCondSequenceToVector(DERSequence subSeq, Vector<GeneralSubtree> vector) {
        Enumeration subTreeEnum = subSeq.getObjects();
        while (subTreeEnum.hasMoreElements()) {
            DERObject object = (DERObject)subTreeEnum.nextElement();
            vector.add(new GeneralSubtree((ASN1Sequence)object));
        }
    }

    public void addPermittedIPAddressWithNetmask(String address) {
        this.m_permittedGeneralSubtrees.add(new GeneralSubtree(new GeneralName(7, address), null, null));
    }

    public void addExcludedIPAddressWithNetmask(String address) {
        this.m_excludedGeneralSubtrees.add(new GeneralSubtree(new GeneralName(7, address), null, null));
    }

    public DERSequence getNameConstraints() {
        ASN1EncodableVector nameConstraintsSequenceVector = new ASN1EncodableVector();
        ProxyRestrictionData.addTaggedSequenceOfSubtrees(0, this.m_permittedGeneralSubtrees, nameConstraintsSequenceVector);
        ProxyRestrictionData.addTaggedSequenceOfSubtrees(1, this.m_excludedGeneralSubtrees, nameConstraintsSequenceVector);
        return new DERSequence((DEREncodableVector)nameConstraintsSequenceVector);
    }

    private static void addTaggedSequenceOfSubtrees(int tagNo, Vector<GeneralSubtree> subtrees, ASN1EncodableVector asn1Vector) {
        if (!subtrees.isEmpty()) {
            ASN1EncodableVector subtreesSequenceVector = new ASN1EncodableVector();
            Enumeration<GeneralSubtree> generalSubtreesEnum = subtrees.elements();
            while (generalSubtreesEnum.hasMoreElements()) {
                subtreesSequenceVector.add((DEREncodable)generalSubtreesEnum.nextElement());
            }
            asn1Vector.add((DEREncodable)new DERTaggedObject(tagNo, (DEREncodable)new DERSequence((DEREncodableVector)subtreesSequenceVector)));
        }
    }

    public byte[][][] getIPSpaces() {
        byte[][] allowedIPSpaces = ProxyRestrictionData.subtreesIntoArray(this.m_permittedGeneralSubtrees);
        byte[][] excludedIPSpaces = ProxyRestrictionData.subtreesIntoArray(this.m_excludedGeneralSubtrees);
        return new byte[][][]{allowedIPSpaces, excludedIPSpaces};
    }

    private static byte[][] subtreesIntoArray(Vector<GeneralSubtree> subtrees) {
        if (subtrees == null) {
            return null;
        }
        Vector<byte[]> ips = new Vector<byte[]>();
        Enumeration<GeneralSubtree> enumGeneralNames = subtrees.elements();
        while (enumGeneralNames.hasMoreElements()) {
            GeneralName item = enumGeneralNames.nextElement().getBase();
            if (item.getTagNo() != 7) continue;
            ASN1OctetString octets = (ASN1OctetString)item.getName();
            byte[] bytes = octets.getOctets();
            ips.add(bytes);
        }
        return (byte[][])ips.toArray((T[])new byte[0][0]);
    }
}

