/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util.proxy;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.JDKKeyPairGenerator;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.glite.security.util.PrivateKeyReader;
import org.glite.security.util.proxy.ProxyCertInfoExtension;
import org.glite.security.util.proxy.ProxyCertUtil;
import org.glite.security.util.proxy.ProxyCertificateInfo;
import org.glite.security.util.proxy.ProxyPolicy;
import org.glite.security.util.proxy.ProxyRestrictionData;
import org.glite.security.util.proxy.ProxyTracingExtension;

public class ProxyCertificateGenerator {
    private static final Logger LOGGER = Logger.getLogger(ProxyCertificateGenerator.class);
    private X509Certificate m_parentCert = null;
    private X509Certificate[] m_parentCertChain = null;
    private X509Name m_baseName = null;
    private PrivateKey m_privateKey = null;
    private PublicKey m_publicKey = null;
    private int m_lifetime = 43200;
    private X509V3CertificateGenerator m_certGen = null;
    private X509Certificate m_newProxy = null;
    private BigInteger m_serialNumber = null;
    private String m_proxyPolicyOID = null;
    private DEROctetString m_proxyPolicyOctets = null;
    private X509Name m_newDN = null;
    private int m_type = -1;
    private boolean m_limited = false;
    private int m_keyLength = 1024;
    private int m_pathLenLimit = Integer.MAX_VALUE;
    public static final int DEFAULT_PROXY_TYPE = 54;
    public static final int DEFAULT_KEY_LENGTH = 1024;

    public ProxyCertificateGenerator(X509Certificate[] parentCertChain) {
        this.m_parentCertChain = parentCertChain;
        this.m_parentCert = parentCertChain[0];
        this.m_baseName = (X509Name)this.m_parentCert.getSubjectDN();
        ProxyCertificateInfo parentProxyInfo = new ProxyCertificateInfo(this.m_parentCert);
        this.m_type = parentProxyInfo.getProxyType();
        this.m_certGen = new X509V3CertificateGenerator();
    }

    public ProxyCertificateGenerator(X509Certificate parentCert) {
        this(new X509Certificate[]{parentCert});
    }

    public ProxyCertificateGenerator(X509Certificate[] parentCertChain, PKCS10CertificationRequest certReq) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        this(parentCertChain);
        BigInteger sn;
        this.m_publicKey = certReq.getPublicKey();
        this.m_newDN = certReq.getCertificationRequestInfo().getSubject();
        if (this.m_type == 99 && ProxyCertificateInfo.isLegacyDN(this.m_newDN)) {
            this.m_type = 52;
        }
        if (this.m_type != 52 && (sn = ProxyCertUtil.getSN(this.m_newDN)) != null) {
            this.m_serialNumber = sn;
        }
        this.m_certGen = new X509V3CertificateGenerator();
    }

    public ProxyCertificateGenerator(X509Certificate parentCert, PKCS10CertificationRequest certReq) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        this(new X509Certificate[]{parentCert}, certReq);
    }

    public void setLifetime(int lifetime) {
        this.m_lifetime = lifetime;
    }

    public void addExtension(String oid, boolean critical, DEREncodable value) {
        this.m_certGen.addExtension(new DERObjectIdentifier(oid), critical, value);
    }

    private void setupBasicProxy() {
        this.setupDates();
        this.m_certGen.setPublicKey(this.m_publicKey);
        this.m_certGen.setSignatureAlgorithm(this.m_parentCert.getSigAlgName());
        this.m_certGen.addExtension(X509Extensions.KeyUsage, false, (DEREncodable)new KeyUsage(176));
    }

    public void generate(PrivateKey privateKey) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, CertificateEncodingException {
        if (this.m_publicKey == null) {
            if (this.m_privateKey != null && this.m_publicKey == null) {
                throw new IllegalArgumentException("Only private key of the proxy is set. As it is, also public key has to be set.");
            }
            this.generateKeys();
        }
        if (this.m_type == 99) {
            this.m_type = 54;
        }
        switch (this.m_type) {
            case 52: {
                this.setupOldProxy(this.m_limited);
                break;
            }
            case 54: {
                this.setupRFC3280Proxy(this.m_serialNumber, this.m_proxyPolicyOID, this.m_proxyPolicyOctets, this.m_pathLenLimit, true);
                break;
            }
            case 53: {
                this.setupRFC3280Proxy(this.m_serialNumber, this.m_proxyPolicyOID, this.m_proxyPolicyOctets, this.m_pathLenLimit, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown or unsupported proxy type");
            }
        }
        this.m_certGen.setIssuerDN(this.m_baseName);
        this.m_newProxy = this.m_certGen.generate(privateKey);
    }

    private void generateKeys() {
        JDKKeyPairGenerator.RSA keyPairGen = new JDKKeyPairGenerator.RSA();
        keyPairGen.initialize(this.m_keyLength, new SecureRandom());
        KeyPair pair = keyPairGen.generateKeyPair();
        this.m_privateKey = pair.getPrivate();
        this.m_publicKey = pair.getPublic();
    }

    public X509Certificate[] getCertChain() {
        X509Certificate[] newChain = new X509Certificate[this.m_parentCertChain.length + 1];
        for (int i = 0; i < this.m_parentCertChain.length; ++i) {
            newChain[i + 1] = this.m_parentCertChain[i];
        }
        newChain[0] = this.m_newProxy;
        return newChain;
    }

    public PrivateKey getPrivateKey() {
        return this.m_privateKey;
    }

    public String getCertChainAsPEM() throws IOException {
        X509Certificate[] newChain = this.getCertChain();
        StringWriter writer = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)writer);
        for (int i = 0; i < newChain.length; ++i) {
            pemWriter.writeObject((Object)newChain[i]);
        }
        pemWriter.flush();
        return writer.toString();
    }

    public String getPrivateKeyAsPEM() {
        return PrivateKeyReader.getPEM(this.m_privateKey);
    }

    public String getProxyAsPEM() throws IOException {
        StringWriter writer = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)writer);
        pemWriter.writeObject((Object)this.m_newProxy);
        pemWriter.write(this.getPrivateKeyAsPEM());
        for (int i = this.m_parentCertChain.length - 1; i >= 0; --i) {
            pemWriter.writeObject((Object)this.m_parentCertChain[i]);
        }
        pemWriter.flush();
        return writer.toString();
    }

    public X509Name generateDN(X509Name basename, String inputCN, boolean limited) {
        if (basename == null) {
            throw new IllegalArgumentException("generateDN: no basename given, can't generate DN.");
        }
        String newCN = inputCN == null ? this.guessCN(basename, limited) : inputCN;
        ASN1EncodableVector newCnPart = new ASN1EncodableVector();
        newCnPart.add((DEREncodable)X509Name.CN);
        newCnPart.add((DEREncodable)new DERPrintableString(newCN));
        ASN1Sequence subjectSequence = (ASN1Sequence)basename.getDERObject();
        Enumeration subjectParts = subjectSequence.getObjects();
        ASN1EncodableVector subjectVector = new ASN1EncodableVector();
        while (subjectParts.hasMoreElements()) {
            DERObject part = (DERObject)subjectParts.nextElement();
            subjectVector.add((DEREncodable)part);
        }
        subjectVector.add((DEREncodable)new DERSet((DEREncodable)new DERSequence((DEREncodableVector)newCnPart)));
        DERSequence subjDerSeq = new DERSequence((DEREncodableVector)subjectVector);
        X509Name proxySubject = new X509Name((ASN1Sequence)subjDerSeq);
        LOGGER.debug((Object)("SubjectDN :" + proxySubject));
        return proxySubject;
    }

    private String guessCN(X509Name basename, boolean addLimited) {
        String cn;
        int rdns;
        ASN1Sequence subjectSequence = (ASN1Sequence)basename.getDERObject();
        DERSet rdn = (DERSet)subjectSequence.getObjectAt((rdns = subjectSequence.size()) - 1);
        DERSequence rdnSequence = (DERSequence)rdn.getObjectAt(0);
        DERObjectIdentifier oid = (DERObjectIdentifier)rdnSequence.getObjectAt(0);
        String newCN = oid.equals((Object)X509Name.CN) ? ((cn = rdnSequence.getObjectAt(1).toString()).equals("proxy") ? (addLimited ? "limited proxy" : "proxy") : (cn.equals("limited proxy") ? "limited proxy" : this.getSerialNumber().toString())) : this.getSerialNumber().toString();
        return newCN;
    }

    private void setupDNs(String newCn) {
        X509Name proxySubject;
        ASN1Sequence seqSubject = (ASN1Sequence)this.m_baseName.getDERObject();
        ASN1EncodableVector newCnPart = new ASN1EncodableVector();
        newCnPart.add((DEREncodable)X509Name.CN);
        newCnPart.add((DEREncodable)new DERPrintableString(newCn));
        Enumeration subjectParts = seqSubject.getObjects();
        ASN1EncodableVector subjectVector = new ASN1EncodableVector();
        while (subjectParts.hasMoreElements()) {
            DERObject part = (DERObject)subjectParts.nextElement();
            subjectVector.add((DEREncodable)part);
        }
        subjectVector.add((DEREncodable)new DERSet((DEREncodable)new DERSequence((DEREncodableVector)newCnPart)));
        DERSequence subjDerSeq = new DERSequence((DEREncodableVector)subjectVector);
        this.m_newDN = proxySubject = new X509Name((ASN1Sequence)subjDerSeq);
        LOGGER.debug((Object)("SubjectDN :" + proxySubject));
        this.m_certGen.setSubjectDN(proxySubject);
        this.m_certGen.setIssuerDN(this.m_baseName);
    }

    public void setType(int type) throws IllegalArgumentException {
        if (this.m_type == type) {
            return;
        }
        if (type == 52 || type == 54 || type == 53) {
            if (this.m_type == 99) {
                this.m_type = type;
                return;
            }
            LOGGER.warn((Object)("The proxy type setting is not the one of the parent or the cert request. Setting is:" + type));
            this.m_type = type;
        }
        throw new IllegalArgumentException("Trying to set the proxy type into an unsupported type");
    }

    private void setupOldProxy(boolean limited) {
        if (limited) {
            this.setupDNs("limited proxy");
        } else {
            this.setupDNs("proxy");
        }
        this.setupBasicProxy();
        BigInteger serialNum = null;
        serialNum = this.m_parentCert.getSerialNumber();
        this.m_certGen.setSerialNumber(serialNum);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupRFC3280Proxy(BigInteger cn, String policyOID, DEROctetString policy, int pathLenLimit, boolean isRfc) {
        ProxyPolicy proxyPolicy;
        this.setupBasicProxy();
        BigInteger serial = cn == null ? this.getSerialNumber() : cn;
        this.m_certGen.setSerialNumber(serial);
        this.setupDNs(serial.toString());
        if (this.m_limited) {
            if (policyOID != null && policyOID != "1.3.6.1.4.1.3536.1.1.1.9") throw new IllegalArgumentException("Proxy info extension policy OID set to conflicting value when limiting proxy. OID is: " + policyOID);
            proxyPolicy = new ProxyPolicy("1.3.6.1.4.1.3536.1.1.1.9", (ASN1OctetString)policy);
        } else {
            proxyPolicy = new ProxyPolicy(policyOID, (ASN1OctetString)policy);
        }
        ProxyCertInfoExtension extension = new ProxyCertInfoExtension(pathLenLimit, proxyPolicy);
        if (isRfc) {
            this.m_certGen.addExtension("1.3.6.1.5.5.7.1.14", true, (DEREncodable)extension);
            return;
        } else {
            this.m_certGen.addExtension("1.3.6.1.4.1.3536.1.1.222", true, (DEREncodable)extension);
        }
    }

    private void setupDates() {
        Date parentNotAfter;
        GregorianCalendar date = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        date.add(12, -5);
        this.m_certGen.setNotBefore(date.getTime());
        date.add(12, 10);
        date.add(13, this.m_lifetime);
        if (this.m_parentCert != null && (parentNotAfter = this.m_parentCert.getNotAfter()).before(date.getTime())) {
            date.setTime(parentNotAfter);
        }
        this.m_certGen.setNotAfter(date.getTime());
    }

    public void setKeyLength(int length) {
        this.m_keyLength = length;
    }

    public void setLimited() {
        this.m_limited = true;
    }

    private BigInteger getSerialNumber() {
        if (this.m_serialNumber == null) {
            SecureRandom rand = new SecureRandom();
            this.m_serialNumber = BigInteger.valueOf(rand.nextInt()).abs();
        }
        return this.m_serialNumber;
    }

    public void setSerialNumber(BigInteger sn) {
        this.m_serialNumber = sn;
    }

    public void setPolicy(String oid, DEROctetString octets) {
        if (this.m_type == 52) {
            throw new IllegalArgumentException("Legacy proxies do not support setting the proxy policy.");
        }
        this.m_proxyPolicyOID = oid;
        this.m_proxyPolicyOctets = octets;
    }

    public void setProxyPathLimit(int pathLen) {
        if (this.m_type == 52) {
            throw new IllegalArgumentException("Legacy proxies do not support setting the proxy path length limit.");
        }
        this.m_pathLenLimit = pathLen;
    }

    public void setProxySourceRestrictions(ProxyRestrictionData data) {
        this.m_certGen.addExtension("1.2.840.113612.5.5.1.1.2.1", false, (DEREncodable)data.getNameConstraints());
    }

    public void setProxyTargetRestrictions(ProxyRestrictionData data) {
        this.m_certGen.addExtension("1.2.840.113612.5.5.1.1.2.2", false, (DEREncodable)data.getNameConstraints());
    }

    public void setProxyTracingIssuer(String url) {
        ProxyTracingExtension extension = new ProxyTracingExtension(url);
        this.m_certGen.addExtension("1.2.840.113612.5.5.1.1.1.1", false, (DEREncodable)extension.getNames());
    }

    public void setProxyTracingSubject(String url) {
        ProxyTracingExtension extension = new ProxyTracingExtension(url);
        this.m_certGen.addExtension("1.2.840.113612.5.5.1.1.1.2", false, (DEREncodable)extension.getNames());
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.insertProviderAt((Provider)new BouncyCastleProvider(), 6);
        }
    }
}

