/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bouncycastle.openssl.PasswordFinder;
import org.glite.security.util.FileCertReader;
import org.glite.security.util.PrivateKeyReader;

public class KeyStoreGenerator {
    static Logger logger = Logger.getLogger((String)KeyStoreGenerator.class.getName());

    public static KeyStore generate(String certFile, String keyFile, PasswordFinder finder, String storePasswd) throws Exception {
        FileCertReader reader = new FileCertReader();
        Vector identityChain = reader.readCerts(certFile);
        File file = new File(keyFile);
        FileReader fileReader = null;
        PrivateKey key = null;
        try {
            fileReader = new FileReader(file);
            BufferedReader buffReader = new BufferedReader(fileReader);
            key = PrivateKeyReader.read(buffReader, finder);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fileReader != null) {
                fileReader.close();
            }
        }
        KeyStore store = KeyStore.getInstance("JKS");
        Certificate[] chain = new X509Certificate[]{};
        chain = identityChain.toArray(chain);
        store.load(null, null);
        store.setKeyEntry("identity", key, storePasswd.toCharArray(), chain);
        return store;
    }
}

