/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.trustmanager;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Properties;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;

public class TimeoutSSLSocketFactory
extends SSLSocketFactory {
    private static final Logger LOGGER = Logger.getLogger((String)TimeoutSSLSocketFactory.class.getName());
    private static final String CONNECT_TIMEOUT_SYSTEM_PROPERTY = "sun.net.client.defaultConnectTimeout";
    private static final String READ_TIMEOUT_SYSTEM_PROPERTY = "sun.net.client.defaultReadTimeout";
    private SSLSocketFactory m_realFactory;
    private int m_connectTimeout = 0;
    private int m_readTimeout = 0;

    public TimeoutSSLSocketFactory(SSLSocketFactory realFactory, Properties config) {
        String connectTimeoutStr;
        this.m_realFactory = realFactory;
        String readTimeoutStr = config.getProperty("sslTimeout");
        if (readTimeoutStr == null) {
            readTimeoutStr = System.getProperty(READ_TIMEOUT_SYSTEM_PROPERTY);
        }
        if (readTimeoutStr != null) {
            try {
                this.m_readTimeout = Integer.parseInt(readTimeoutStr);
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)("Invalid value for property \"sun.net.client.defaultReadTimeout\": " + readTimeoutStr));
            }
        }
        if ((connectTimeoutStr = System.getProperty("sslConnectTimeout")) == null) {
            connectTimeoutStr = System.getProperty(CONNECT_TIMEOUT_SYSTEM_PROPERTY);
        }
        if (connectTimeoutStr != null) {
            try {
                this.m_connectTimeout = Integer.parseInt(connectTimeoutStr);
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)("Invalid value for property \"sun.net.client.defaultConnectTimeout\": " + connectTimeoutStr));
            }
        }
    }

    public void setTimeout(Socket socket) throws SocketException {
        if (this.m_readTimeout > 0) {
            LOGGER.debug((Object)("Read timeout set to:" + this.m_readTimeout));
            socket.setSoTimeout(this.m_readTimeout);
        }
        String[] ciphers = ((SSLSocket)socket).getEnabledCipherSuites();
        ArrayList<String> newCiphers = new ArrayList<String>(ciphers.length);
        for (int i = 0; i < ciphers.length; ++i) {
            if (ciphers[i].indexOf("RC4") != -1) continue;
            newCiphers.add(ciphers[i]);
        }
        ((SSLSocket)socket).setEnabledCipherSuites(newCiphers.toArray(new String[0]));
    }

    public String[] getDefaultCipherSuites() {
        return this.m_realFactory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.m_realFactory.getSupportedCipherSuites();
    }

    public Socket createSocket() throws IOException {
        Socket socket = this.m_realFactory.createSocket();
        this.setTimeout(socket);
        return socket;
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        System.out.println("createsocket(socket, host(" + host + "), port(" + port + "))");
        Socket socket = this.m_realFactory.createSocket(s, host, port, autoClose);
        this.setTimeout(socket);
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = this.m_realFactory.createSocket();
        this.setTimeout(socket);
        if (this.m_connectTimeout > 0) {
            socket.connect(new InetSocketAddress(host, port), this.m_connectTimeout);
        } else {
            socket.connect(new InetSocketAddress(host, port));
        }
        return socket;
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket socket = this.m_realFactory.createSocket();
        this.setTimeout(socket);
        if (this.m_connectTimeout > 0) {
            socket.connect(new InetSocketAddress(host, port), this.m_connectTimeout);
        } else {
            socket.connect(new InetSocketAddress(host, port));
        }
        return socket;
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        Socket socket = this.m_realFactory.createSocket(host, port, localHost, localPort);
        this.setTimeout(socket);
        return socket;
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.m_realFactory.createSocket(address, port, localAddress, localPort);
        this.setTimeout(socket);
        return socket;
    }
}

