/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.FieldBinding;
import jas.util.UnsupportedType;
import java.awt.Checkbox;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

class CheckboxFieldBinding
extends FieldBinding
implements ItemListener {
    private boolean m_oldVal = false;
    private Checkbox m_field;

    CheckboxFieldBinding(Checkbox field) {
        this.m_field = field;
        field.addItemListener(this);
    }

    @Override
    void set(Object value) throws UnsupportedType {
        if (!(value instanceof Boolean)) {
            throw new UnsupportedType(this.m_field, value.getClass());
        }
        boolean x = (Boolean)value;
        if (this.m_oldVal != x) {
            this.m_field.setState(x);
            this.m_oldVal = x;
        }
    }

    @Override
    Object get(Class type) throws UnsupportedType {
        if (type != Boolean.TYPE) {
            throw new UnsupportedType(this.m_field, type);
        }
        boolean x = this.m_field.getState();
        return new Boolean(x);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean x = this.m_field.getState();
        if (x != this.m_oldVal) {
            this.setChanged();
        }
        this.notifyObservers();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_oldVal = this.m_field.getState();
    }
}

