/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.util;

import jas.hist.HasScatterPlotData;
import jas.hist.Rebinnable2DHistogramData;
import jas.hist.ScatterEnumeration;
import jas.hist.ScatterPlotSource;
import jas.hist.util.ScatterSourceAdapter;

public class ScatterTwoDAdapter
extends ScatterSourceAdapter
implements Rebinnable2DHistogramData,
HasScatterPlotData {
    public ScatterTwoDAdapter(ScatterPlotSource source) {
        super(source);
    }

    @Override
    public double[][][] rebin(int Xbins, double Xmin, double Xmax, int Ybins, double Ymin, double Ymax, boolean wantErrors, boolean hurry, boolean overflow) {
        double[][] hist = new double[Xbins + (overflow ? 2 : 0)][Ybins + (overflow ? 2 : 0)];
        double XbinWidth = (Xmax - Xmin) / (double)Xbins;
        double YbinWidth = (Ymax - Ymin) / (double)Ybins;
        ScatterEnumeration e = overflow ? this.source.startEnumeration() : this.source.startEnumeration(Xmin, Xmax, Ymin, Ymax);
        double[] point = new double[2];
        while (e.getNextPoint(point)) {
            int Xbin = (int)Math.floor((point[0] - Xmin) / XbinWidth);
            int Ybin = (int)Math.floor((point[1] - Ymin) / YbinWidth);
            if (Xbin >= 0 && Xbin < Xbins && Ybin >= 0 && Ybin < Ybins) {
                double[] dArray = hist[Xbin];
                int n = Ybin;
                dArray[n] = dArray[n] + 1.0;
                continue;
            }
            if (!overflow) continue;
            if (Xbin < 0) {
                Xbin = Xbins;
            }
            if (Xbin > Xbins) {
                Xbin = Xbins + 1;
            }
            if (Ybin < 0) {
                Ybin = Ybins;
            }
            if (Ybin > Ybins) {
                Ybin = Ybins + 1;
            }
            double[] dArray = hist[Xbin];
            int n = Ybin;
            dArray[n] = dArray[n] + 1.0;
        }
        double[][][] result = new double[][][]{hist};
        return result;
    }

    @Override
    public int getXBins() {
        return 40;
    }

    @Override
    public int getYBins() {
        return 40;
    }

    @Override
    public boolean isRebinnable() {
        return true;
    }

    @Override
    public String[] getXAxisLabels() {
        return null;
    }

    @Override
    public String[] getYAxisLabels() {
        return null;
    }

    @Override
    public boolean hasScatterPlotData() {
        return true;
    }
}

